using System;
using Volpe.Cafe.Data;
namespace Volpe.Cafe.Model
{
    [Serializable]
    public class ModelingProgress : IModelingProgress
    {
        #region 
        public ModelingProgress(Scenario[] scenarios, ModelYear[] modelYears, Manufacturer[][] manufacturers)
            : this(scenarios, modelYears, manufacturers, null)
        {
        }
        public ModelingProgress(Scenario[] scenarios, ModelYear[] modelYears, Manufacturer[][] manufacturers,
            object additionalInfo)
        {
            this._scenarios      = scenarios;
            this._modelYears     = modelYears;
            this._manufacturers  = manufacturers;
            this._additionalInfo = additionalInfo;
        }
        #endregion
        #region 
        public override string ToString()
        {
            if (this._scenarios == null || this._scenarios.Length == 0)
            {
                return "No progress information available.";
            }
            else
            {   
                string progress = "";
                for (int i = 0, scenCount = this._scenarios.Length; i < scenCount; i++)
                {
                    progress += this.ToString(i) + new string('-', 25);
                }
                if (this._additionalInfo != null)
                {
                    progress += "AdditionalInfo: " + this._additionalInfo.ToString();
                }
                return progress;
            }
        }
        public virtual string ToString(int index)
        {
            Scenario  scen = (this._scenarios  == null || this._scenarios .Length <= index) ? null : this._scenarios [index];
            ModelYear year = (this._modelYears == null || this._modelYears.Length <= index) ? null : this._modelYears[index];
            Manufacturer[] mfrs = (this._manufacturers == null || this._manufacturers.Length <= index) ? null :
                this._manufacturers[index];
            string mfrsProgress = "N/A";
            if (mfrs != null && mfrs.Length > 0)
            {
                mfrsProgress = "";
                for (int i = 0, mfrCount = mfrs.Length; i < mfrCount; i++)
                {
                    if (mfrs[i] != null) { mfrsProgress += mfrs[i].Description.Name + ", "; }
                }
                if (mfrsProgress != "")  { mfrsProgress = mfrsProgress.Remove(mfrsProgress.Length - 2, 2); }
            }
            return
                "Scenario: "        + ((scen == null) ? "N/A" : scen.ToString()) +
                "\nModel Year: "    + ((year == null) ? "N/A" : year.ToString()) +
                "\nManufacturers: " + mfrsProgress;
        }
        #endregion
        #region 
        #region 
        public virtual Scenario[] Scenarios { get { return this._scenarios; } }
        public virtual ModelYear[] ModelYears { get { return this._modelYears; } }
        public virtual Manufacturer[][] Manufacturers { get { return this._manufacturers; } }
        public virtual object AdditionalInfo { get { return this._additionalInfo; } set { this._additionalInfo = value; } }
        #endregion
        #endregion
        #region 
        protected Scenario[] _scenarios;
        protected ModelYear[] _modelYears;
        protected Manufacturer[][] _manufacturers;
        protected object _additionalInfo;
        #endregion
    }
}

