using System;
using System.Net;
using System.Net.Sockets;
using System.Threading;
namespace Volpe.Net
{
    public class PortScanner
    {
        #region 
        public event PortScannerEventHandler HostAccepted;
        public event PortScannerEventHandler HostRejected;
        public event EventHandler ScanComplete;
        #endregion
        #region 
        public PortScanner()
        {
        }
        #endregion
        #region 
        protected virtual void OnHostAccepted(string addr, int port, TcpClient tcp)
        {
            if (this.HostAccepted != null)
            {
                this.HostAccepted(this, addr, port, tcp);
            }
        }
        protected virtual void OnHostRejected(string addr, int port, TcpClient tcp)
        {
            if (this.HostRejected != null)
            {
                this.HostRejected(this, addr, port, tcp);
            }
        }
        protected virtual void OnScanComplete()
        {
            if (this.ScanComplete != null)
            {
                this.ScanComplete(this, EventArgs.Empty);
            }
        }
        public void Start(string[] addrs, int[] ports)
        {
            this._addrs              = this.ExpandAddrs(addrs);
            this._ports              = ports;
            this._scannerThread      = new Thread(new ThreadStart(this.RunScanner));
            this._scannerThread.Name = "ScannerThread";
            this._scannerMutex       = new Mutex();
            this._scanning           = true;
            this._stop               = false;
            this._scannerThread.Start();
        }
        public void Stop()
        {
            this._stop = true;
        }
        private string[] ExpandAddrs(string[] addrs)
        {
            System.Collections.ArrayList list = new System.Collections.ArrayList(64);
            int addrCount = addrs.Length;
            for (int i = 0; i < addrCount; i++)
            {
                string addr = addrs[i];
                if (this.IsIpAddr(addr))
                {
                    string[] parts = addr.Split('.');
                    if (parts[3] == "*")
                    {   
                        string[] newAddrs = new string[256];
                        for (int j = 0; j < 256; j++)
                        {
                            newAddrs[j] = parts[0] + "." + parts[1] + "." + parts[2] + "." + j;
                        }
                        list.AddRange(this.ExpandAddrs(newAddrs));
                    }
                    else if (parts[2] == "*")
                    {   
                        string[] newAddrs = new string[256];
                        for (int j = 0; j < 256; j++)
                        {
                            newAddrs[j] = parts[0] + "." + parts[1] + "." + j + "." + parts[3];
                        }
                        list.AddRange(this.ExpandAddrs(newAddrs));
                    }
                    else if (parts[1] == "*")
                    {   
                        string[] newAddrs = new string[256];
                        for (int j = 0; j < 256; j++)
                        {
                            newAddrs[j] = parts[0] + "." + j + "." + parts[2] + "." + parts[3];
                        }
                        list.AddRange(this.ExpandAddrs(newAddrs));
                    }
                    else { list.Add(addr); }
                } 
                else { list.Add(addr); }
            } 
            return (string[])list.ToArray(typeof(string));
        }
        private bool IsIpAddr(string addr)
        {
            string[] parts = addr.Split('.');
            if (parts.Length == 4)
            {
                if (!Information.IsNumeric(parts[0])) { return false; }
                for (int i = 1; i < 4; i++)
                {
                    if (!Information.IsNumeric(parts[i]) && parts[i] != "*") { return false; }
                }
                return true;
            }
            return false;
        }
        private void RunScanner()
        {
            this._addrLen   = this._addrs.Length;
            this._portLen   = this._ports.Length;
            this._addrIndex = this._portIndex = 0;
            this._scannerThreadCount = (this._addrLen * this._portLen);
            if (this._scannerThreadCount > 1024) { this._scannerThreadCount = 1024; }    
            if ((this._scannerThreadCount >> 2) >= 32) { this._scannerThreadCount = this._scannerThreadCount >> 2; } 
            this._scannerThreads = new Thread[this._scannerThreadCount];
            for (int i = 0; i < this._scannerThreadCount; i++)
            {
                this._scannerThreads[i] = new Thread(new ThreadStart(this.RunScanner_Threaded));
                this._scannerThreads[i].Name = "ScannerThread" + i;
                this._scannerThreads[i].Start();
            }
            while (true)
            {
                bool isAlive = false;
                for (int i = 0; i < this._scannerThreadCount; i++)
                {
                    if (this._scannerThreads[i].IsAlive) { isAlive = true; break; }
                }
                if (!isAlive) { break; }
                Thread.Sleep(125);
            }
            this._scanning = false;
            this.OnScanComplete();
        }
        private void RunScanner_Threaded()
        {
            while (!this._stop && this._addrIndex < this._addrLen)
            {
                this._scannerMutex.WaitOne();
                if (this._addrIndex == this._addrLen) { return; }
                string addr = this._addrs[this._addrIndex];
                int    port = this._ports[this._portIndex];
                this._portIndex++;
                if (this._portIndex == this._portLen)
                {
                    this._portIndex = 0;
                    this._addrIndex++;
                }
                this._scannerMutex.ReleaseMutex();
                this.ConnectAddr(addr, port);
            }
        }
        private void ConnectAddr(string addr, int port)
        {
            if (1 > port || port > 65000) { return; }    
            TcpClient tcp = null;
            try
            {
                tcp = new TcpClient(addr, port);
                this.OnHostAccepted(addr, port, tcp);
            }
            catch
            {
                this.OnHostRejected(addr, port, null);
            }
            finally
            {
                if (tcp != null)
                {
                    try
                    {
                        NetworkStream stream = tcp.GetStream();
                        if (stream != null) { stream.Close(); }
                    }
                    catch {}
                    tcp.Close();
                }
            }
        }
        #endregion
        #region 
        public bool Scanning { get { return this._scanning; } }
        #endregion
        #region 
        bool     _stop;
        bool     _scanning;
        Thread   _scannerThread;
        int      _scannerThreadCount = 500;
        Thread[] _scannerThreads;
        Mutex    _scannerMutex;
        string[] _addrs;
        int   [] _ports;
        int _addrLen;
        int _portLen;
        int _addrIndex;
        int _portIndex;
        #endregion
    }
}

