using System;
namespace Volpe.Utils
{
    [Serializable]
    public class XlGridlinesFormat
    {
        #region 
        public XlGridlinesFormat()
            : this(true, true, false, XlColor.Automatic)
        {
        }
        public XlGridlinesFormat(bool hasMajorGridlines, bool majorGridlinesSolidBorder, bool majorGridlinesThickBorder,
            XlColor majorGridlinesColor)
            : this(hasMajorGridlines, majorGridlinesSolidBorder, majorGridlinesThickBorder, majorGridlinesColor, false, true,
                false, XlColor.Automatic)
        {
        }
        public XlGridlinesFormat(bool hasMajorGridlines, bool majorGridlinesSolidBorder, bool majorGridlinesThickBorder,
            XlColor majorGridlinesColor, bool hasMinorGridlines, bool minorGridlinesSolidBorder, bool minorGridlinesThickBorder,
            XlColor minorGridlinesColor)
        {
            this._hasMajorGridlines         = hasMajorGridlines;
            this._majorGridlinesSolidBorder = majorGridlinesSolidBorder;
            this._majorGridlinesThickBorder = majorGridlinesThickBorder;
            this._majorGridlinesColor       = majorGridlinesColor;
            this._hasMinorGridlines         = hasMinorGridlines;
            this._minorGridlinesSolidBorder = minorGridlinesSolidBorder;
            this._minorGridlinesThickBorder = minorGridlinesThickBorder;
            this._minorGridlinesColor       = minorGridlinesColor;
        }
        #endregion
        #region 
        public override string ToString()
        {
            return "{HasMajorGridlines="        + this._hasMajorGridlines +
                ", MajorGridlinesSolidBorder="  + this._majorGridlinesSolidBorder +
                ", MajorGridlinesThickBorder="  + this._majorGridlinesThickBorder +
                ", MajorGridlinesColor="        + this._majorGridlinesColor +
                ", HasMinorGridlines="          + this._hasMinorGridlines +
                ", MinorGridlinesSolidBorder="  + this._minorGridlinesSolidBorder +
                ", MinorGridlinesThickBorder="  + this._minorGridlinesThickBorder +
                ", MinorGridlinesColor="        + this._minorGridlinesColor + "}";
        }
        #endregion
        #region 
        public bool HasMajorGridlines
        {
            get { return this._hasMajorGridlines; }
            set { this._hasMajorGridlines = value; }
        }
        public bool MajorGridlinesSolidBorder
        {
            get { return this._majorGridlinesSolidBorder; }
            set { this._majorGridlinesSolidBorder = value; }
        }
        public bool MajorGridlinesThickBorder
        {
            get { return this._majorGridlinesThickBorder; }
            set { this._majorGridlinesThickBorder = value; }
        }
        public XlColor MajorGridlinesColor
        {
            get { return this._majorGridlinesColor; }
            set { this._majorGridlinesColor = value; }
        }
        public bool HasMinorGridlines
        {
            get { return this._hasMinorGridlines; }
            set { this._hasMinorGridlines = value; }
        }
        public bool MinorGridlinesSolidBorder
        {
            get { return this._minorGridlinesSolidBorder; }
            set { this._minorGridlinesSolidBorder = value; }
        }
        public bool MinorGridlinesThickBorder
        {
            get { return this._minorGridlinesThickBorder; }
            set { this._minorGridlinesThickBorder = value; }
        }
        public XlColor MinorGridlinesColor
        {
            get { return this._minorGridlinesColor; }
            set { this._minorGridlinesColor = value; }
        }
        #endregion
        #region 
        private bool _hasMajorGridlines;
        private bool _majorGridlinesSolidBorder;
        private bool _majorGridlinesThickBorder;
        private XlColor _majorGridlinesColor;
        private bool _hasMinorGridlines;
        private bool _minorGridlinesSolidBorder;
        private bool _minorGridlinesThickBorder;
        private XlColor _minorGridlinesColor;
        #endregion
    }
}

