using System;
namespace Volpe.Utils
{
    [Serializable]
    public class XlTickLabelsFormat
    {
        #region 
        public XlTickLabelsFormat()
            : this(XlTickLabelsFormat.DefaultFont, null)
        {
        }
        public XlTickLabelsFormat(XlFont font, string numberFormat)
            : this(font, numberFormat, 0)
        {
        }
        public XlTickLabelsFormat(XlFont font, string numberFormat, int textOrientation)
            : this(font, numberFormat, (numberFormat == null || numberFormat.Trim() == ""), 100, textOrientation)
        {
        }
        public XlTickLabelsFormat(XlFont font, string numberFormat, bool numberFormatLinked, int offset,
            int textOrientation)
        {
            this._font               = font;
            this._numberFormat       = numberFormat;
            this._numberFormatLinked = numberFormatLinked;
            this._offset             = (offset < 0) ? 0 : (offset > 1000) ? 1000 : offset;
            this._textOrientation    = (textOrientation < -90) ? -90 : (textOrientation > 90) ? 90 : textOrientation;
        }
        #endregion
        #region 
        public override string ToString()
        {
            return "{Font="             + this._font +
                ", NumberFormat="       + this._numberFormat +
                ", NumberFormatLinked=" + this._numberFormatLinked +
                ", Offset="             + this._offset +
                ", TextOrientation="    + this._textOrientation + "}";
        }
        #endregion
        #region 
        public XlFont Font
        {
            get { return this._font; }
            set { this._font = value; }
        }
        public string NumberFormat
        {
            get { return this._numberFormat; }
            set { this._numberFormat = value; }
        }
        public bool NumberFormatLinked
        {
            get { return this._numberFormatLinked; }
            set { this._numberFormatLinked = value; }
        }
        public int Offset
        {
            get { return this._offset; }
            set { this._offset = (value < 0) ? 0 : (value > 1000) ? 1000 : value; }
        }
        public int TextOrientation
        {
            get { return this._textOrientation; }
            set { this._textOrientation = (value < -90) ? -90 : (value > 90) ? 90 : value; }
        }
        #endregion
        #region 
        public static readonly XlFont DefaultFont = new XlFont("Arial", 10);
        private XlFont _font;
        private string _numberFormat;
        private bool _numberFormatLinked;
        private int _offset;
        private int _textOrientation;
        #endregion
    }
}

