using System;
using Volpe.Cafe;
using Volpe.Cafe.Collections;
using Volpe.Cafe.Data;
namespace Volpe.Cafe.Model
{
    [Serializable]
    public sealed class ComplianceProgress : ModelingProgress, IModelingProgress
    {
        #region 
        public ComplianceProgress(Scenario[] scenarios, ModelYear[] years, Manufacturer[][] mfrs)
            : this(scenarios, years, mfrs, null)
        {
        }
        public ComplianceProgress(Scenario[] scenarios, ModelYear[] years, Manufacturer[][] mfrs, object additionalInfo)
            : base(scenarios, years, mfrs, additionalInfo)
        {
        }
        #endregion
        #region 
        public override string ToString(int index)
        {
            string progress = base.ToString(index);
            Manufacturer[] mfrs = (this._manufacturers == null || this._manufacturers.Length <= index) ? null :
                this._manufacturers[index];
            if (mfrs != null)
            {
                for (int i = 0, mfrCount = mfrs.Length; i < mfrCount; i++)
                {
                    Manufacturer mfr = mfrs[i];
                    if (mfr != null)
                    {
                        ManufacturerModelingData mmd = mfr.ModelingData;
                        progress += "\r\n  "       + mfr.Description.Name +
                            "\r\n    Standard: "   + mmd.Standard.ToString(4) +
                            "\r\n    CAFE: "       + mmd.CAFE.ToString(4) +
                            "\r\n    Credits: "    + mmd.Credits.ToString(0) +
                            "\r\n    Fines: "      + mmd.Fines.ToString(0) +
                            "\r\n    Tech Costs: " + mmd.TechCost.ToString(0);
                    }
                }
            }
            return progress;
        }
        #endregion
    }
}

