#region << Using Directives >>
using System;
using System.Collections;
using System.Collections.Specialized;
using System.ComponentModel;
using System.Drawing;
using System.Diagnostics;
using System.IO;
using System.Reflection;
using System.Threading;
using System.Windows.Forms;
using Volpe.Cafe;
using Volpe.Cafe.Data;
using Volpe.Cafe.Model;
using Volpe.Cafe.Model.MonteCarlo;
using Volpe.Cafe.Model.Optimization;
using Volpe.Cafe.Ui.Settings;
using Volpe.Cafe.Ui.Wizards;
#endregion
namespace Volpe.Cafe.Ui
{
    public class Cafe2d : Form
    {
        #region 
        [Serializable]
        private class RecentSessionEntry
        {
            public RecentSessionEntry(int index, string name, string path)
            {
                this.Index = index;
                this.Name  = name;
                this.Path  = path;
            }
            public override string ToString()
            {
                string formatedPath = (this.Path == null) ? "" :
                    this.Path.Substring(0, this.Path.IndexOf('\\') + 1) + "...\\" +
                    this.Path.Substring(this.Path.LastIndexOf('\\') + 1);
                return "&" + (this.Index + 1).ToString() + ".  " + this.Name + " (" + formatedPath + ")";;
            }
            public int      Index;
            public string Name;
            public string Path;
        }
        #endregion
        #region 
        public static Cafe2d CreateInstance()
        {
            if (Cafe2d._instance == null)
            {
                Cafe2d._startupPath = Application.StartupPath;
                Cafe2d._dataPath = Path.GetDirectoryName(Cafe2d._startupPath) + "\\data";
                if (!Directory.Exists(Cafe2d._dataPath))
                {
                    Cafe2d._dataPath = "";
                }
                Cafe2d._outputPath = Path.GetDirectoryName(Cafe2d._startupPath) + "\\output";
                if (!Directory.Exists(Cafe2d._outputPath))
                {
                    Directory.CreateDirectory(Cafe2d._outputPath);
                }
                Cafe2d._themesPath = Path.GetDirectoryName(Cafe2d._startupPath) + "\\themes";
                if (!Directory.Exists(Cafe2d._themesPath))
                {
                    Cafe2d._themesPath = "";
                }
                Cafe2d._assemblies = new ArrayList();
                Cafe2d._cmpTypes   = new ArrayList();
                Cafe2d._cmpTypes.Add(typeof(Compliance));
                Cafe2d._cmpTypes.Add(typeof(Optimization));
                Cafe2d._cmpTypes.Add(typeof(MonteCarlo));
                Cafe2d._themes = new Themes(Cafe2d._themesPath);
                Cafe2d._themes.SelectedThemeIndex = 0;
                Cafe2d._settings = new UiSettings();
                Cafe2d._instance = new Cafe2d();
            }
            return Cafe2d._instance;
        }
        private static void ParseAssembly(Assembly assembly)
        {
            Type[] types = assembly.GetTypes();
            string IComplianceType_FullName = typeof(ICompliance).FullName;
            for (int i = 0; i < types.Length; i++)
            {
                Type[] interfaces = types[i].GetInterfaces();
                bool isCompliance = false;
                ModelDescriptionAttribute attr = (ModelDescriptionAttribute)Attribute.GetCustomAttribute(types[i],
                    typeof(ModelDescriptionAttribute));
                if (!types[i].IsAbstract && attr != null)
                {   
                    for (int j = 0; j < interfaces.Length; j++)
                    {
                        if (interfaces[j].FullName == IComplianceType_FullName)
                        {
                            isCompliance = true;
                            break;      
                        }
                    }
                }
                if (isCompliance) { Cafe2d._cmpTypes.Add(types[i]); }
            }
        }
        protected Cafe2d()
        {
            this.InitializeComponent();
            this._recentSessions = new ArrayList();
        }
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (this.components != null)
                {
                    this.components.Dispose();
                }
            }
            base.Dispose(disposing);
        }
        #endregion
        #region 
        #region 
        private void InitializeComponent()
        {
            System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(Cafe2d));
            this.ux_mainMenu = new System.Windows.Forms.MainMenu();
            this.ux_fileMenu = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_NewSession = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_OpenSession = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_CloseSession = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_CloseAll = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_Separator0 = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_SaveSession = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_SaveSessionAs = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_SaveAll = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_Separator1 = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_StartModeling = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_StopModeling = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_GenerateReports = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_CancelReports = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_Separator2 = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_Recent = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_Separator3 = new System.Windows.Forms.MenuItem();
            this.ux_fileMenu_Exit = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu_NextSession = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu_PreviousSession = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu_Separator0 = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu_InputFileLocation = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu_OutputLocation = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu_ExcelApplication = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu_Separator1 = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu_UpdateSpeed = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu_UpdateSpeed_Realtime = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu_UpdateSpeed_High = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu_UpdateSpeed_Normal = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu_UpdateSpeed_Low = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu_UpdateSpeed_Separator0 = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu_UpdateSpeed_Paused = new System.Windows.Forms.MenuItem();
            this.ux_viewMenu_Refresh = new System.Windows.Forms.MenuItem();
            this.ux_toolsMenu = new System.Windows.Forms.MenuItem();
            this.ux_toolsMenu_ManageInput = new System.Windows.Forms.MenuItem();
            this.ux_toolsMenu_ManageOutput = new System.Windows.Forms.MenuItem();
            this.ux_toolsMenu_ModelingSettings = new System.Windows.Forms.MenuItem();
            this.ux_toolsMenu_RunNewSessionWizard = new System.Windows.Forms.MenuItem();
            this.ux_toolsMenu_Separator0 = new System.Windows.Forms.MenuItem();
            this.ux_toolsMenu_Customize = new System.Windows.Forms.MenuItem();
            this.ux_toolsMenu_Options = new System.Windows.Forms.MenuItem();
            this.ux_helpMenu = new System.Windows.Forms.MenuItem();
            this.ux_helpMenu_HelpContents = new System.Windows.Forms.MenuItem();
            this.ux_helpMenu_SourceCode = new System.Windows.Forms.MenuItem();
            this.ux_helpMenu_Separator0 = new System.Windows.Forms.MenuItem();
            this.ux_helpMenu_About = new System.Windows.Forms.MenuItem();
            this.ux_statusBar = new System.Windows.Forms.StatusBar();
            this.ux_statusPanel = new System.Windows.Forms.StatusBarPanel();
            this.ux_versionPanel = new System.Windows.Forms.StatusBarPanel();
            this.ux_toolbarPanel = new System.Windows.Forms.Panel();
            this.ux_stopModelingLabelButton = new Volpe.Cafe.Ui.LabelButton();
            this.ux_startModelingLabelButton = new Volpe.Cafe.Ui.LabelButton();
            this.ux_configureSettingsLabelButton = new Volpe.Cafe.Ui.LabelButton();
            this.ux_configureFilesLabelButton = new Volpe.Cafe.Ui.LabelButton();
            this.ux_saveSessionLabelButton = new Volpe.Cafe.Ui.LabelButton();
            this.ux_openSessionLabelButton = new Volpe.Cafe.Ui.LabelButton();
            this.ux_newSessionLabelButton = new Volpe.Cafe.Ui.LabelButton();
            ((System.ComponentModel.ISupportInitialize)(this.ux_statusPanel)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.ux_versionPanel)).BeginInit();
            this.ux_toolbarPanel.SuspendLayout();
            this.SuspendLayout();
            this.ux_mainMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
                                                                                        this.ux_fileMenu,
                                                                                        this.ux_viewMenu,
                                                                                        this.ux_toolsMenu,
                                                                                        this.ux_helpMenu});
            this.ux_fileMenu.Index = 0;
            this.ux_fileMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
                                                                                        this.ux_fileMenu_NewSession,
                                                                                        this.ux_fileMenu_OpenSession,
                                                                                        this.ux_fileMenu_CloseSession,
                                                                                        this.ux_fileMenu_CloseAll,
                                                                                        this.ux_fileMenu_Separator0,
                                                                                        this.ux_fileMenu_SaveSession,
                                                                                        this.ux_fileMenu_SaveSessionAs,
                                                                                        this.ux_fileMenu_SaveAll,
                                                                                        this.ux_fileMenu_Separator1,
                                                                                        this.ux_fileMenu_StartModeling,
                                                                                        this.ux_fileMenu_StopModeling,
                                                                                        this.ux_fileMenu_GenerateReports,
                                                                                        this.ux_fileMenu_CancelReports,
                                                                                        this.ux_fileMenu_Separator2,
                                                                                        this.ux_fileMenu_Recent,
                                                                                        this.ux_fileMenu_Separator3,
                                                                                        this.ux_fileMenu_Exit});
            this.ux_fileMenu.Text = "&File";
            this.ux_fileMenu_NewSession.Index = 0;
            this.ux_fileMenu_NewSession.Shortcut = System.Windows.Forms.Shortcut.CtrlN;
            this.ux_fileMenu_NewSession.Text = "&New Session";
            this.ux_fileMenu_NewSession.Click += new System.EventHandler(this.FileMenu_NewSession_Click);
            this.ux_fileMenu_OpenSession.Index = 1;
            this.ux_fileMenu_OpenSession.Shortcut = System.Windows.Forms.Shortcut.CtrlO;
            this.ux_fileMenu_OpenSession.Text = "&Open Session";
            this.ux_fileMenu_OpenSession.Click += new System.EventHandler(this.FileMenu_OpenSession_Click);
            this.ux_fileMenu_CloseSession.Index = 2;
            this.ux_fileMenu_CloseSession.Shortcut = System.Windows.Forms.Shortcut.CtrlF4;
            this.ux_fileMenu_CloseSession.Text = "&Close Session";
            this.ux_fileMenu_CloseSession.Click += new System.EventHandler(this.FileMenu_CloseSession_Click);
            this.ux_fileMenu_CloseAll.Index = 3;
            this.ux_fileMenu_CloseAll.Shortcut = System.Windows.Forms.Shortcut.CtrlShiftF4;
            this.ux_fileMenu_CloseAll.Text = "Clos&e All";
            this.ux_fileMenu_CloseAll.Click += new System.EventHandler(this.FileMenu_CloseAll_Click);
            this.ux_fileMenu_Separator0.Index = 4;
            this.ux_fileMenu_Separator0.Text = "-";
            this.ux_fileMenu_SaveSession.Index = 5;
            this.ux_fileMenu_SaveSession.Shortcut = System.Windows.Forms.Shortcut.CtrlS;
            this.ux_fileMenu_SaveSession.Text = "&Save Session";
            this.ux_fileMenu_SaveSession.Click += new System.EventHandler(this.FileMenu_SaveSession_Click);
            this.ux_fileMenu_SaveSessionAs.Index = 6;
            this.ux_fileMenu_SaveSessionAs.Text = "Save Session &As...";
            this.ux_fileMenu_SaveSessionAs.Click += new System.EventHandler(this.FileMenu_SaveSessionAs_Click);
            this.ux_fileMenu_SaveAll.Index = 7;
            this.ux_fileMenu_SaveAll.Shortcut = System.Windows.Forms.Shortcut.CtrlShiftS;
            this.ux_fileMenu_SaveAll.Text = "Save A&ll";
            this.ux_fileMenu_SaveAll.Click += new System.EventHandler(this.FileMenu_SaveAll_Click);
            this.ux_fileMenu_Separator1.Index = 8;
            this.ux_fileMenu_Separator1.Text = "-";
            this.ux_fileMenu_StartModeling.Index = 9;
            this.ux_fileMenu_StartModeling.Shortcut = System.Windows.Forms.Shortcut.CtrlM;
            this.ux_fileMenu_StartModeling.Text = "Start &Modeling";
            this.ux_fileMenu_StartModeling.Click += new System.EventHandler(this.FileMenu_StartModeling_Click);
            this.ux_fileMenu_StopModeling.Index = 10;
            this.ux_fileMenu_StopModeling.Shortcut = System.Windows.Forms.Shortcut.CtrlShiftM;
            this.ux_fileMenu_StopModeling.Text = "Stop Modeling";
            this.ux_fileMenu_StopModeling.Click += new System.EventHandler(this.FileMenu_StopModeling_Click);
            this.ux_fileMenu_GenerateReports.Index = 11;
            this.ux_fileMenu_GenerateReports.Shortcut = System.Windows.Forms.Shortcut.CtrlR;
            this.ux_fileMenu_GenerateReports.Text = "Generate &Reports";
            this.ux_fileMenu_GenerateReports.Click += new System.EventHandler(this.FileMenu_GenerateReports_Click);
            this.ux_fileMenu_CancelReports.Index = 12;
            this.ux_fileMenu_CancelReports.Shortcut = System.Windows.Forms.Shortcut.CtrlShiftR;
            this.ux_fileMenu_CancelReports.Text = "Cancel Reports";
            this.ux_fileMenu_CancelReports.Click += new System.EventHandler(this.FileMenu_CancelReports_Click);
            this.ux_fileMenu_Separator2.Index = 13;
            this.ux_fileMenu_Separator2.Text = "-";
            this.ux_fileMenu_Recent.Index = 14;
            this.ux_fileMenu_Recent.Text = "Recent Sessions";
            this.ux_fileMenu_Separator3.Index = 15;
            this.ux_fileMenu_Separator3.Text = "-";
            this.ux_fileMenu_Exit.Index = 16;
            this.ux_fileMenu_Exit.Shortcut = System.Windows.Forms.Shortcut.AltF4;
            this.ux_fileMenu_Exit.Text = "E&xit";
            this.ux_fileMenu_Exit.Click += new System.EventHandler(this.FileMenu_Exit_Click);
            this.ux_viewMenu.Index = 1;
            this.ux_viewMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
                                                                                        this.ux_viewMenu_NextSession,
                                                                                        this.ux_viewMenu_PreviousSession,
                                                                                        this.ux_viewMenu_Separator0,
                                                                                        this.ux_viewMenu_InputFileLocation,
                                                                                        this.ux_viewMenu_OutputLocation,
                                                                                        this.ux_viewMenu_ExcelApplication,
                                                                                        this.ux_viewMenu_Separator1,
                                                                                        this.ux_viewMenu_UpdateSpeed,
                                                                                        this.ux_viewMenu_Refresh});
            this.ux_viewMenu.Text = "&View";
            this.ux_viewMenu_NextSession.Index = 0;
            this.ux_viewMenu_NextSession.Text = "&Next Session";
            this.ux_viewMenu_NextSession.Click += new System.EventHandler(this.ViewMenu_NextSession_Click);
            this.ux_viewMenu_PreviousSession.Index = 1;
            this.ux_viewMenu_PreviousSession.Text = "&Previous Session";
            this.ux_viewMenu_PreviousSession.Click += new System.EventHandler(this.ViewMenu_PreviousSession_Click);
            this.ux_viewMenu_Separator0.Index = 2;
            this.ux_viewMenu_Separator0.Text = "-";
            this.ux_viewMenu_InputFileLocation.Index = 3;
            this.ux_viewMenu_InputFileLocation.Text = "&Input File Location(s)";
            this.ux_viewMenu_InputFileLocation.Click += new System.EventHandler(this.ViewMenu_InputFileLocation_Click);
            this.ux_viewMenu_OutputLocation.Index = 4;
            this.ux_viewMenu_OutputLocation.Text = "&Output Location";
            this.ux_viewMenu_OutputLocation.Click += new System.EventHandler(this.ViewMenu_OutputLocation_Click);
            this.ux_viewMenu_ExcelApplication.Index = 5;
            this.ux_viewMenu_ExcelApplication.Text = "E&xcel Application";
            this.ux_viewMenu_ExcelApplication.Click += new System.EventHandler(this.ViewMenu_ExcelApplication_Click);
            this.ux_viewMenu_Separator1.Index = 6;
            this.ux_viewMenu_Separator1.Text = "-";
            this.ux_viewMenu_UpdateSpeed.Index = 7;
            this.ux_viewMenu_UpdateSpeed.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
                                                                                                    this.ux_viewMenu_UpdateSpeed_Realtime,
                                                                                                    this.ux_viewMenu_UpdateSpeed_High,
                                                                                                    this.ux_viewMenu_UpdateSpeed_Normal,
                                                                                                    this.ux_viewMenu_UpdateSpeed_Low,
                                                                                                    this.ux_viewMenu_UpdateSpeed_Separator0,
                                                                                                    this.ux_viewMenu_UpdateSpeed_Paused});
            this.ux_viewMenu_UpdateSpeed.Text = "&Update Speed";
            this.ux_viewMenu_UpdateSpeed_Realtime.Index = 0;
            this.ux_viewMenu_UpdateSpeed_Realtime.RadioCheck = true;
            this.ux_viewMenu_UpdateSpeed_Realtime.Text = "&Realtime";
            this.ux_viewMenu_UpdateSpeed_Realtime.Click += new System.EventHandler(this.ViewMenu_UpdateSpeed_Realtime_Click);
            this.ux_viewMenu_UpdateSpeed_High.Index = 1;
            this.ux_viewMenu_UpdateSpeed_High.RadioCheck = true;
            this.ux_viewMenu_UpdateSpeed_High.Text = "&High";
            this.ux_viewMenu_UpdateSpeed_High.Click += new System.EventHandler(this.ViewMenu_UpdateSpeed_High_Click);
            this.ux_viewMenu_UpdateSpeed_Normal.Index = 2;
            this.ux_viewMenu_UpdateSpeed_Normal.RadioCheck = true;
            this.ux_viewMenu_UpdateSpeed_Normal.Text = "&Normal";
            this.ux_viewMenu_UpdateSpeed_Normal.Click += new System.EventHandler(this.ViewMenu_UpdateSpeed_Normal_Click);
            this.ux_viewMenu_UpdateSpeed_Low.Index = 3;
            this.ux_viewMenu_UpdateSpeed_Low.RadioCheck = true;
            this.ux_viewMenu_UpdateSpeed_Low.Text = "&Low";
            this.ux_viewMenu_UpdateSpeed_Low.Click += new System.EventHandler(this.ViewMenu_UpdateSpeed_Low_Click);
            this.ux_viewMenu_UpdateSpeed_Separator0.Index = 4;
            this.ux_viewMenu_UpdateSpeed_Separator0.Text = "-";
            this.ux_viewMenu_UpdateSpeed_Paused.Index = 5;
            this.ux_viewMenu_UpdateSpeed_Paused.RadioCheck = true;
            this.ux_viewMenu_UpdateSpeed_Paused.Text = "&Paused";
            this.ux_viewMenu_UpdateSpeed_Paused.Click += new System.EventHandler(this.ViewMenu_UpdateSpeed_Paused_Click);
            this.ux_viewMenu_Refresh.Index = 8;
            this.ux_viewMenu_Refresh.Shortcut = System.Windows.Forms.Shortcut.F5;
            this.ux_viewMenu_Refresh.Text = "&Refresh";
            this.ux_viewMenu_Refresh.Click += new System.EventHandler(this.ViewMenu_Refresh_Click);
            this.ux_toolsMenu.Index = 2;
            this.ux_toolsMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
                                                                                         this.ux_toolsMenu_ManageInput,
                                                                                         this.ux_toolsMenu_ManageOutput,
                                                                                         this.ux_toolsMenu_ModelingSettings,
                                                                                         this.ux_toolsMenu_RunNewSessionWizard,
                                                                                         this.ux_toolsMenu_Separator0,
                                                                                         this.ux_toolsMenu_Customize,
                                                                                         this.ux_toolsMenu_Options});
            this.ux_toolsMenu.Text = "&Tools";
            this.ux_toolsMenu_ManageInput.Index = 0;
            this.ux_toolsMenu_ManageInput.Shortcut = System.Windows.Forms.Shortcut.CtrlI;
            this.ux_toolsMenu_ManageInput.Text = "Manage &Input";
            this.ux_toolsMenu_ManageInput.Click += new System.EventHandler(this.ToolsMenu_ManageInput_Click);
            this.ux_toolsMenu_ManageOutput.Index = 1;
            this.ux_toolsMenu_ManageOutput.Shortcut = System.Windows.Forms.Shortcut.CtrlU;
            this.ux_toolsMenu_ManageOutput.Text = "Manage O&utput";
            this.ux_toolsMenu_ManageOutput.Click += new System.EventHandler(this.ToolsMenu_ManageOutput_Click);
            this.ux_toolsMenu_ModelingSettings.Index = 2;
            this.ux_toolsMenu_ModelingSettings.Shortcut = System.Windows.Forms.Shortcut.CtrlT;
            this.ux_toolsMenu_ModelingSettings.Text = "Modeling Se&ttings";
            this.ux_toolsMenu_ModelingSettings.Click += new System.EventHandler(this.ToolsMenu_ModelingSettings_Click);
            this.ux_toolsMenu_RunNewSessionWizard.Index = 3;
            this.ux_toolsMenu_RunNewSessionWizard.Shortcut = System.Windows.Forms.Shortcut.CtrlW;
            this.ux_toolsMenu_RunNewSessionWizard.Text = "Run New Session &Wizard";
            this.ux_toolsMenu_RunNewSessionWizard.Click += new System.EventHandler(this.ToolsMenu_RunNewSessionWizard_Click);
            this.ux_toolsMenu_Separator0.Index = 4;
            this.ux_toolsMenu_Separator0.Text = "-";
            this.ux_toolsMenu_Customize.Index = 5;
            this.ux_toolsMenu_Customize.Shortcut = System.Windows.Forms.Shortcut.CtrlF10;
            this.ux_toolsMenu_Customize.Text = "&Customize";
            this.ux_toolsMenu_Customize.Click += new System.EventHandler(this.ToolsMenu_Customize_Click);
            this.ux_toolsMenu_Options.Index = 6;
            this.ux_toolsMenu_Options.Shortcut = System.Windows.Forms.Shortcut.F10;
            this.ux_toolsMenu_Options.Text = "&Options";
            this.ux_toolsMenu_Options.Click += new System.EventHandler(this.ToolsMenu_Options_Click);
            this.ux_helpMenu.Index = 3;
            this.ux_helpMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
                                                                                        this.ux_helpMenu_HelpContents,
                                                                                        this.ux_helpMenu_SourceCode,
                                                                                        this.ux_helpMenu_Separator0,
                                                                                        this.ux_helpMenu_About});
            this.ux_helpMenu.Text = "&Help";
            this.ux_helpMenu_HelpContents.Index = 0;
            this.ux_helpMenu_HelpContents.Shortcut = System.Windows.Forms.Shortcut.F1;
            this.ux_helpMenu_HelpContents.Text = "&Help Contents";
            this.ux_helpMenu_HelpContents.Click += new System.EventHandler(this.HelpMenu_HelpContents_Click);
            this.ux_helpMenu_SourceCode.Index = 1;
            this.ux_helpMenu_SourceCode.Shortcut = System.Windows.Forms.Shortcut.F11;
            this.ux_helpMenu_SourceCode.Text = "&Source Code";
            this.ux_helpMenu_SourceCode.Click += new System.EventHandler(this.HelpMenu_SourceCode_Click);
            this.ux_helpMenu_Separator0.Index = 2;
            this.ux_helpMenu_Separator0.Text = "-";
            this.ux_helpMenu_About.Index = 3;
            this.ux_helpMenu_About.Shortcut = System.Windows.Forms.Shortcut.F12;
            this.ux_helpMenu_About.Text = "&About CAFE Model";
            this.ux_helpMenu_About.Click += new System.EventHandler(this.HelpMenu_About_Click);
            this.ux_statusBar.Location = new System.Drawing.Point(0, 411);
            this.ux_statusBar.Name = "ux_statusBar";
            this.ux_statusBar.Panels.AddRange(new System.Windows.Forms.StatusBarPanel[] {
                                                                                            this.ux_statusPanel,
                                                                                            this.ux_versionPanel});
            this.ux_statusBar.ShowPanels = true;
            this.ux_statusBar.Size = new System.Drawing.Size(568, 22);
            this.ux_statusBar.TabIndex = 1;
            this.ux_statusPanel.AutoSize = System.Windows.Forms.StatusBarPanelAutoSize.Spring;
            this.ux_statusPanel.Text = "Ready";
            this.ux_statusPanel.Width = 542;
            this.ux_versionPanel.AutoSize = System.Windows.Forms.StatusBarPanelAutoSize.Contents;
            this.ux_versionPanel.Width = 10;
            this.ux_toolbarPanel.Controls.Add(this.ux_stopModelingLabelButton);
            this.ux_toolbarPanel.Controls.Add(this.ux_startModelingLabelButton);
            this.ux_toolbarPanel.Controls.Add(this.ux_configureSettingsLabelButton);
            this.ux_toolbarPanel.Controls.Add(this.ux_configureFilesLabelButton);
            this.ux_toolbarPanel.Controls.Add(this.ux_saveSessionLabelButton);
            this.ux_toolbarPanel.Controls.Add(this.ux_openSessionLabelButton);
            this.ux_toolbarPanel.Controls.Add(this.ux_newSessionLabelButton);
            this.ux_toolbarPanel.Dock = System.Windows.Forms.DockStyle.Top;
            this.ux_toolbarPanel.Location = new System.Drawing.Point(0, 0);
            this.ux_toolbarPanel.Name = "ux_toolbarPanel";
            this.ux_toolbarPanel.Size = new System.Drawing.Size(568, 32);
            this.ux_toolbarPanel.TabIndex = 3;
            this.ux_stopModelingLabelButton.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_stopModelingLabelButton.Location = new System.Drawing.Point(164, 4);
            this.ux_stopModelingLabelButton.Name = "ux_stopModelingLabelButton";
            this.ux_stopModelingLabelButton.Size = new System.Drawing.Size(24, 24);
            this.ux_stopModelingLabelButton.TabIndex = 6;
            this.ux_stopModelingLabelButton.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.ux_stopModelingLabelButton.Click += new System.EventHandler(this.StopModelingLabelButton_Click);
            this.ux_startModelingLabelButton.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_startModelingLabelButton.Location = new System.Drawing.Point(140, 4);
            this.ux_startModelingLabelButton.Name = "ux_startModelingLabelButton";
            this.ux_startModelingLabelButton.Size = new System.Drawing.Size(24, 24);
            this.ux_startModelingLabelButton.TabIndex = 7;
            this.ux_startModelingLabelButton.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.ux_startModelingLabelButton.Click += new System.EventHandler(this.StartModelingLabelButton_Click);
            this.ux_configureSettingsLabelButton.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_configureSettingsLabelButton.Location = new System.Drawing.Point(108, 4);
            this.ux_configureSettingsLabelButton.Name = "ux_configureSettingsLabelButton";
            this.ux_configureSettingsLabelButton.Size = new System.Drawing.Size(24, 24);
            this.ux_configureSettingsLabelButton.TabIndex = 8;
            this.ux_configureSettingsLabelButton.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.ux_configureSettingsLabelButton.Click += new System.EventHandler(this.ConfigureSettingsLabelButton_Click);
            this.ux_configureFilesLabelButton.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_configureFilesLabelButton.Location = new System.Drawing.Point(84, 4);
            this.ux_configureFilesLabelButton.Name = "ux_configureFilesLabelButton";
            this.ux_configureFilesLabelButton.Size = new System.Drawing.Size(24, 24);
            this.ux_configureFilesLabelButton.TabIndex = 9;
            this.ux_configureFilesLabelButton.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.ux_configureFilesLabelButton.Click += new System.EventHandler(this.ConfigureFilesLabelButton_Click);
            this.ux_saveSessionLabelButton.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_saveSessionLabelButton.Location = new System.Drawing.Point(52, 4);
            this.ux_saveSessionLabelButton.Name = "ux_saveSessionLabelButton";
            this.ux_saveSessionLabelButton.Size = new System.Drawing.Size(24, 24);
            this.ux_saveSessionLabelButton.TabIndex = 10;
            this.ux_saveSessionLabelButton.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.ux_saveSessionLabelButton.Click += new System.EventHandler(this.SaveSessionLabelButton_Click);
            this.ux_openSessionLabelButton.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_openSessionLabelButton.Location = new System.Drawing.Point(28, 4);
            this.ux_openSessionLabelButton.Name = "ux_openSessionLabelButton";
            this.ux_openSessionLabelButton.Size = new System.Drawing.Size(24, 24);
            this.ux_openSessionLabelButton.TabIndex = 11;
            this.ux_openSessionLabelButton.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.ux_openSessionLabelButton.Click += new System.EventHandler(this.OpenSessionLabelButton_Click);
            this.ux_newSessionLabelButton.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_newSessionLabelButton.Location = new System.Drawing.Point(4, 4);
            this.ux_newSessionLabelButton.Name = "ux_newSessionLabelButton";
            this.ux_newSessionLabelButton.Size = new System.Drawing.Size(24, 24);
            this.ux_newSessionLabelButton.TabIndex = 12;
            this.ux_newSessionLabelButton.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.ux_newSessionLabelButton.Click += new System.EventHandler(this.NewSessionLabelButton_Click);
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 14);
            this.ClientSize = new System.Drawing.Size(568, 433);
            this.Controls.Add(this.ux_toolbarPanel);
            this.Controls.Add(this.ux_statusBar);
            this.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
            this.IsMdiContainer = true;
            this.Menu = this.ux_mainMenu;
            this.Name = "Cafe2d";
            this.Text = "CAFE Model";
            this.Load += new System.EventHandler(this.Cafe2d_Load);
            ((System.ComponentModel.ISupportInitialize)(this.ux_statusPanel)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.ux_versionPanel)).EndInit();
            this.ux_toolbarPanel.ResumeLayout(false);
            this.ResumeLayout(false);
        }
        #endregion
        #region 
        protected override void WndProc(ref Message m)
        {
            if (m.Msg == (int)Win32.Messages.WM_CLOSE)
            {
                this.WndProc_WM_CLOSE(ref m);
            }
            else { base.WndProc(ref m); }
        }
        private void WndProc_WM_CLOSE(ref Message m)
        {
            this.FileMenu_CloseAll_Click(this, EventArgs.Empty);
            if (this.MdiChildren.Length == 0) { base.WndProc(ref m); }
        }
        #endregion
        #region 
        private static Assembly Cafe2d_AssemblyResolve(object sender, ResolveEventArgs args)
        {
            for (int i = 0; i < Cafe2d._assemblies.Count; i++)
            {
                Assembly assembly = (Assembly)Cafe2d._assemblies[i];
                if (args.Name == assembly.FullName) { return assembly; }
            }
            return null;
        }
        private void Cafe2d_Load(object sender, System.EventArgs e)
        {
            this.ux_newSessionLabelButton.ThemeInitialize("session-new", false);
            this.ux_openSessionLabelButton.ThemeInitialize("session-open", false);
            this.ux_saveSessionLabelButton.ThemeInitialize("session-save", false);
            this.ux_configureFilesLabelButton.ThemeInitialize("config-files", false);
            this.ux_configureSettingsLabelButton.ThemeInitialize("config-settings", false);
            this.ux_startModelingLabelButton.ThemeInitialize("model-start", false);
            this.ux_stopModelingLabelButton.ThemeInitialize("model-cancel", false);
            this.KeyDown += new KeyEventHandler(this.Cafe2d_KeyDown);
            this.MdiChildActivate += new EventHandler(this.Cafe2d_MdiChildActivate);
            this.AddMenuItemEventHandlers(this.ux_mainMenu.MenuItems);
            this.AddToolbarEventHandlers(this.ux_toolbarPanel);
            this.EnableDragDrop();
            this.RefreshSession();
            this.ux_fileMenu_Recent.Enabled = (this._recentSessions.Count > 0);
            string exePath = Application.ExecutablePath;
            FileInfo fi = new FileInfo(exePath);
            this.ux_versionPanel.Text = fi.LastWriteTime.ToString("M/dd/yy H:mm:ss");
            this.Show();
            Application.DoEvents();
            if (this._args.HasArgs)
            {
                if (this._args.CMSDPath != null)
                {
                    this.OpenSession(this._args.CMSDPath, this._args.CMSDNoPrompt);
                }
            }
        }
        private void Cafe2d_KeyDown(object sender, KeyEventArgs e)
        {
        }
        private void Cafe2d_MdiChildActivate(object sender, EventArgs e)
        {
            this._activeSession = (Session2d)this.ActiveMdiChild;
            this.SetStatus((this._activeSession == null) ? "Ready" : this._activeSession.Status);
            if (this._activeSession != null)
            {
                int refInt = this._activeSession.RefreshInterval;
                this.ViewMenu_UpdateSpeed_SetChecked(
                    refInt == Cafe2d.RefreshIntervalRealtime,
                    refInt == Cafe2d.RefreshIntervalHigh,
                    refInt == Cafe2d.RefreshIntervalNormal,
                    refInt == Cafe2d.RefreshIntervalLow,
                    refInt == Cafe2d.RefreshIntervalPaused);
            }
            this.RefreshSession();
        }
        private void Control_AfterSelect(object sender, EventArgs e)
        {
            int sessionCount = this.Sessions.Length;
            string message =
                (sender == this.ux_fileMenu_NewSession ||
                 sender == this.ux_newSessionLabelButton)     ? "Creates a new CAFE Model Session by running the New Session Wizard." :
                (sender == this.ux_fileMenu_OpenSession ||
                 sender == this.ux_openSessionLabelButton)     ? "Opens an existing CAFE Model Session." :
                (sender == this.ux_fileMenu_CloseSession)     ? "Closes the active CAFE Model Session." :
                (sender == this.ux_fileMenu_CloseAll)         ? "Closes all opened CAFE Model Session." :
                (sender == this.ux_fileMenu_SaveSession ||
                 sender == this.ux_saveSessionLabelButton)     ? "Saves the active CAFE Model Session." :
                (sender == this.ux_fileMenu_SaveSessionAs)     ? "Displays the Save As dialog for the active CAFE Model Session." :
                (sender == this.ux_fileMenu_SaveAll)         ? "Saves all opened CAFE Model Session." :
                (sender == this.ux_fileMenu_StartModeling ||
                 sender == this.ux_startModelingLabelButton) ? "Begins the modeling process for the active CAFE Model Session." :
                (sender == this.ux_fileMenu_StopModeling ||
                 sender == this.ux_stopModelingLabelButton)     ? "Suspends the modeling process of the active CAFE Model Session." :
                (sender == this.ux_fileMenu_GenerateReports) ? "Generates modeling reports for the active CAFE Model Session." :
                (sender == this.ux_fileMenu_CancelReports)     ? "Cancels the generating of modeling reports for the active CAFE Model Session." :
                (sender == this.ux_fileMenu_Recent)             ? "Displays the recently opened or saved sessions." :
                (sender == this.ux_fileMenu_Exit)             ? (sessionCount == 0) ? "Exits the CAFE Model." : "Closes " +
                                                               ((sessionCount == 1) ? "the active CAFE Model Session" :
                                                                                      "all opened CAFE Model Sessions") + " and exits the model." :
                (sender == this.ux_viewMenu_NextSession)        ? "Selects the next CAFE Model Session." :
                (sender == this.ux_viewMenu_PreviousSession)    ? "Selects the previous CAFE Model Session." :
                (sender == this.ux_viewMenu_InputFileLocation)    ? "Browses the location of the input data files used to make this Session." :
                (sender == this.ux_viewMenu_OutputLocation)        ? "Browses the location where the output files and reports of the Session are written to." :
                (sender == this.ux_viewMenu_ExcelApplication)    ? "Displays the Excel Application on the screen." :
                (sender == this.ux_viewMenu_UpdateSpeed)        ? "Selects how often to refresh the Session when it is running." :
                (sender == this.ux_viewMenu_UpdateSpeed_Realtime) ? "Refreshes the Session eight times per second." :
                (sender == this.ux_viewMenu_UpdateSpeed_High)    ? "Refreshes the Session twice per second." :
                (sender == this.ux_viewMenu_UpdateSpeed_Normal)    ? "Refreshes the Session every two seconds." :
                (sender == this.ux_viewMenu_UpdateSpeed_Low)    ? "Refreshes the Session every four seconds." :
                (sender == this.ux_viewMenu_UpdateSpeed_Paused) ? "Does not automatically refresh the Session." :
                (sender == this.ux_viewMenu_Refresh)            ? "Forces the Session to refresh now, regardless of the Update Speed setting." :
                (sender == this.ux_toolsMenu_ManageInput ||
                 sender == this.ux_configureFilesLabelButton)      ? "Opens the Manage Input window, for selecting the input data files." :
                (sender == this.ux_toolsMenu_ManageOutput)          ? "Opens the Manage Output window, for configuring the output and reporting options." :
                (sender == this.ux_toolsMenu_ModelingSettings ||
                 sender == this.ux_configureSettingsLabelButton)  ? "Displays the Modeling Settings window, where all modeling options and settings can be configured." :
                (sender == this.ux_toolsMenu_RunNewSessionWizard) ? "Runs the New Session Wizard for the current Session." :
                (sender == this.ux_toolsMenu_Customize)              ? "Customizes the Look & Feel of the CAFE Model User Interface." :
                (sender == this.ux_toolsMenu_Options)              ? "Configures the CAFE Model User Interface options." :
                (sender == this.ux_helpMenu_HelpContents) ? "Displays the Help Contents for the CAFE Model." :
                (sender == this.ux_helpMenu_SourceCode)      ? "Displays the Source Code used to develop the CAFE Model." :
                (sender == this.ux_helpMenu_About)          ? "Displays product information about the CAFE Model." :
                null;
            if (message != null && message.Length > 0 &&
                (((sender is Control) && !((Control)sender).Enabled) ||
                 ((sender is MenuItem) && !((MenuItem)sender).Enabled)))
            {
                message = "When enabled, " + (char)(message[0] + 32) + message.Remove(0, 1);
            }
            this.ux_statusBar.Text = message;
            this.ux_statusBar.ShowPanels = (message == null);
        }
        private void Control_AfterClick(object sender, EventArgs e)
        {
            this.ux_statusBar.Text = null;
            this.ux_statusBar.ShowPanels = true;
        }
        private void Control_AfterMouseClick(object sender, MouseEventArgs e)
        {
            this.Control_AfterClick(sender, e);
        }
        private void Cafe2d_DragEnter(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent(DataFormats.FileDrop, false))
            {
                e.Effect = DragDropEffects.All;
            }
        }
        private void Cafe2d_DragDrop(object sender, DragEventArgs e)
        {
            string[] paths = (string[])e.Data.GetData(DataFormats.FileDrop, false);
            paths = this.GetDrapDropFiles(paths, 1);    
            ArrayList cmsd = new ArrayList();    int cmsdCount = 0;
            ArrayList xls  = new ArrayList();    int xlsCount  = 0;
            int pathCount = paths.Length;
            for (int i = 0; i < pathCount; i++)
            {
                string ext = Path.GetExtension(paths[i]).Trim().ToUpper();
                if (ext == ".CMSD")
                {    
                    cmsd.Add(paths[i]);    cmsdCount++;
                }
                else if (ext == ".XLS")
                {    
                    xls.Add(paths[i]);    xlsCount++;
                }
            }
            for (int i = 0; i < cmsdCount; i++)
            {
                this.OpenSession((string)cmsd[i], false);
            }
            if (cmsdCount == 0 && xlsCount > 0)
            {
                Session2d[] sessions2d = this.Sessions;
                int sessionCount = sessions2d.Length;
                bool runWizard = (sessionCount == 0 || this.ActiveSession.Running);
                string[] xlsFiles = (string[])xls.ToArray(typeof(string));
                if (runWizard)
                {    
                    this.NewSession(true, xlsFiles);
                }
                else
                {    
                    this.ManageInput(true, xlsFiles);
                }
            }
        }
        private string[] GetDrapDropFiles(string[] paths, int recurseDepth)
        {
            ArrayList files = new ArrayList(16);
            for (int i = 0, pathsCount = paths.Length; i < pathsCount; i++)
            {
                if (Directory.Exists(paths[i]) && recurseDepth > 0)
                {    
                    files.AddRange(this.GetDrapDropFiles(Directory.GetFiles(paths[i]), recurseDepth - 1));
                }
                else if (File.Exists(paths[i]))
                {    
                    files.Add(paths[i]);
                }
            }
            return (string[])files.ToArray(typeof(string));
        }
        #endregion
        #region 
        private void FileMenu_NewSession_Click(object sender, System.EventArgs e)
        {
            this.NewSession(false, null);
        }
        private void FileMenu_OpenSession_Click(object sender, System.EventArgs e)
        {
            this.OpenSession(null, false);
        }
        private void FileMenu_CloseSession_Click(object sender, System.EventArgs e)
        {
            this.ActiveSession.CloseSession();
        }
        private void FileMenu_CloseAll_Click(object sender, System.EventArgs e)
        {
            Form[] sessions = this.MdiChildren;
            this._cancelCloseAll = false;
            for (int i = sessions.Length - 1; i >= 0; i--)
            {
                if (this._cancelCloseAll) { break; }
                sessions[i].Activate();
                ((Session2d)sessions[i]).CloseSession();
                if (!sessions[i].IsDisposed) { this._cancelCloseAll = true; }
            }
        }
        private void FileMenu_SaveSession_Click(object sender, System.EventArgs e)
        {
            this.ActiveSession.SaveSession();
        }
        private void FileMenu_SaveSessionAs_Click(object sender, System.EventArgs e)
        {
            this.DisableDragDrop();
            this.ActiveSession.SaveSessionAs();
            this.EnableDragDrop();
        }
        private void FileMenu_SaveAll_Click(object sender, System.EventArgs e)
        {
            int activeSessionIndex = this.ActiveSessionIndex;
            Form[] sessions = this.MdiChildren;
            this._cancelSave = false;
            for (int i = 0; i < sessions.Length; i++)
            {
                if (this._cancelSave)
                {
                    break;
                }
                sessions[i].Activate();
                this._cancelSave = !((Session2d)sessions[i]).SaveSession();
            }
            this.ActiveSessionIndex = activeSessionIndex;
        }
        private void FileMenu_StartModeling_Click(object sender, System.EventArgs e)
        {
            this.ActiveSession.StartModeling();
        }
        private void FileMenu_StopModeling_Click(object sender, System.EventArgs e)
        {
            this.ActiveSession.StopModeling();
        }
        private void FileMenu_GenerateReports_Click(object sender, System.EventArgs e)
        {
            this.ActiveSession.GenerateReports();
        }
        private void FileMenu_CancelReports_Click(object sender, System.EventArgs e)
        {
            this.ActiveSession.CancelReports();
        }
        private void FileMenu_RecentSession_Click(object sender, EventArgs e)
        {
            MenuItem item = (MenuItem)sender;
            RecentSessionEntry entry = (RecentSessionEntry)this._recentSessions[item.Index];
            this.OpenSession(entry.Path, false);
        }
        private void FileMenu_Exit_Click(object sender, System.EventArgs e)
        {
            this.Close();
        }
        #endregion
        #region 
        private void ViewMenu_NextSession_Click(object sender, System.EventArgs e)
        {
            int index = this.ActiveSessionIndex;
            if (index != -1)
            {
                index++;
                if (index >= this.MdiChildren.Length)
                {
                    index = 0;
                }
                this.ActiveSessionIndex = index;
            }
        }
        private void ViewMenu_PreviousSession_Click(object sender, System.EventArgs e)
        {
            int index = this.ActiveSessionIndex;
            if (index != -1)
            {
                index--;
                if (index < 0)
                {
                    index = this.MdiChildren.Length - 1;
                }
                this.ActiveSessionIndex = index;
            }
        }
        private void ViewMenu_InputFileLocation_Click(object sender, System.EventArgs e)
        {
            InputSettings settings = this.ActiveSession.Settings.InputSettings;
            string[] paths = new string[] {
                                              settings.MarketDataFile,
                                              settings.TechnologiesFile,
                                              settings.ParametersFile,
                                              settings.EmissionsRatesFile,
                                              settings.ScenariosFile
                                          };
            StringCollection uniquePaths = new StringCollection();
            for (int i = 0; i < paths.Length; i++)
            {
                if (paths[i] != "")
                {
                    string path = Path.GetDirectoryName(paths[i]);
                    if (!uniquePaths.Contains(path))
                    {
                        uniquePaths.Add(path);
                    }
                }
            }
            this.ExplorePaths(uniquePaths);
        }
        private void ViewMenu_OutputLocation_Click(object sender, System.EventArgs e)
        {
            this.ExplorePaths(this.ActiveSession.Settings.OutputSettings.OutputPath);
        }
        private void ViewMenu_ExcelApplication_Click(object sender, System.EventArgs e)
        {
            if (sender is Button && ((Button)sender).Text == "Hide Excel Application")
            {
                ((Button)sender).FindForm().Close();
                Global.HideExcelApplication();
            }
            else if (Global.ShowExcelApplication())
            {
                Form f = new Form();
                f.Size = new Size(Screen.PrimaryScreen.Bounds.Width, 160);
                f.Location = new Point(0, 0);
                f.TopMost = true;
                f.FormBorderStyle = FormBorderStyle.None;
                f.ShowInTaskbar = false;
                f.ControlBox = false;
                Button b = new Button();
                b.Text = "Hide Excel Application";
                b.Font = new Font(f.Font.FontFamily, 16, FontStyle.Bold);
                b.ForeColor = Color.Navy;
                b.Size = new Size(288, 48);
                b.Location = new Point((f.Width - b.Width) / 2, (f.Height - b.Height) / 2);
                b.Click += new EventHandler(this.ViewMenu_ExcelApplication_Click);
                f.Controls.Add(b);
                f.Show();
                f.Location = new Point(0, 0);
            }
        }
        private void ViewMenu_UpdateSpeed_Realtime_Click(object sender, System.EventArgs e)
        {
            this.ActiveSession.RefreshInterval = Cafe2d.RefreshIntervalRealtime;
            this.ViewMenu_UpdateSpeed_SetChecked(true, false, false, false, false);
        }
        private void ViewMenu_UpdateSpeed_High_Click(object sender, System.EventArgs e)
        {
            this.ActiveSession.RefreshInterval = Cafe2d.RefreshIntervalHigh;
            this.ViewMenu_UpdateSpeed_SetChecked(false, true, false, false, false);
        }
        private void ViewMenu_UpdateSpeed_Normal_Click(object sender, System.EventArgs e)
        {
            this.ActiveSession.RefreshInterval = Cafe2d.RefreshIntervalNormal;
            this.ViewMenu_UpdateSpeed_SetChecked(false, false, true, false, false);
        }
        private void ViewMenu_UpdateSpeed_Low_Click(object sender, System.EventArgs e)
        {
            this.ActiveSession.RefreshInterval = Cafe2d.RefreshIntervalLow;
            this.ViewMenu_UpdateSpeed_SetChecked(false, false, false, true, false);
        }
        private void ViewMenu_UpdateSpeed_Paused_Click(object sender, System.EventArgs e)
        {
            this.ActiveSession.RefreshInterval = Cafe2d.RefreshIntervalPaused;
            this.ViewMenu_UpdateSpeed_SetChecked(false, false, false, false, true);
        }
        private void ViewMenu_UpdateSpeed_SetChecked(bool realtime, bool high, bool normal, bool low, bool paused)
        {
            this.ux_viewMenu_UpdateSpeed_Realtime.Checked = realtime;
            this.ux_viewMenu_UpdateSpeed_High    .Checked = high;
            this.ux_viewMenu_UpdateSpeed_Normal  .Checked = normal;
            this.ux_viewMenu_UpdateSpeed_Low     .Checked = low;
            this.ux_viewMenu_UpdateSpeed_Paused  .Checked = paused;
        }
        private void ViewMenu_Refresh_Click(object sender, System.EventArgs e)
        {
            Control.ControlCollection toolbarControls = this.ux_toolbarPanel.Controls;
            int toolbarControlCount = toolbarControls.Count;
            for (int i = 0; i < toolbarControlCount; i++)
            {
                if (toolbarControls[i] is LabelButton)
                {
                    ((LabelButton)toolbarControls[i]).Refresh();
                }
            }
            this.Control_AfterClick(this, EventArgs.Empty);
            if (this._activeSession != null)
            {
                this._activeSession.Refresh();
            }
        }
        #endregion
        #region 
        private void ToolsMenu_ManageInput_Click(object sender, System.EventArgs e)
        {
            this.ManageInput(false, null);
        }
        private void ToolsMenu_ManageOutput_Click(object sender, System.EventArgs e)
        {
            this.DisableDragDrop();
            Session2d s2d = (Session2d)this.ActiveSession;
            ManageOutput mo = new ManageOutput(s2d.Settings.OutputSettings);
            if (mo.ShowDialog() == DialogResult.OK)
            {
                s2d.Settings.OutputSettings = mo.OutputPanel.OutputSettings;
                s2d.Settings.Changes.OutputChanged = mo.SettingsChanged;
            }
            this.EnableDragDrop();
        }
        private void ToolsMenu_ModelingSettings_Click(object sender, System.EventArgs e)
        {
            this.DisableDragDrop();
            Session2d s2d = this.ActiveSession;
            ManageModelingSettings mms = new ManageModelingSettings(s2d);
            mms.ShowDialog();
            this.RefreshSession();
            this.EnableDragDrop();
        }
        private void ToolsMenu_RunNewSessionWizard_Click(object sender, System.EventArgs e)
        {
            this.DisableDragDrop();
            NewSessionWizard nsw = new NewSessionWizard(this.ActiveSession);
            if (nsw.ShowDialog() == DialogResult.OK)
            {
                if (nsw.SaveSession)
                {
                    nsw.Session.SaveSession();
                }
            }
            nsw.Dispose();
            this.EnableDragDrop();
        }
        private void ToolsMenu_Customize_Click(object sender, System.EventArgs e)
        {
            this.DisableDragDrop();
            Customize customize = new Customize(this.Menu != null,
                this.ux_toolbarPanel.Visible);
            if (customize.ShowDialog() == DialogResult.OK)
            {
                this.Menu = (customize.ShowFileMenu) ? this.ux_mainMenu : null;
                this.ux_toolbarPanel.Visible = customize.ShowStandardToolbar;
            }
            this.EnableDragDrop();
        }
        private void ToolsMenu_Options_Click(object sender, System.EventArgs e)
        {
            this.DisableDragDrop();
            this.EnableDragDrop();
        }
        #endregion
        #region 
        private void HelpMenu_HelpContents_Click(object sender, System.EventArgs e)
        {
        }
        private void HelpMenu_SourceCode_Click(object sender, System.EventArgs e)
        {
            string docFile = Cafe2d.StartupPath + "\\..\\src\\CAFE Model.chm";
            if (File.Exists(docFile))
            {
                Process.Start(docFile);
            }
        }
        private void HelpMenu_About_Click(object sender, System.EventArgs e)
        {
            Program.DisplayAbout();
        }
        #endregion
        #region 
        private void NewSessionLabelButton_Click(object sender, System.EventArgs e)
        {
            this.FileMenu_NewSession_Click(sender, e);
        }
        private void OpenSessionLabelButton_Click(object sender, System.EventArgs e)
        {
            this.FileMenu_OpenSession_Click(sender, e);
        }
        private void SaveSessionLabelButton_Click(object sender, System.EventArgs e)
        {
            this.FileMenu_SaveSession_Click(sender, e);
        }
        private void ConfigureFilesLabelButton_Click(object sender, System.EventArgs e)
        {
            this.ToolsMenu_ManageInput_Click(sender, e);
        }
        private void ConfigureSettingsLabelButton_Click(object sender, System.EventArgs e)
        {
            this.ToolsMenu_ModelingSettings_Click(sender, e);
        }
        private void StartModelingLabelButton_Click(object sender, System.EventArgs e)
        {
            this.FileMenu_StartModeling_Click(sender, e);
        }
        private void StopModelingLabelButton_Click(object sender, System.EventArgs e)
        {
            if (this._activeSession.Running)
            {
                this.FileMenu_StopModeling_Click(sender, e);
            }
            else
            {
                this.FileMenu_CancelReports_Click(sender, e);
            }
        }
        #endregion
        #region 
        private void DisableDragDrop()
        {
            if (this.InvokeRequired)
            {
                this.Invoke(new EmptyEventHandler(this.DisableDragDrop));
            }
            else
            {
                this.AllowDrop    = false;
                this.DragEnter -= new DragEventHandler(this.Cafe2d_DragEnter);
                this.DragDrop  -= new DragEventHandler(this.Cafe2d_DragDrop);
            }
        }
        private void EnableDragDrop()
        {
            if (Cafe2d.Settings.DragAndDrop == TriState.Enabled)
            {
                if (this.InvokeRequired)
                {
                    this.Invoke(new EmptyEventHandler(this.EnableDragDrop));
                }
                else
                {
                    this.AllowDrop    = true;
                    this.DragEnter += new DragEventHandler(this.Cafe2d_DragEnter);
                    this.DragDrop  += new DragEventHandler(this.Cafe2d_DragDrop);
                }
            }
        }
        private void NewSession(bool parseCustFiles, string[] files)
        {
            this.DisableDragDrop();
            bool nswCreated = false;
            if (this._newSesWizard == null)
            {
                this._newSesWizard = new NewSessionWizard(this);
                nswCreated = true;
            }
            if (parseCustFiles) { this._newSesWizard.ParseFiles(files); }
            if (!nswCreated) { this._newSesWizard.Focus(); return; }    
            if (this._newSesWizard.ShowDialog() == DialogResult.OK)
            {
                Session2d s2d = this._newSesWizard.Session;
                s2d.RefreshInterval = Cafe2d.RefreshIntervalNormal;    
                s2d.MdiParent = this;
                s2d.Show();         
                if (this._newSesWizard.SaveSession) { s2d.SaveSession(); }
            }
            this._newSesWizard = null;
            this.EnableDragDrop();
        }
        public bool OpenSession(string filename, bool silent)
        {
            this.DisableDragDrop();
            Session2d s2d = new Session2d(this);
            bool opened = s2d.OpenSession(filename, silent);
            if (opened)
            {
                s2d.MdiParent = this;
                s2d.Show();
                s2d.Refresh();
            }
            else
            {
                s2d.Dispose();
            }
            this.EnableDragDrop();
            return opened;
        }
        private void ManageInput(bool parseCustFiles, string[] files)
        {
            this.DisableDragDrop();
            Session2d s2d = this.ActiveSession;
            ICompliance s2dCompliance = s2d.Compliance;
            bool imCreated = false;
            if (this._inputManager == null)
            {
                this._inputManager = new ManageInput(s2d.Settings.InputSettings,
                    s2d.Settings.EncryptionSettings.InputPassword);
                if (s2dCompliance != null)
                {
                    this._inputManager.ShowMarketData    = s2dCompliance.RequiresMarketData;
                    this._inputManager.ShowTechnologies = s2dCompliance.RequiresTechnologies;
                    this._inputManager.ShowParameters    = s2dCompliance.RequiresParameters;
                    this._inputManager.ShowEmissions    = s2dCompliance.RequiresEmissions;
                    this._inputManager.ShowScenarios    = s2dCompliance.RequiresScenarios;
                }
                imCreated = true;
            }
            if (parseCustFiles) { this._inputManager.InputPanel.ParseFiles(files); }
            if (!imCreated) { this._inputManager.Focus(); return; }        
            if (this._inputManager.ShowDialog() == DialogResult.OK && this._inputManager.SettingsChanged)
            {
                if (this._inputManager.InputPanel.MarketData != null)
                {
                    s2d.Data = this._inputManager.InputPanel.MarketData;
                    s2d.Settings.InputSettings.MarketDataFile = this._inputManager.InputPanel.MarketDataFile;
                    s2d.Settings.InputSettings.MarketDataFileLoaded = true;
                    s2d.Settings.Changes.ModelingDataChanged = true;
                }
                if (this._inputManager.InputPanel.Technologies != null)
                {
                    s2d.Settings.Technologies = this._inputManager.InputPanel.Technologies.Data;
                    s2d.Settings.InputSettings.TechnologiesFile = this._inputManager.InputPanel.TechnologiesFile;
                    s2d.Settings.InputSettings.TechnologiesFileLoaded = true;
                    s2d.Settings.Changes.TechnologiesDataChanged = true;
                }
                if (this._inputManager.InputPanel.Parameters != null)
                {
                    s2d.Settings.Parameters = this._inputManager.InputPanel.Parameters;
                    s2d.Settings.InputSettings.ParametersFile = this._inputManager.InputPanel.ParametersFile;
                    s2d.Settings.InputSettings.ParametersFileLoaded = true;
                    s2d.Settings.Changes.ParametersDataChanged = true;
                }
                if (this._inputManager.InputPanel.EmissionsRates != null)
                {
                    s2d.Settings.EmissionsRates = this._inputManager.InputPanel.EmissionsRates;
                    s2d.Settings.InputSettings.EmissionsRatesFile = this._inputManager.InputPanel.EmissionsRatesFile;
                    s2d.Settings.InputSettings.EmissionsRatesFileLoaded = true;
                    s2d.Settings.Changes.EmissionsDataChanged = true;
                }
                if (this._inputManager.InputPanel.Scenarios != null)
                {
                    s2d.Settings.Scenarios = this._inputManager.InputPanel.Scenarios.Data;
                    s2d.Settings.InputSettings.ScenariosFile = this._inputManager.InputPanel.ScenariosFile;
                    s2d.Settings.InputSettings.ScenariosFileLoaded = true;
                    s2d.Settings.Changes.ScenariosDataChanged = true;
                }
                s2d.Settings.Changes.InputChanged = true;
            }
            this._inputManager = null;
            this.EnableDragDrop();
        }
        private void SetStatus(string message)
        {
            this.ux_statusPanel.Text = message;
        }
        internal void SetStatus(Session2d child, string message)
        {
            if (this._activeSession != null && child == this._activeSession)
            {
                this.SetStatus(message);
            }
        }
        private void ExplorePaths(params string[] paths)
        {
            for (int i = 0; i < paths.Length; i++)
            {
                Process.Start("explorer", "/e," + paths[i]);
            }
        }
        private void ExplorePaths(ICollection paths)
        {
            string[] array = new string[paths.Count];
            paths.CopyTo(array, 0);
            this.ExplorePaths(array);
        }
        private void AddMenuItemEventHandlers(Menu.MenuItemCollection items)
        {
            for (int i = 0, count = items.Count; i < count; i++)
            {
                items[i].Select += new EventHandler(this.Control_AfterSelect);
                items[i].Click  += new EventHandler(this.Control_AfterClick);
                this.AddMenuItemEventHandlers(items[i].MenuItems);
            }
        }
        private void AddToolbarEventHandlers(Panel toolbar)
        {
            Control.ControlCollection lbs = toolbar.Controls;
            for (int i = 0, count = lbs.Count; i < count; i++)
            {
                if (lbs[i] is LabelButton)
                {
                    lbs[i].MouseEnter += new EventHandler(this.Control_AfterSelect);
                    lbs[i].MouseLeave += new EventHandler(this.Control_AfterClick);
                    lbs[i].MouseUp      += new MouseEventHandler(this.Control_AfterMouseClick);
                }
            }
        }
        internal void AddRecentSession(string name, string path)
        {
            if (path == null) { return; } 
            RecentSessionEntry entry = new RecentSessionEntry(0, name, path);
            this.RemoveRecentSession(path);
            int index = entry.Index;
            this._recentSessions.Insert(index, entry);
            for (int i = index + 1; i < this._recentSessions.Count; i++)
            {
                ((RecentSessionEntry)this._recentSessions[i]).Index = i;
            }
            this.ux_fileMenu_Recent.MenuItems.Clear();
            for (int i = 0; i < this._recentSessions.Count; i++)
            {
                this.ux_fileMenu_Recent.MenuItems.Add(new MenuItem(this._recentSessions[i].ToString(),
                    new EventHandler(this.FileMenu_RecentSession_Click)));
            }
            this.ux_fileMenu_Recent.Enabled = (this._recentSessions.Count > 0);
        }
        internal void RemoveRecentSession(string path)
        {
            int index = this.IndexOfRecentSession(path);
            if (index != -1)
            {    
                this._recentSessions.RemoveAt(index);
                for (int i = index; i < this._recentSessions.Count; i++)
                {
                    ((RecentSessionEntry)this._recentSessions[i]).Index = i;
                }
            }
        }
        private int IndexOfRecentSession(string path)
        {
            for (int i = 0; i < this._recentSessions.Count; i++)
            {
                RecentSessionEntry entry = (RecentSessionEntry)this._recentSessions[i];
                if (entry.Path == path) { return i; }
            }
            return -1;
        }
        #endregion
        public void Start(ProgramArgs args)
        {
            this._args = (args == null) ? new ProgramArgs() : args;
            Application.Run(this);
        }
        public void Start()
        {
            this.Start(null);
        }
        internal void RefreshSession()
        {
            this.Invoke(new GenericEventHandler(this.RefreshSession_Invoke), new object[] {null});
        }
        private void RefreshSession_Invoke(object[] args)
        {
            bool anyOpen = (this.Sessions.Length > 0);
            bool twoOrMoreOpen = (this.Sessions.Length > 1);
            bool anyActive = this.SessionsActive();
            bool running = (this._activeSession == null) ? false : this._activeSession.Running;
            bool reporting = (this._activeSession == null) ? false : this._activeSession.Reporting;
            bool canStart = (this._activeSession == null) ? false :
                (this._activeSession.Compliance != null && !this._activeSession.Compliance.Running);
            bool or = anyOpen && running;
            bool op = anyOpen && reporting;
            bool onr = anyOpen && !running && !reporting;
            bool onra = anyOpen && !anyActive;
            this.ux_fileMenu_CloseSession.Enabled = onr;
            this.ux_fileMenu_CloseAll.Enabled = onra;
            this.ux_fileMenu_SaveSession.Enabled = onr;
            this.ux_fileMenu_SaveSessionAs.Enabled = onr;
            this.ux_fileMenu_SaveAll.Enabled = onra;
            this.ux_fileMenu_StartModeling.Enabled = (onr && canStart);
            this.ux_fileMenu_StopModeling.Enabled = or;
            this.ux_fileMenu_GenerateReports.Enabled = onr;
            this.ux_fileMenu_CancelReports.Enabled = !running && op;
            this.ux_fileMenu_Exit.Enabled = !anyActive;
            this.ux_viewMenu_NextSession.Enabled = twoOrMoreOpen;
            this.ux_viewMenu_PreviousSession.Enabled = twoOrMoreOpen;
            this.ux_viewMenu_InputFileLocation.Enabled = anyOpen;
            this.ux_viewMenu_OutputLocation.Enabled = anyOpen;
            this.ux_viewMenu_ExcelApplication.Enabled = op;
            this.ux_viewMenu_UpdateSpeed.Enabled = anyOpen;
            this.ux_viewMenu_Refresh.Enabled = anyOpen;
            this.ux_toolsMenu_ManageInput.Enabled = onr;
            this.ux_toolsMenu_ManageOutput.Enabled = onr;
            this.ux_toolsMenu_ModelingSettings.Enabled = onr;
            this.ux_toolsMenu_RunNewSessionWizard.Enabled = onr;
            this.ux_saveSessionLabelButton.Enabled = onr;
            this.ux_configureFilesLabelButton.Enabled = onr;
            this.ux_configureSettingsLabelButton.Enabled = onr;
            this.ux_startModelingLabelButton.Enabled = (onr && canStart);
            this.ux_stopModelingLabelButton.Enabled = or || (!running && op);
        }
        private bool SessionsActive()
        {
            Session2d[] sessions = this.Sessions;
            for (int i = 0; i < sessions.Length; i++)
            {
                if (!sessions[i].IsDisposed && (sessions[i].Running || sessions[i].Reporting))
                {
                    return true;
                }
            }
            return false;
        }
        #endregion
        #region 
        #region 
        internal static new Font DefaultFont { get { return Cafe2d._instance.Font; } }
        public static string StartupPath { get { return Cafe2d._startupPath; } }
        public static string DefaultDataPath { get { return Cafe2d._dataPath; } }
        public static string DefaultOutputPath { get { return Cafe2d._outputPath; } }
        public static string ThemesPath { get { return Cafe2d._themesPath; } }
        public static Assembly[] Assemblies
        {
            get
            {
                Assembly[] assemblies = new Assembly[Cafe2d._assemblies.Count];
                for (int i = 0; i < assemblies.Length; i++)
                {
                    assemblies[i] = (Assembly)Cafe2d._assemblies[i];
                }
                return assemblies;
            }
        }
        public static Type[] ComplianceTypes
        {
            get
            {
                Type[] types = new Type[Cafe2d._cmpTypes.Count];
                for (int i = 0; i < types.Length; i++)
                {
                    types[i] = (Type)Cafe2d._cmpTypes[i];
                }
                return types;
            }
        }
        public static Themes Themes { get { return Cafe2d._themes; } }
        public static UiSettings Settings { get { return Cafe2d._settings; } }
        #endregion
        public Session2d[] Sessions
        {
            get
            {
                Form[] children = this.MdiChildren;
                int childCount = children.Length;
                bool[] liveChildren = new bool[childCount];
                int liveCount = 0;
                for (int i = 0; i < childCount; i++)
                {
                    liveChildren[i] = !(children[i].Disposing || children[i].IsDisposed);
                    if (liveChildren[i]) { liveCount++; }
                }
                Session2d[] sessions = new Session2d[liveCount];
                for (int i = 0, j = 0; i < childCount; i++)
                {
                    if (liveChildren[i]) { sessions[j++] = (Session2d)children[i]; }
                }
                return sessions;
            }
        }
        public Session2d ActiveSession
        {
            get
            {
                if (this._activeSession == null)
                {
                    this.FileMenu_NewSession_Click(this, EventArgs.Empty);
                }
                return this._activeSession;
            }
        }
        private int ActiveSessionIndex
        {
            get
            {
                Form child = this.ActiveMdiChild;
                for (int i = 0; i < this.MdiChildren.Length; i++)
                {
                    if (this.MdiChildren[i] == child)
                    {
                        return i;
                    }
                }
                return -1;
            }
            set
            {
                if (value >= 0 && value < this.MdiChildren.Length)
                {
                    this.MdiChildren[value].Activate();
                }
            }
        }
        #endregion
        #region 
        #region 
        System.Windows.Forms.MainMenu ux_mainMenu;
        System.Windows.Forms.MenuItem ux_fileMenu;
        System.Windows.Forms.MenuItem ux_viewMenu;
        System.Windows.Forms.MenuItem ux_toolsMenu;
        System.Windows.Forms.MenuItem ux_helpMenu;
        System.Windows.Forms.MenuItem ux_fileMenu_NewSession;
        System.Windows.Forms.MenuItem ux_fileMenu_OpenSession;
        System.Windows.Forms.MenuItem ux_fileMenu_CloseSession;
        System.Windows.Forms.MenuItem ux_fileMenu_CloseAll;
        System.Windows.Forms.MenuItem ux_fileMenu_SaveSession;
        System.Windows.Forms.MenuItem ux_fileMenu_SaveSessionAs;
        System.Windows.Forms.MenuItem ux_fileMenu_Separator0;
        System.Windows.Forms.MenuItem ux_fileMenu_Separator1;
        System.Windows.Forms.MenuItem ux_fileMenu_StartModeling;
        System.Windows.Forms.MenuItem ux_fileMenu_StopModeling;
        System.Windows.Forms.MenuItem ux_fileMenu_GenerateReports;
        System.Windows.Forms.MenuItem ux_fileMenu_CancelReports;
        System.Windows.Forms.MenuItem ux_fileMenu_Separator2;
        System.Windows.Forms.MenuItem ux_fileMenu_Recent;
        System.Windows.Forms.MenuItem ux_fileMenu_Separator3;
        System.Windows.Forms.MenuItem ux_fileMenu_Exit;
        System.Windows.Forms.MenuItem ux_fileMenu_SaveAll;
        System.Windows.Forms.MenuItem ux_viewMenu_NextSession;
        System.Windows.Forms.MenuItem ux_viewMenu_PreviousSession;
        System.Windows.Forms.MenuItem ux_viewMenu_Separator0;
        System.Windows.Forms.MenuItem ux_viewMenu_ExcelApplication;
        System.Windows.Forms.MenuItem ux_viewMenu_InputFileLocation;
        System.Windows.Forms.MenuItem ux_viewMenu_OutputLocation;
        System.Windows.Forms.MenuItem ux_viewMenu_Separator1;
        System.Windows.Forms.MenuItem ux_viewMenu_UpdateSpeed;
        System.Windows.Forms.MenuItem ux_viewMenu_UpdateSpeed_Realtime;
        System.Windows.Forms.MenuItem ux_viewMenu_UpdateSpeed_High;
        System.Windows.Forms.MenuItem ux_viewMenu_UpdateSpeed_Normal;
        System.Windows.Forms.MenuItem ux_viewMenu_UpdateSpeed_Low;
        System.Windows.Forms.MenuItem ux_viewMenu_UpdateSpeed_Separator0;
        System.Windows.Forms.MenuItem ux_viewMenu_UpdateSpeed_Paused;
        System.Windows.Forms.MenuItem ux_viewMenu_Refresh;
        System.Windows.Forms.MenuItem ux_toolsMenu_ManageInput;
        System.Windows.Forms.MenuItem ux_toolsMenu_ManageOutput;
        System.Windows.Forms.MenuItem ux_toolsMenu_ModelingSettings;
        System.Windows.Forms.MenuItem ux_toolsMenu_RunNewSessionWizard;
        System.Windows.Forms.MenuItem ux_toolsMenu_Separator0;
        System.Windows.Forms.MenuItem ux_toolsMenu_Customize;
        System.Windows.Forms.MenuItem ux_toolsMenu_Options;
        System.Windows.Forms.MenuItem ux_helpMenu_HelpContents;
        System.Windows.Forms.MenuItem ux_helpMenu_SourceCode;
        System.Windows.Forms.MenuItem ux_helpMenu_Separator0;
        System.Windows.Forms.MenuItem ux_helpMenu_About;
        System.Windows.Forms.StatusBar ux_statusBar;
        System.Windows.Forms.StatusBarPanel ux_statusPanel;
        System.Windows.Forms.Panel ux_toolbarPanel;
        System.Windows.Forms.StatusBarPanel ux_versionPanel;
        Volpe.Cafe.Ui.LabelButton ux_newSessionLabelButton;
        Volpe.Cafe.Ui.LabelButton ux_openSessionLabelButton;
        Volpe.Cafe.Ui.LabelButton ux_saveSessionLabelButton;
        Volpe.Cafe.Ui.LabelButton ux_configureFilesLabelButton;
        Volpe.Cafe.Ui.LabelButton ux_configureSettingsLabelButton;
        Volpe.Cafe.Ui.LabelButton ux_stopModelingLabelButton;
        Volpe.Cafe.Ui.LabelButton ux_startModelingLabelButton;
        System.ComponentModel.IContainer components = null;
        #endregion
        static string _startupPath;
        static string _dataPath;
        static string _outputPath;
        static string _themesPath;
        static Cafe2d     _instance;
        static ArrayList  _assemblies;
        static ArrayList  _cmpTypes;        
        static Themes     _themes;
        static UiSettings _settings;
        const int RefreshIntervalRealtime = 125;
        const int RefreshIntervalHigh     = 500;
        const int RefreshIntervalNormal   = 2000;
        const int RefreshIntervalLow      = 4000;
        const int RefreshIntervalPaused   = -1;
        Session2d _activeSession;
        bool _cancelSave;
        bool _cancelCloseAll;
        ArrayList _recentSessions;
        ManageInput _inputManager;
        NewSessionWizard _newSesWizard;
        ProgramArgs _args;
        #endregion
    }
}

