using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Reflection;
using System.Windows.Forms;
using Volpe.Cafe.Collections;
using Volpe.Cafe.Model;
namespace Volpe.Cafe.Ui.Panels
{
    public class GeneralCompliancePanel : CafeUiPanel
    {
        #region 
        private struct ComplianceItem
        {
            public ComplianceItem(ICompliance compliance, ModelDescriptionAttribute attr)
            {
                this.Compliance = compliance;
                this.Attr = attr;
            }
            public override string ToString()
            {
                return this.Attr.FullTitle;
            }
            public ICompliance Compliance;
            public ModelDescriptionAttribute Attr;
        }
        #endregion
        #region 
        public GeneralCompliancePanel()
            : base()
        {
            this.InitializeComponent();
            this.InitializeControls();
            this.InitializeEventHandlers();
        }
        protected override void Dispose(bool disposing)
        {
            base.Dispose(disposing);
        }
        #endregion
        #region 
        #region 
        private void InitializeComponent()
        {
            this.ux_complianceLabel = new System.Windows.Forms.Label();
            this.ux_complianceComboBox = new System.Windows.Forms.ComboBox();
            this.ux_complianceDescriptionRichTextBox = new System.Windows.Forms.RichTextBox();
            this.SuspendLayout();
            this.ux_complianceLabel.AutoSize = true;
            this.ux_complianceLabel.Location = new System.Drawing.Point(8, 8);
            this.ux_complianceLabel.Name = "ux_complianceLabel";
            this.ux_complianceLabel.Size = new System.Drawing.Size(136, 16);
            this.ux_complianceLabel.TabIndex = 0;
            this.ux_complianceLabel.Text = "Select Compliance Model:";
            this.ux_complianceComboBox.Anchor = AnchorStyles.Top | AnchorStyles.Left | AnchorStyles.Right;
            this.ux_complianceComboBox.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.ux_complianceComboBox.Location = new System.Drawing.Point(8, 24);
            this.ux_complianceComboBox.Name = "ux_complianceComboBox";
            this.ux_complianceComboBox.Size = new System.Drawing.Size(336, 21);
            this.ux_complianceComboBox.TabIndex = 1;
            this.ux_complianceDescriptionRichTextBox.Anchor = AnchorStyles.Top | AnchorStyles.Left | AnchorStyles.Right;
            this.ux_complianceDescriptionRichTextBox.BackColor = System.Drawing.SystemColors.Control;
            this.ux_complianceDescriptionRichTextBox.BorderStyle = System.Windows.Forms.BorderStyle.None;
            this.ux_complianceDescriptionRichTextBox.Location = new System.Drawing.Point(8, 48);
            this.ux_complianceDescriptionRichTextBox.Name = "ux_complianceDescriptionRichTextBox";
            this.ux_complianceDescriptionRichTextBox.ReadOnly = true;
            this.ux_complianceDescriptionRichTextBox.ScrollBars = System.Windows.Forms.RichTextBoxScrollBars.Vertical;
            this.ux_complianceDescriptionRichTextBox.Size = new System.Drawing.Size(336, 160);
            this.ux_complianceDescriptionRichTextBox.TabIndex = 2;
            this.ux_complianceDescriptionRichTextBox.Text = "";
            this.Controls.AddRange(
                new Control[] {
                                  this.ux_complianceDescriptionRichTextBox,
                                  this.ux_complianceComboBox,
                                  this.ux_complianceLabel
                              });
            this.Location = new Point(0, 0);
            this.Name = "GeneralCompliancePanel";
            this.Size = new Size(352, 216);
            this.ResumeLayout(false);
        }
        #endregion
        #region 
        private void InitializeControls()
        {
            this._warningDisplayed = false;
            Type[] cmp = Cafe2d.ComplianceTypes;
            for (int i = 0; i < cmp.Length; i++)
            {
                ModelDescriptionAttribute attr = (ModelDescriptionAttribute)Attribute.GetCustomAttribute(cmp[i],
                    typeof(ModelDescriptionAttribute));
                ConstructorInfo ctor = cmp[i].GetConstructor(Type.EmptyTypes);
                ICompliance compliance = (ICompliance)ctor.Invoke(new object[] {});
                ComplianceItem item = new ComplianceItem(compliance, attr);
                this.ux_complianceComboBox.Items.Add(item);
            }
            if (this.ux_complianceComboBox.Items.Count > 0)
            {
                this.ux_complianceComboBox.SelectedIndex = 0;
                bool vt = this._visualTracking;        
                this._visualTracking = false;        
                this.ComplianceComboBox_SelectedIndexChanged(this.ux_complianceComboBox, EventArgs.Empty);
                this._visualTracking = vt;            
            }
        }
        private void InitializeEventHandlers()
        {
            this.Enter += new EventHandler(this.GeneralCompliancePanel_Enter);
            this.ux_complianceComboBox.SelectedIndexChanged += new EventHandler(this.ComplianceComboBox_SelectedIndexChanged);
            this.ux_complianceComboBox.MouseEnter += new EventHandler(this.ComplianceComboBox_MouseEnter);
        }
        #endregion
        #region 
        private void ComplianceComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (this.ux_complianceComboBox.SelectedIndex == -1) { return; }
            ComplianceItem item = (ComplianceItem)this.ux_complianceComboBox.SelectedItem;
            this.ux_complianceDescriptionRichTextBox.Text = item.Attr.Description;
            if (this._visualTracking)
            {
                bool changed = (this._compliance == null ||
                    item.Compliance.GetType().FullName != this._compliance.GetType().FullName);
                this.ux_complianceComboBox.ForeColor = (changed) ? this._visualTrackingColor : Color.Black;
            }
        }
        private void ComplianceComboBox_MouseEnter(object sender, EventArgs e)
        {
            if (this.ux_complianceComboBox.SelectedIndex != -1)
            {
                ComplianceItem item = (ComplianceItem)this.ux_complianceComboBox.SelectedItem;
                this.ux_complianceDescriptionRichTextBox.Text = item.Attr.Description;
            }
        }
        private void GeneralCompliancePanel_Enter(object sender, EventArgs e)
        {
            if (!this._warningDisplayed && this._compliance != null && this._compliance.State != ModelingState.Unstarted)
            {
                MessageBox.Show("Warning!  Changing the compliance type or the modeling extensions requires " +
                    "for the compliance modeling process to be restarted.", "General Compliance Settings",
                    MessageBoxButtons.OK, MessageBoxIcon.Warning);
                this._warningDisplayed = true;
            }
        }
        #endregion
        public void SetInitialState(ICompliance compliance)
        {
            this._compliance = compliance;
            bool vt = this._visualTracking;
            this._visualTracking = false;
            if (compliance != null)
            {
                string complianceFullName = compliance.GetType().FullName;
                for (int i = 0; i < this.ux_complianceComboBox.Items.Count; i++)
                {
                    ComplianceItem item = (ComplianceItem)this.ux_complianceComboBox.Items[i];
                    if (item.Compliance.GetType().FullName == complianceFullName)
                    {
                        this.ux_complianceComboBox.SelectedIndex = i;
                        break;
                    }
                }
            }
            this._visualTracking = vt;
            this._checkChanges.Clear();
        }
        public override void SaveChanges()
        {
            if (this.SettingsChanged)
            {
                ICompliance selectedCompliance = this.SelectedCompliance;
                ConstructorInfo ctor = selectedCompliance.GetType().GetConstructor(Type.EmptyTypes);
                this._compliance = (ICompliance)ctor.Invoke(new object[] {});
                if (this._visualTracking)
                {   
                    Color color = Control.DefaultForeColor;
                    this.ux_complianceComboBox.ForeColor = color;
                }
                this._checkChanges.Clear();
            }
        }
        #endregion
        #region 
        [Browsable(false)]
        public override bool SettingsChanged
        {
            get
            {
                if (base.SettingsChanged)
                {
                    return true;
                }
                else if (this.ux_complianceComboBox.SelectedIndex == -1)
                {
                    return true;
                }
                else
                {   
                    ComplianceItem item = (ComplianceItem)this.ux_complianceComboBox.SelectedItem;
                    if (this._compliance == null ||
                        this._compliance.GetType().FullName != item.Compliance.GetType().FullName)
                    {
                        return true;
                    }
                    else
                    {   
                        return false;
                    }
                } 
            }
        }
        [Browsable(false)]
        public ICompliance Compliance
        {
            get { return this._compliance; }
        }
        [Browsable(false)]
        public ICompliance SelectedCompliance
        {
            get
            {
                if (this.ux_complianceComboBox.SelectedIndex == -1) { return null; }
                ComplianceItem item = (ComplianceItem)this.ux_complianceComboBox.SelectedItem;
                return item.Compliance;
            }
        }
        #endregion
        #region 
        #region 
        private System.Windows.Forms.Label ux_complianceLabel;
        private System.Windows.Forms.ComboBox ux_complianceComboBox;
        private System.Windows.Forms.RichTextBox ux_complianceDescriptionRichTextBox;
        #endregion
        private ICompliance _compliance;
        private bool _warningDisplayed;
        #endregion
    }
}

