using System;
using System.Diagnostics;
using System.IO;
using System.Windows.Forms;
namespace Volpe.Cafe.Ui
{
    public sealed class Program
    {
        #region 
        private Program()
        {
        }
        #endregion
        #region 
        [STAThread]
        public static void Main(string[] args)
        {
            #if !DEBUG
                string logPath = Path.GetDirectoryName(Application.StartupPath) + "\\logs\\";
                if (!Directory.Exists(logPath)) { Directory.CreateDirectory(logPath); }
                string logFile = logPath + DateTime.Now.Ticks + ".log";
                StreamWriter logSw = new StreamWriter(logFile, false);
                logSw.AutoFlush = true;
                Console.SetOut(logSw);
            #endif
            Console.WriteLine("Starting run at:  {0}", DateTime.Now.ToString());
            Program program = new Program();
            program.Run(args);
            Console.WriteLine("Exiting model at: {0}", DateTime.Now.ToString());
            #if !DEBUG
                logSw.Close();
            #endif
        }
        private void Run(string[] args)
        {
            try
            {
                ProgramArgs pa = new ProgramArgs();
                pa.Parse(args);
                Cafe2d ui = Cafe2d.CreateInstance();
                if (pa.Uninstall)
                {   
                    Process.Start("msiexec.exe", "/x " + pa.UninstallProductKey + " /qf");
                }
                else
                {   
                    if (Program.DisplayWarning())
                    {   
                        ui.Start(pa);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "CAFE Model Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                Console.WriteLine(ex.ToString());
            }
        }
        internal static bool DisplayWarning()
        {
            DialogResult dlg = MessageBox.Show("U.S. DEPARTMENT OF TRANSPORTATION\n\nWARNINGS\n\n" +
                "1.  This software was developed for analysis by U.S. Department of Transportation staff\n" +
                "of potential fuel economy requirements.\n\n" +
                "2.  This software uses input files containing detailed information regarding vehicles\n" +
                "manufactured for sale in the United States and creates output files containing similarly\n" +
                "detailed information regarding such vehicles.  If input files containing information in\n" +
                "any way (e.g., based on entitlement under 5 U.S.C 552 to confidential treatment)\n" +
                "protected from disclosure to the public are used, some output files created by this\n" +
                "software must also be protected from disclosure to the public.\n\n" +
                "Do you understand these warnings?", "CAFE Model",
                MessageBoxButtons.YesNo);
            return dlg == DialogResult.Yes;
        }
        internal static void DisplayAbout()
        {
            string ver = Application.ProductVersion;
            string ts = File.GetLastWriteTime(Application.ExecutablePath).ToString("M/dd/yy H:mm:ss");
            MessageBox.Show("U.S. Department of Transportation\n\n" + "Version:\t" + ver + "\nDate:\t" + ts + "\n\n" +
                "System requirements:\n\n" +
                "1 GHz or faster Intel compatible processor (2 GHz or faster, recommended)\n" +
                "1 GB RAM (2 GB recommended)\n" +
                "20 MB hard drive space for installation, plus additional 4 GB during runtime\n\n" +
                "Microsoft Windows XP\n" +
                "Microsoft .NET Framework 1.1\n" +
                "Microsoft Visual J# 1.1 Redistributable\n" +
                "Microsoft Office 2003\n\n" +
                "Contact:\n\n" + Program.ContactName + "\nU.S. Department of Transportation\n" +
                "Volpe National Transportation Systems Center\n55 Broadway\nCambridge, MA  02142\n\n" +
                "Voice:\t" + Program.ContactPhone +
                "\nFax:\t" + Program.ContactFax +
                "\nE-Mail:\t" + Program.ContactEmail, "CAFE Model");
        }
        #endregion
        #region 
        internal const string ContactName  = "Kevin Green";
        internal const string ContactEmail = "green@volpe.dot.gov";
        internal const string ContactPhone = "(617) 494-2106";
        internal const string ContactFax   = "(617) 494-3688";
        #endregion
    }
}

