using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
namespace Volpe.Cafe.Ui.Wizards
{
    internal class NSW_Complete : Panel
    {
        #region 
        public NSW_Complete()
        {
            this.InitializeComponent();
        }
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (this.components != null)
                {
                    this.components.Dispose();
                }
            }
            base.Dispose(disposing);
        }
        #endregion
        #region 
        private void InitializeComponent()
        {
            this.ux_body0Label = new System.Windows.Forms.Label();
            this.ux_sessionNameLabel = new System.Windows.Forms.Label();
            this.ux_sessionNameTextBox = new System.Windows.Forms.TextBox();
            this.ux_saveSessionCheckBox = new System.Windows.Forms.CheckBox();
            this.SuspendLayout();
            this.ux_body0Label.Location = new System.Drawing.Point(8, 8);
            this.ux_body0Label.Name = "ux_body0Label";
            this.ux_body0Label.Size = new System.Drawing.Size(408, 56);
            this.ux_body0Label.TabIndex = 1;
            this.ux_body0Label.Text = "Before exiting the wizard, please specify a name for " +
                "your new session.  The session name may not contain any of the following " +
                "characters: / \\ : * ? \" < > |.  Also, upon exiting the wizard, you may " +
                "want to save your session so that you can load it at a later time.";
            this.ux_sessionNameLabel.AutoSize = true;
            this.ux_sessionNameLabel.Location = new System.Drawing.Point(16, 72);
            this.ux_sessionNameLabel.Name = "ux_sessionNameLabel";
            this.ux_sessionNameLabel.Size = new System.Drawing.Size(77, 17);
            this.ux_sessionNameLabel.TabIndex = 2;
            this.ux_sessionNameLabel.Text = "Session name:";
            this.ux_sessionNameLabel.TextAlign = System.Drawing.ContentAlignment.BottomLeft;
            this.ux_sessionNameTextBox.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_sessionNameTextBox.Location = new System.Drawing.Point(96, 72);
            this.ux_sessionNameTextBox.Name = "ux_sessionNameTextBox";
            this.ux_sessionNameTextBox.Size = new System.Drawing.Size(136, 21);
            this.ux_sessionNameTextBox.TabIndex = 3;
            this.ux_sessionNameTextBox.Text = "";
            this.ux_sessionNameTextBox.TextChanged += new EventHandler(this.SessionNameTextBox_TextChanged);
            this.ux_saveSessionCheckBox.Location = new System.Drawing.Point(16, 96);
            this.ux_saveSessionCheckBox.Name = "ux_saveSessionCheckBox";
            this.ux_saveSessionCheckBox.Size = new System.Drawing.Size(232, 16);
            this.ux_saveSessionCheckBox.TabIndex = 4;
            this.ux_saveSessionCheckBox.Text = "Yes, I would like to save the session now.";
            this.Controls.AddRange(
                new Control[] {
                                  this.ux_body0Label,
                                  this.ux_sessionNameLabel,
                                  this.ux_sessionNameTextBox,
                                  this.ux_saveSessionCheckBox
                              });
            this.Name = "NSW_Complete";
            this.Size = new System.Drawing.Size(416, 335);
            this.ResumeLayout(false);
        }
        private void SessionNameTextBox_TextChanged(object sender, EventArgs e)
        {
            string[] replace = new string[] {"/", "\\", ":", "*", "?", "\"", "<", ">", "|"};
            string text = this.ux_sessionNameTextBox.Text;
            bool replaced = false;
            for (int i = 0; i < replace.Length; i++)
            {
                if (text.IndexOf(replace[i]) != -1)
                {
                    text = text.Replace(replace[i], "");
                    replaced = true;
                }
            }
            if (replaced)
            {
                this.ux_sessionNameTextBox.Text = text;
                MessageBox.Show("A session name cannot contain any of the following " +
                    "characters:\r\n\r\n\t/ \\ : * ? \" < > |", "", MessageBoxButtons.OK);
            }
        }
        public void SetInitialState(string sessionName)
        {
            this.ux_sessionNameTextBox.Text = sessionName;
        }
        #endregion
        #region 
        public string SessionName
        {
            get
            {
                return this.ux_sessionNameTextBox.Text.Trim();
            }
        }
        public bool SaveSession
        {
            get
            {
                return this.ux_saveSessionCheckBox.Checked;
            }
        }
        #endregion
        #region 
        #region 
        private System.Windows.Forms.Label ux_body0Label;
        private System.Windows.Forms.Label ux_sessionNameLabel;
        private System.Windows.Forms.TextBox ux_sessionNameTextBox;
        private System.Windows.Forms.CheckBox ux_saveSessionCheckBox;
        protected System.ComponentModel.IContainer components = null;
        #endregion
        #endregion
    }
}

