using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
namespace Volpe.Cafe.Ui.Wizards
{
    internal class NSW_ConfigureModelInput : Panel
    {
        #region 
        public NSW_ConfigureModelInput()
        {
            this.InitializeComponent();
        }
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (this.components != null)
                {
                    this.components.Dispose();
                }
            }
            base.Dispose(disposing);
        }
        #endregion
        #region 
        private void InitializeComponent()
        {
            this.ux_body0Label = new System.Windows.Forms.Label();
            this.ux_body1Label = new System.Windows.Forms.Label();
            this.ux_enterPasswordCheckBox = new System.Windows.Forms.CheckBox();
            this.ux_body0Label.Location = new System.Drawing.Point(8, 8);
            this.ux_body0Label.Name = "ux_body0Label";
            this.ux_body0Label.Size = new System.Drawing.Size(408, 48);
            this.ux_body0Label.TabIndex = 0;
            this.ux_body0Label.Text = "The CAFE Model uses Excel files for storing vehicle manufacturer " +
                "data as well as core modeling configuration files.  The next couple of screens will " +
                "allow you to select the files containing the necessary data.";
            this.ux_body1Label.Location = new System.Drawing.Point(8, 64);
            this.ux_body1Label.Name = "ux_body1Label";
            this.ux_body1Label.Size = new System.Drawing.Size(408, 112);
            this.ux_body1Label.TabIndex = 1;
            this.ux_body1Label.Text = "For security purposes, the input files may be encrypted and " +
                "password protected.  The model will not be able to read password protected files if an " +
                "input password is not specified.  If the data files are password protected and you " +
                "know the password, or if you are not certain whether the input data is encrypted but " +
                "still would like to enter a password, please check-on the checkbox below.  If you " +
                "dont know the password, you may leave the checkbox unchecked and let the model attempt " +
                "to load the data files.  If you are not sure what to do, leave the checkbox unchecked.";
            this.ux_enterPasswordCheckBox.Location = new System.Drawing.Point(16, 184);
            this.ux_enterPasswordCheckBox.Name = "ux_enterPasswordCheckBox";
            this.ux_enterPasswordCheckBox.Size = new System.Drawing.Size(344, 16);
            this.ux_enterPasswordCheckBox.TabIndex = 2;
            this.ux_enterPasswordCheckBox.Text = "Yes, I would like to enter an input password on the next screen.";
            this.Controls.AddRange(
                new Control[] {
                                  this.ux_body0Label,
                                  this.ux_body1Label,
                                  this.ux_enterPasswordCheckBox
                              });
            this.Name = "NSW_ConfigureModelInput";
            this.Size = new System.Drawing.Size(416, 335);
            this.ResumeLayout(false);
        }
        public void SetInitialState(ModelingSettings modelingSettings)
        {
            this.ux_enterPasswordCheckBox.Checked =
                modelingSettings.EncryptionSettings.EncryptInput;
        }
        #endregion
        #region 
        public bool EnterInputPassword
        {
            get
            {
                return this.ux_enterPasswordCheckBox.Checked;
            }
        }
        #endregion
        #region 
        #region 
        private System.Windows.Forms.Label ux_body0Label;
        private System.Windows.Forms.Label ux_body1Label;
        private System.Windows.Forms.CheckBox ux_enterPasswordCheckBox;
        protected System.ComponentModel.IContainer components = null;
        #endregion
        #endregion
    }
}

