using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Threading;
using System.Windows.Forms;
using Volpe.Cafe.Collections;
using Volpe.Cafe.Data;
using Volpe.Cafe.Model;
using Volpe.Cafe.Model.MonteCarlo;
using Volpe.Cafe.Model.Optimization;
using Volpe.Cafe.Ui;
using Volpe.Cafe.Ui.Panels;
namespace Volpe.Cafe.Ui.Wizards
{
    public class NewSessionWizard : Form
    {
        #region 
        struct NSW_WizardPanels
        {
            public NSW_Welcome                    Welcome;                      
            public NSW_SelectComplianceModel      SelectComplianceModel;        
            public NSW_ConfigureModelInput        ConfigureModelInput;          
            public NSW_EnterInputPassword         EnterInputPassword;           
            public NSW_SelectInputFiles           SelectInputFiles;             
            public NSW_SelectOperatingModes       SelectOperatingModes;         
            public NSW_ConfigureModelOutput       ConfigureModelOutput;         
            public NSW_EnterOutputPassword        EnterOutputPassword;          
            public NSW_SelectReports              SelectReports;                
            public NSW_SelectOutputPaths          SelectOutputPaths;            
            public NSW_Complete                   Complete;                     
            public Panel this[int index]
            {
                get
                {
                    if      (index ==  0) return (Panel)this.Welcome;
                    else if (index ==  1) return (Panel)this.SelectComplianceModel;
                    else if (index ==  2) return (Panel)this.ConfigureModelInput;
                    else if (index ==  3) return (Panel)this.EnterInputPassword;
                    else if (index ==  4) return (Panel)this.SelectInputFiles;
                    else if (index ==  5) return (Panel)this.SelectOperatingModes;
                    else if (index ==  6) return (Panel)this.ConfigureModelOutput;
                    else if (index ==  7) return (Panel)this.EnterOutputPassword;
                    else if (index ==  8) return (Panel)this.SelectReports;
                    else if (index ==  9) return (Panel)this.SelectOutputPaths;
                    else if (index == 10) return (Panel)this.Complete;
                    else throw new IndexOutOfRangeException();
                }
                set
                {
                    if      (index ==  0) this.Welcome                    = (NSW_Welcome              )value;
                    else if (index ==  1) this.SelectComplianceModel      = (NSW_SelectComplianceModel)value;
                    else if (index ==  2) this.ConfigureModelInput        = (NSW_ConfigureModelInput  )value;
                    else if (index ==  3) this.EnterInputPassword         = (NSW_EnterInputPassword   )value;
                    else if (index ==  4) this.SelectInputFiles           = (NSW_SelectInputFiles     )value;
                    else if (index ==  5) this.SelectOperatingModes       = (NSW_SelectOperatingModes )value;
                    else if (index ==  6) this.ConfigureModelOutput       = (NSW_ConfigureModelOutput )value;
                    else if (index ==  7) this.EnterOutputPassword        = (NSW_EnterOutputPassword  )value;
                    else if (index ==  8) this.SelectReports              = (NSW_SelectReports        )value;
                    else if (index ==  9) this.SelectOutputPaths          = (NSW_SelectOutputPaths    )value;
                    else if (index == 10) this.Complete                   = (NSW_Complete             )value;
                    else throw new IndexOutOfRangeException();
                }
            }
        }
        #endregion
        #region 
        public NewSessionWizard(Cafe2d parent)
            : this(new Session2d(parent))
        {
            this._session.Settings.UseRecommendedSettings();
        }
        public NewSessionWizard(Session2d session)
        {
            if (session == null)
            {
                throw new ArgumentNullException("session", "The specified session cannot be null.");
            }
            this.InitializeComponent();
            this._session = session;
            this._saveSession = false;
            this._currentIndex = 0;
            this._inputPanelInitialized  = false;
            this._inputPanelSaveComplete = false;
            this._cancelTreeNodeSelect   = true;
            this._cancelTreeNodeExpandOrCollapse = true;
            Industry data = session.Data;
            if (data == null)
            {
                this._minYear = DateTime.Now.Year;
                this._maxYear = this._minYear + 25;
            }
            else
            {
                this._minYear = data.MinYear.Year;
                this._maxYear = data.MaxYear.Year;
            }
        }
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }
        #endregion
        #region 
        #region 
        void InitializeComponent()
        {
            this.ux_navigationTreeView = new System.Windows.Forms.TreeView();
            this.ux_settingsPanel = new System.Windows.Forms.Panel();
            this.ux_toolbarPanel = new System.Windows.Forms.Panel();
            this.ux_closeLabelButton = new Volpe.Cafe.Ui.LabelButton();
            this.ux_saveLabelButton = new Volpe.Cafe.Ui.LabelButton();
            this.ux_nextLabelButton = new Volpe.Cafe.Ui.LabelButton();
            this.ux_previousLabelButton = new Volpe.Cafe.Ui.LabelButton();
            this.ux_statusLabel = new System.Windows.Forms.Label();
            this.ux_toolbarPanel.SuspendLayout();
            this.SuspendLayout();
            this.ux_navigationTreeView.BackColor = System.Drawing.Color.WhiteSmoke;
            this.ux_navigationTreeView.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_navigationTreeView.Dock = System.Windows.Forms.DockStyle.Left;
            this.ux_navigationTreeView.ForeColor = System.Drawing.Color.Black;
            this.ux_navigationTreeView.FullRowSelect = true;
            this.ux_navigationTreeView.HideSelection = false;
            this.ux_navigationTreeView.ImageIndex = -1;
            this.ux_navigationTreeView.Location = new System.Drawing.Point(0, 0);
            this.ux_navigationTreeView.Name = "ux_navigationTreeView";
            this.ux_navigationTreeView.SelectedImageIndex = -1;
            this.ux_navigationTreeView.ShowPlusMinus = false;
            this.ux_navigationTreeView.Size = new System.Drawing.Size(200, 391);
            this.ux_navigationTreeView.TabIndex = 0;
            this.ux_navigationTreeView.TabStop = false;
            this.ux_navigationTreeView.BeforeSelect += new System.Windows.Forms.TreeViewCancelEventHandler(this.NavigationTreeView_BeforeSelect);
            this.ux_navigationTreeView.BeforeExpand += new System.Windows.Forms.TreeViewCancelEventHandler(this.NavigationTreeView_BeforeExpandOrCollaps);
            this.ux_navigationTreeView.BeforeCollapse += new System.Windows.Forms.TreeViewCancelEventHandler(this.NavigationTreeView_BeforeExpandOrCollaps);
            this.ux_settingsPanel.Dock = System.Windows.Forms.DockStyle.Fill;
            this.ux_settingsPanel.Location = new System.Drawing.Point(200, 0);
            this.ux_settingsPanel.Name = "ux_settingsPanel";
            this.ux_settingsPanel.Size = new System.Drawing.Size(418, 335);
            this.ux_settingsPanel.TabIndex = 1;
            this.ux_toolbarPanel.Controls.Add(this.ux_closeLabelButton);
            this.ux_toolbarPanel.Controls.Add(this.ux_saveLabelButton);
            this.ux_toolbarPanel.Controls.Add(this.ux_nextLabelButton);
            this.ux_toolbarPanel.Controls.Add(this.ux_previousLabelButton);
            this.ux_toolbarPanel.Dock = System.Windows.Forms.DockStyle.Bottom;
            this.ux_toolbarPanel.Location = new System.Drawing.Point(200, 335);
            this.ux_toolbarPanel.Name = "ux_toolbarPanel";
            this.ux_toolbarPanel.Size = new System.Drawing.Size(418, 56);
            this.ux_toolbarPanel.TabIndex = 2;
            this.ux_closeLabelButton.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_closeLabelButton.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_closeLabelButton.Location = new System.Drawing.Point(368, 8);
            this.ux_closeLabelButton.Name = "ux_closeLabelButton";
            this.ux_closeLabelButton.Size = new System.Drawing.Size(32, 32);
            this.ux_closeLabelButton.TabIndex = 3;
            this.ux_closeLabelButton.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.ux_closeLabelButton.Click += new System.EventHandler(this.CloseLabelButton_Click);
            this.ux_saveLabelButton.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_saveLabelButton.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_saveLabelButton.Enabled = false;
            this.ux_saveLabelButton.Location = new System.Drawing.Point(328, 8);
            this.ux_saveLabelButton.Name = "ux_saveLabelButton";
            this.ux_saveLabelButton.Size = new System.Drawing.Size(32, 32);
            this.ux_saveLabelButton.TabIndex = 2;
            this.ux_saveLabelButton.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.ux_saveLabelButton.Click += new System.EventHandler(this.SaveLabelButton_Click);
            this.ux_nextLabelButton.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_nextLabelButton.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_nextLabelButton.Location = new System.Drawing.Point(288, 8);
            this.ux_nextLabelButton.Name = "ux_nextLabelButton";
            this.ux_nextLabelButton.Size = new System.Drawing.Size(32, 32);
            this.ux_nextLabelButton.TabIndex = 1;
            this.ux_nextLabelButton.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.ux_nextLabelButton.Click += new System.EventHandler(this.NextLabelButton_Click);
            this.ux_previousLabelButton.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_previousLabelButton.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_previousLabelButton.Enabled = false;
            this.ux_previousLabelButton.Location = new System.Drawing.Point(248, 8);
            this.ux_previousLabelButton.Name = "ux_previousLabelButton";
            this.ux_previousLabelButton.Size = new System.Drawing.Size(32, 32);
            this.ux_previousLabelButton.TabIndex = 0;
            this.ux_previousLabelButton.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.ux_previousLabelButton.Click += new System.EventHandler(this.PreviousLabelButton_Click);
            this.ux_statusLabel.Location = new System.Drawing.Point(208, 344);
            this.ux_statusLabel.Name = "ux_statusLabel";
            this.ux_statusLabel.Size = new System.Drawing.Size(240, 40);
            this.ux_statusLabel.TabIndex = 3;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 14);
            this.ClientSize = new System.Drawing.Size(618, 391);
            this.ControlBox = false;
            this.Controls.Add(this.ux_statusLabel);
            this.Controls.Add(this.ux_settingsPanel);
            this.Controls.Add(this.ux_toolbarPanel);
            this.Controls.Add(this.ux_navigationTreeView);
            this.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.Name = "NewSessionWizard";
            this.ShowInTaskbar = false;
            this.Text = "CAFE Model - New Session Wizard";
            this.Load += new System.EventHandler(this.NewSessionWizard_Load);
            this.ux_toolbarPanel.ResumeLayout(false);
            this.ResumeLayout(false);
        }
        #endregion
        #region 
        private void NewSessionWizard_Idle(object sender, System.EventArgs e)
        {
            this.ux_saveLabelButton.Enabled = this._inputPanelInitialized &&
                (this._panels.Complete.SessionName.Trim() != "");
            ICompliance compliance = this._panels.SelectComplianceModel.SelectedCompliance;
            if (compliance != null)
            {
                InputPanel ip = this._panels.SelectInputFiles.InputPanel;
                ip.ShowMarketData   = compliance.RequiresMarketData;
                ip.ShowTechnologies = compliance.RequiresTechnologies;
                ip.ShowParameters   = compliance.RequiresParameters;
                ip.ShowEmissions    = compliance.RequiresEmissions;
                ip.ShowScenarios    = compliance.RequiresScenarios;
            }
        }
        private void NewSessionWizard_Load(object sender, System.EventArgs e)
        {
            this.Font = Cafe2d.DefaultFont;
            this.ux_previousLabelButton.ThemeInitialize("back", true);
            this.ux_nextLabelButton.ThemeInitialize("next", true);
            this.ux_saveLabelButton.ThemeInitialize("save", true);
            this.ux_closeLabelButton.ThemeInitialize("close", true);
            TreeNode rootNode =
                new TreeNode("New Session Wizard", new TreeNode[]
                    {
                        new TreeNode("Select Compliance Model"),
                        new TreeNode("Configure Model Input", new TreeNode[]
                            {
                                new TreeNode("Enter Password"),
                                new TreeNode("Select Input Files")
                            }),
                        new TreeNode("Select Operating Modes"),
                        new TreeNode("Configure Model Output", new TreeNode[]
                            {
                                new TreeNode("Enter Password"),
                                new TreeNode("Select Reports"),
                                new TreeNode("Select Output Paths")
                            }),
                        new TreeNode("Complete!")
                    });
            this._cancelTreeNodeExpandOrCollapse = false;
            rootNode.ForeColor = Color.WhiteSmoke;
            rootNode.BackColor = Color.Black;
            rootNode.ExpandAll();
            rootNode.Nodes[0].Collapse();    
            this._nodes = Global.GetTreeNodeFlatList(rootNode);
            this.ux_navigationTreeView.Nodes.Add(rootNode);
            this.ux_navigationTreeView.SelectedNode = rootNode;
            this._cancelTreeNodeExpandOrCollapse = true;
            this._panels = new NSW_WizardPanels();
            this._visiblePanels = new bool[12];
            this._panels[ 0] = new NSW_Welcome();
            this._panels[ 1] = new NSW_SelectComplianceModel();
            this._panels[ 2] = new NSW_ConfigureModelInput();
            this._panels[ 3] = new NSW_EnterInputPassword();
            this._panels[ 4] = new NSW_SelectInputFiles();
            this._panels[ 5] = new NSW_SelectOperatingModes();
            this._panels[ 6] = new NSW_ConfigureModelOutput();
            this._panels[ 7] = new NSW_EnterOutputPassword();
            this._panels[ 8] = new NSW_SelectReports();
            this._panels[ 9] = new NSW_SelectOutputPaths();
            this._panels[10] = new NSW_Complete();
            for (int i = 0; i < 11; i++)
            {
                this._panels[i].Font = Cafe2d.DefaultFont;
                this._visiblePanels[i] = true;
            }
            for (int i = 0; i < 11; i++)
            {
                if (!this._visiblePanels[i]) { rootNode.Nodes.Remove(this._nodes[i]); }
            }
            this._panels.SelectComplianceModel.SetInitialState(this._session.Compliance);
            this._panels.ConfigureModelInput.SetInitialState(this._session.Settings);
            this._panels.EnterInputPassword.SetInitialState(this._session.Settings);
            this._panels.SelectInputFiles.InputPanel.FilesLoaded += new EventHandler(this.InputPanel_FilesLoaded);
            this._panels.SelectInputFiles.InputPanel.InputStateChanged += new InputStateChangedEventHandler(this.InputPanel_InputStateChanged);
            this._panels.SelectOperatingModes.SetInitialState(this._session.Settings, this._minYear, this._maxYear);
            this._panels.ConfigureModelOutput.SetInitialState(this._session.Settings);
            this._panels.EnterOutputPassword.SetInitialState(this._session.Settings);
            this._panels.SelectReports.SetInitialState(this._session.Settings);
            this._panels.SelectOutputPaths.SetInitialState(this._session.Settings);
            this._panels.Complete.SetInitialState(this._session.SessionName);
            this.ux_settingsPanel.Controls.Add(this._panels[0]);
            Application.Idle += new EventHandler(this.NewSessionWizard_Idle);
            this.Closing += new System.ComponentModel.CancelEventHandler(this.NewSessionWizard_Closing);
            this.ParseFiles(this._filesToParse);
        }
        private void NewSessionWizard_Closing(object sender, CancelEventArgs e)
        {
            Application.Idle -= new EventHandler(this.NewSessionWizard_Idle);
        }
        private void NavigationTreeView_BeforeSelect(object sender, TreeViewCancelEventArgs e)
        {
            e.Cancel = this._cancelTreeNodeSelect;
        }
        private void NavigationTreeView_BeforeExpandOrCollaps(object sender, TreeViewCancelEventArgs e)
        {
            e.Cancel = this._cancelTreeNodeExpandOrCollapse;
        }
        private void PreviousLabelButton_Click(object sender, System.EventArgs e)
        {
            if (this._currentIndex > 0)
            {
                this._nodes[this._currentIndex].ForeColor = Color.Black;
                this._nodes[this._currentIndex].BackColor = Color.WhiteSmoke;
                this._currentIndex--;
                this._nodes[this._currentIndex].NodeFont = this.Font;
                this.RefreshPanels(false);
            }
            this.ux_previousLabelButton.Enabled = (this._currentIndex > 0);
            this.ux_nextLabelButton.Enabled = (this._currentIndex + 1 < this._nodes.Length);
        }
        private void NextLabelButton_Click(object sender, System.EventArgs e)
        {
            if (this._currentIndex < this._nodes.Length)
            {
                this._nodes[this._currentIndex].ForeColor = Color.DarkGray;
                this._nodes[this._currentIndex].BackColor = Color.WhiteSmoke;
                this._nodes[this._currentIndex].NodeFont = new Font(this.Font, FontStyle.Italic);
                this._currentIndex++;
                this.RefreshPanels(true);
            }
            this.ux_previousLabelButton.Enabled = (this._currentIndex > 0);
            this.ux_nextLabelButton.Enabled = (this._currentIndex + 1 < this._nodes.Length);
        }
        private void SaveLabelButton_Click(object sender, System.EventArgs e)
        {
            this.ux_settingsPanel.Enabled = false;
            this.ux_toolbarPanel.Enabled = false;
            this.ux_statusLabel.Text = "Saving session, please wait.";
            this.ux_statusLabel.ForeColor = Color.DarkRed;
            this.ux_statusLabel.Font = new Font(this.Font.Name, 9.75F, FontStyle.Bold);
            if (this._panels.SelectInputFiles.InputPanel.SettingsChanged)
            {
                this._panels.SelectInputFiles.InputPanel.SaveChanges();
            }
            else
            {
                this._inputPanelSaveComplete = true;
            }
            this._session.Compliance = this._panels.SelectComplianceModel.SelectedCompliance;
            this._session.Settings.EncryptionSettings.EncryptInput  = this._panels.ConfigureModelInput.EnterInputPassword;
            this._session.Settings.EncryptionSettings.InputPassword = this._panels.EnterInputPassword.InputPassword;
            this._panels.SelectOperatingModes.OpModesPanel.SaveChanges();
            this._session.Settings.OperatingModes = this._panels.SelectOperatingModes.OpModesPanel.OperatingModes;
            this._session.Settings.EncryptionSettings.EncryptOutput        = this._panels.ConfigureModelOutput.EnterOutputPassword;
            this._session.Settings.EncryptionSettings.OutputPasswordToOpen = this._panels.EnterOutputPassword.OutputPassword;
            this._session.Settings.OutputSettings.GenerateReports               = true;
            this._session.Settings.OutputSettings.GenerateIndustryReport        = this._panels.SelectReports.IndustryReport;
            this._session.Settings.OutputSettings.GenerateManufacturersReport   = this._panels.SelectReports.ManufacturersReport;
            this._session.Settings.OutputSettings.GenerateVehiclesReport        = this._panels.SelectReports.VehiclesReport;
            this._session.Settings.OutputSettings.GenerateScenarioSummaryReport = this._panels.SelectReports.ScenarioSummaryReport;
            this._panels.SelectOutputPaths.OutputPanel.SaveChanges();
            this._session.Settings.OutputSettings.OutputPath = this._panels.SelectOutputPaths.OutputPanel.OutputSettings.OutputPath;
            System.IO.Directory.CreateDirectory(this._session.Settings.OutputSettings.OutputPath);
            if (this._panels.Complete.SessionName.Trim() != "")
            {
                this._session.SessionName = this._panels.Complete.SessionName;
            }
            this._saveSession = this._panels.Complete.SaveSession;
            int dots = 0;
            while (!this._inputPanelSaveComplete)
            {
                Thread.Sleep(150);
                this.ux_statusLabel.Text = "Creating session, please wait" + new string('.', dots);
                dots++;
                if (dots > 6) dots = 0;
                Application.DoEvents();
            }
            this.DialogResult = DialogResult.OK;
            this.Close();
        }
        private void CloseLabelButton_Click(object sender, System.EventArgs e)
        {
            this.Close();
        }
        private void InputPanel_InputStateChanged(object sender, bool enabled)
        {
            this.ux_toolbarPanel.Enabled = enabled;
            if (enabled)
            {
                this.ux_saveLabelButton.Enabled = true;
            }
        }
        private void InputPanel_FilesLoaded(object sender, EventArgs e)
        {
            InputPanel ip = (InputPanel)sender;
            if (ip.MarketData != null)
            {
                this._session.Data = ip.MarketData;
                this._session.Settings.InputSettings.MarketDataFile = ip.MarketDataFile;
                this._session.Settings.InputSettings.MarketDataFileLoaded = true;
                this._session.Settings.Changes.ModelingDataChanged = true;
            }
            if (ip.Technologies != null)
            {
                this._session.Settings.Technologies = ip.Technologies.Data;
                this._session.Settings.InputSettings.TechnologiesFile = ip.TechnologiesFile;
                this._session.Settings.InputSettings.TechnologiesFileLoaded = true;
                this._session.Settings.Changes.TechnologiesDataChanged = true;
            }
            if (ip.Parameters != null)
            {
                this._session.Settings.Parameters = ip.Parameters;
                this._session.Settings.InputSettings.ParametersFile = ip.ParametersFile;
                this._session.Settings.InputSettings.ParametersFileLoaded = true;
                this._session.Settings.Changes.ParametersDataChanged = true;
            }
            if (ip.EmissionsRates != null)
            {
                this._session.Settings.EmissionsRates = ip.EmissionsRates;
                this._session.Settings.InputSettings.EmissionsRatesFile = ip.EmissionsRatesFile;
                this._session.Settings.InputSettings.EmissionsRatesFileLoaded = true;
                this._session.Settings.Changes.EmissionsDataChanged = true;
            }
            if (ip.Scenarios != null)
            {
                this._session.Settings.Scenarios = ip.Scenarios.Data;
                this._session.Settings.InputSettings.ScenariosFile = ip.ScenariosFile;
                this._session.Settings.InputSettings.ScenariosFileLoaded = true;
                this._session.Settings.Changes.ScenariosDataChanged = true;
            }
            this._inputPanelSaveComplete = true;
        }
        #endregion
        public void ParseFiles(string[] files)
        {
            if (files == null) { return; }
            if (this.Visible)
            {
                while (this._panels[this._currentIndex] != this._panels.SelectInputFiles)
                {
                    this.NextLabelButton_Click(this.ux_nextLabelButton, EventArgs.Empty);
                }
                this._panels.SelectInputFiles.InputPanel.ParseFiles(files);
            }
            else
            {
                this._filesToParse = files;
            }
        }
        void RefreshPanels(bool skipForward)
        {
            if (!this._visiblePanels[this._currentIndex])
            {
                if (skipForward) { this.NextLabelButton_Click     (this, EventArgs.Empty); }
                else             { this.PreviousLabelButton_Click(this, EventArgs.Empty); }
            }
            Panel panel = this._panels[this._currentIndex];
            this._nodes[this._currentIndex].ForeColor = Color.WhiteSmoke;
            this._nodes[this._currentIndex].BackColor = Color.Black;
            this.ux_navigationTreeView.SelectedNode = this._nodes[this._currentIndex];
            this.ux_settingsPanel.Controls.Clear();
            this.ux_settingsPanel.Controls.Add(panel);
            if (panel == this._panels.SelectComplianceModel)
            {
            }
            else if (panel == this._panels.ConfigureModelInput)
            {
            }
            else if (panel == this._panels.EnterInputPassword)
            {
                if (!this._panels.ConfigureModelInput.EnterInputPassword)
                {
                    if (skipForward)
                    {
                        this.NextLabelButton_Click(this, EventArgs.Empty);
                    }
                    else
                    {
                        this.PreviousLabelButton_Click(this, EventArgs.Empty);
                    }
                }
            }
            else if (panel == this._panels.SelectInputFiles)
            {
                string password = (this._panels.ConfigureModelInput.EnterInputPassword) ?
                    this._panels.EnterInputPassword.InputPassword : null;
                if (this._inputPanelInitialized)
                {
                    this._panels.SelectInputFiles.UpdatePassword(password);
                }
                else
                {
                    this._panels.SelectInputFiles.SetInitialState(this._session.Settings, password);
                    this._inputPanelInitialized = true;
                }
            }
            else if (panel == this._panels.SelectOperatingModes)
            {
            }
            else if (panel == this._panels.ConfigureModelOutput)
            {
            }
            else if (panel == this._panels.EnterOutputPassword)
            {
                if (!this._panels.ConfigureModelOutput.EnterOutputPassword)
                {
                    if (skipForward)
                    {
                        this.NextLabelButton_Click(this, EventArgs.Empty);
                    }
                    else
                    {
                        this.PreviousLabelButton_Click(this, EventArgs.Empty);
                    }
                }
            }
            else if (panel == this._panels.SelectReports)
            {
            }
            else if (panel == this._panels.SelectOutputPaths)
            {
            }
            else if (panel == this._panels.Complete)
            {
            }
        }
        #endregion
        #region 
        [Browsable(false)]
        public Session2d Session
        {
            get
            {
                return this._session;
            }
        }
        [Browsable(false)]
        public bool SaveSession
        {
            get
            {
                return this._saveSession;
            }
        }
        #endregion
        #region 
        #region 
        private TreeView ux_navigationTreeView;
        private Panel ux_settingsPanel;
        private Panel ux_toolbarPanel;
        private LabelButton ux_saveLabelButton;
        private LabelButton ux_previousLabelButton;
        private LabelButton ux_nextLabelButton;
        private LabelButton ux_closeLabelButton;
        private Label ux_statusLabel;
        private System.ComponentModel.Container components = null;
        #endregion
        Session2d _session;
        bool _saveSession;
        int _currentIndex;
        TreeNode[] _nodes;
        NewSessionWizard.NSW_WizardPanels _panels;
        bool[]                            _visiblePanels;
        bool _inputPanelInitialized;
        bool _inputPanelSaveComplete;
        bool _cancelTreeNodeSelect;
        bool _cancelTreeNodeExpandOrCollapse;
        string[] _filesToParse;
        int _minYear;
        int _maxYear;
        #endregion
    }
}

