using System;
using Volpe.Cafe;
using Volpe.Cafe.Collections;
namespace Volpe.Cafe.Data
{
    [Serializable]
    public abstract class Component
    {
        #region 
        protected Component()
        {
            this._valid       = false;
            this._initialized = false;
            this._vehicles          = new VehicleCollection();
            this._modelYearVehicles = new VehicleCollection();
            this._manufacturer      = null;
            this._parent            = null;
        }
        #endregion
        #region 
        protected void CopyTo(Component value)
        {
            value._initialized    = this._initialized;
            value._valid          = this._valid;
            value._invalidReasons = (string[])Global.CloneArray(this._invalidReasons, typeof(string));
            value._modelingData   = this._modelingData.Clone();
            if (this._vehicles          != null) { value._vehicles          = new VehicleCollection(this._vehicles); }
            if (this._modelYearVehicles != null) { value._modelYearVehicles = new VehicleCollection(this._modelYearVehicles); }
            value._manufacturer   = this._manufacturer;
            value._parent         = this._parent;
        }
        internal virtual void Initialize(Manufacturer manufacturer)
        {
            this._manufacturer = manufacturer;
            this._parent = null;
            this._vehicles = new VehicleCollection(32);
            this._modelYearVehicles = new VehicleCollection(32);
            this._initialized = true;
        }
        internal void SetModelingData(ComponentModelingData value)
        {
            this._modelingData = value;
        }
        public void InitializeModelYearVehicles(ModelYear modelYear)
        {
            this._modelYearVehicles = this._vehicles.GetModelYearVehicles(modelYear);
        }
        protected void SplitTo(VehicleCollection vehicles, Component value)
        {
            this._vehicles.RemoveRange(vehicles);
            this._modelYearVehicles.RemoveRange(vehicles);
            value._vehicles.RemoveRange(this._vehicles);
            value._modelYearVehicles.RemoveRange(this._modelYearVehicles);
            value._parent = this;
        }
        #endregion
        #region 
        public bool Initialized
        {
            get { return this._initialized; }
        }
        public bool Valid
        {
            get { return this._valid; }
        }
        public string[] InvalidReasons
        {
            get { return this._invalidReasons; }
        }
        public ComponentModelingData ModelingData
        {
            get { return this._modelingData; }
        }
        public VehicleCollection Vehicles
        {
            get { return this._vehicles; }
        }
        public VehicleCollection ModelYearVehicles
        {
            get { return this._modelYearVehicles; }
        }
        public Manufacturer Manufacturer
        {
            get { return this._manufacturer; }
        }
        #endregion
        #region 
        protected bool _initialized;
        protected bool _valid;
        protected string[] _invalidReasons;
        protected ComponentModelingData _modelingData;
        protected VehicleCollection _vehicles;
        protected VehicleCollection _modelYearVehicles;
        protected Manufacturer _manufacturer;
        protected Component _parent;        
        #endregion
    }
}

