using System;
namespace Volpe.Cafe.Data.Optimization
{
    [Serializable]
    public struct IterationsData
    {
        #region 
        public void Clear()
        {
            this.Iterations = new IterationData[this.Iterations.Length];
            this.Intersections = null;
            this.PosAve = this.NegAve = 0;
            this.Optimized = 0;
        }
        public double GetStandard()
        {
            return (this.Optimized < 0) ? double.NaN : this.Iterations[this.Optimized].Standard;
        }
        public double[] GetCoefficients()
        {
            return (this.Optimized < 0) ? null : this.Iterations[this.Optimized].Coefficients;
        }
        public void SetOptimizedIndexFromStnd(double standard)
        {
            int i = 0, count = this.Iterations.Length;
            for (; i < count; i++)
            {
                if      (!this.Iterations[i].Valid              ) { i--; break; }    
                else if (this.Iterations[i].Standard >= standard) {      break; }    
            }
            if (i == count) { i = count - 1; }
            this.Optimized = i;
        }
        public void SetOptimizedIndexFromCoefs(double a, double b)
        {
            int i = 0, count = this.Iterations.Length;
            for (; i < count; i++)
            {
                if      (!this.Iterations[i].Valid              ) { i--; break; }    
                else if (this.Iterations[i].Coefficients[0] >= a &&
                         this.Iterations[i].Coefficients[1] >= b) {      break; }    
            }
            if (i == count) { i = count - 1; }
            this.Optimized = i;
        }
        public void SetOptimizedIndexFromCosts(double costs)
        {
            int optIdx = this.Optimized;
            int newOpt = optIdx;
            double dCosts = costs;  
            for (int i = 0, count = this.Iterations.Length; i < count; i++)
            {
                if (this.Iterations[i].Valid)
                {   
                    double iDCosts = Math.Abs(costs - this.Iterations[i].TechCost);
                    if (i <= optIdx)
                    {   
                        if (iDCosts <= dCosts) { newOpt = i; dCosts = iDCosts; }
                    }
                    else
                    {   
                        if (iDCosts < dCosts) { newOpt = i; dCosts = iDCosts; }
                    }
                } 
            }
            this.Optimized = newOpt;
        }
        #endregion
        #region 
        public IterationData[] Iterations;
        public int[] Intersections;
        public double PosAve;
        public double NegAve;
        public int Optimized;
        #endregion
    }
}

