using System;
namespace Volpe.Cafe.Data
{
    internal class RCToString
    {
        #region 
        static RCToString()
        {
            DBuf = new char[10]; DStr.CopyTo(0, DBuf, 0, 10);
            IBuf = new char[11]; IStr.CopyTo(0, IBuf, 0, 11);
            LBuf = new char[14]; LStr.CopyTo(0, LBuf, 0, 14);
            UBuf = new char[14]; UStr.CopyTo(0, UBuf, 0, 14);
        }
        #endregion
        #region 
        public static string ToString(ref RCDouble value)
        {
            string d = value.DomesticAuto.ToString();
            string i = value.ImportedAuto.ToString();
            string l = value.LightTruck  .ToString();
            string u = value.Unregulated .ToString();
            int size = 50 + d.Length + i.Length + l.Length + u.Length;
            char[] buf = new char[size];
            int bufLen = 0;
            BuildBuf(buf, ref bufLen, DBuf);
            BuildBuf(buf, ref bufLen, d);
            BuildBuf(buf, ref bufLen, IBuf);
            BuildBuf(buf, ref bufLen, i);
            BuildBuf(buf, ref bufLen, LBuf);
            BuildBuf(buf, ref bufLen, l);
            BuildBuf(buf, ref bufLen, UBuf);
            BuildBuf(buf, ref bufLen, u);
            buf[bufLen++] = EndChar;
            return new string(buf, 0, bufLen);
        }
        static void BuildBuf(char[] buf, ref int bufLen, string value)
        {
            value.CopyTo(0, buf, bufLen, value.Length);
            bufLen += value.Length;
        }
        static void BuildBuf(char[] buf, ref int bufLen, char[] value)
        {
            value.CopyTo(buf, bufLen);
            bufLen += value.Length;
        }
        static void BuildBuf(char[] buf, ref int bufLen, char value)
        {
            buf[bufLen++] = value;
        }
        #endregion
        #region 
        internal const  string DStr = "{Dom Auto=";
        internal const  string IStr = ", Imp Auto=";
        internal const  string LStr = ", Light Truck=";
        internal const  string UStr = ", Unregulated=";
        internal static char[] DBuf;
        internal static char[] IBuf;
        internal static char[] LBuf;
        internal static char[] UBuf;
        internal const  char   EndChar = '}' ;
        #endregion
    }
}

