using System;
using Volpe.Cafe.IO;
namespace Volpe.Cafe
{
    [Serializable]
    public struct MonteCarloSettings : ICloneable
    {
        #region 
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        public MonteCarloSettings Clone()
        {
            MonteCarloSettings mcs = new MonteCarloSettings();
            mcs.TrialPairs         = this.TrialPairs;
            mcs.UseTrialsFile      = this.UseTrialsFile;
            mcs.TrialsFile         = this.TrialsFile;
            return mcs;
        }
        #endregion
        internal void WriteSummaryLog(LogWriter writer)
        {
            if (writer.Summary == null) { return; }
            string outStr = "--- Monte-Carlo Settings ---" +
                ((this.UseTrialsFile) ? "\r\n  Using TrialsFile=" + this.TrialsFile : "\r\n  TrialPairs=" + this.TrialPairs);
            writer.Summary.WriteLine(outStr + "\r\n");
        }
        #endregion
        #region 
        public int TrialPairs;
        public bool UseTrialsFile;
        public string TrialsFile;
        #endregion
    }
}

