using System;
using System.Runtime.Serialization;
using Volpe.Cafe.IO;
namespace Volpe.Cafe
{
    [Serializable]
    public struct OutputSettings : ISerializable
    {
        #region 
        public OutputSettings(string outputPath)
        {
            this.OutputPath                              = outputPath;
            this.GenerateReports                         = false;
            this.GenerateIndustryReport                  = false;
            this.GenerateManufacturersReport             = false;
            this.GenerateVehiclesReport                  = false;
            this.GenerateEffectsReport                   = false;
            this.GenerateEnvironmentalAssessmentReport   = false;
            this.GenerateScenarioSummaryReport           = false;
            this.GenerateOptimizedIndustryReportExtended = false;
        }
        private OutputSettings(SerializationInfo info, StreamingContext context)
        {
            this.OutputPath                              = info.GetString ("OutputPath"                             );
            this.GenerateReports                         = info.GetBoolean("GenerateReports"                        );
            this.GenerateIndustryReport                  = info.GetBoolean("GenerateIndustryReport"                 );
            this.GenerateManufacturersReport             = info.GetBoolean("GenerateManufacturersReport"            );
            this.GenerateVehiclesReport                  = info.GetBoolean("GenerateVehiclesReport"                 );
            this.GenerateEffectsReport                   = info.GetBoolean("GenerateEffectsReport"                  );
            this.GenerateEnvironmentalAssessmentReport   = info.GetBoolean("GenerateEnvironmentalAssessmentReport"  );
            this.GenerateScenarioSummaryReport           = info.GetBoolean("GenerateScenarioSummaryReport"          );
            this.GenerateOptimizedIndustryReportExtended = info.GetBoolean("GenerateOptimizedIndustryReportExtended");
        }
        #endregion
        #region 
        #region 
        public void GetObjectData(SerializationInfo info, StreamingContext context)
        {
            info.AddValue("OutputPath"                             , this.OutputPath                             );
            info.AddValue("GenerateReports"                        , this.GenerateReports                        );
            info.AddValue("GenerateIndustryReport"                 , this.GenerateIndustryReport                 );
            info.AddValue("GenerateManufacturersReport"            , this.GenerateManufacturersReport            );
            info.AddValue("GenerateVehiclesReport"                 , this.GenerateVehiclesReport                 );
            info.AddValue("GenerateEffectsReport"                  , this.GenerateEffectsReport                  );
            info.AddValue("GenerateEnvironmentalAssessmentReport"  , this.GenerateEnvironmentalAssessmentReport  );
            info.AddValue("GenerateScenarioSummaryReport"          , this.GenerateScenarioSummaryReport          );
            info.AddValue("GenerateOptimizedIndustryReportExtended", this.GenerateOptimizedIndustryReportExtended);
        }
        #endregion
        internal void WriteSummaryLog(LogWriter writer)
        {
            if (writer.Summary == null) { return; }
            string outStr = "--- Output Settings ---\r\n  Output Path=" + this.OutputPath;
            if (this.GenerateIndustryReport)                  { outStr += "\r\n  Generate Industry Report";      }
            if (this.GenerateManufacturersReport)             { outStr += "\r\n  Generate Manufacturers Report"; }
            if (this.GenerateVehiclesReport)                  { outStr += "\r\n  Generate Vehicles Report";      }
            if (this.GenerateEffectsReport)                   { outStr += "\r\n  Generate Effects Report";       }
            if (this.GenerateEnvironmentalAssessmentReport)   { outStr += "\r\n  Generate Environmental Assessment Report"; }
            if (this.GenerateScenarioSummaryReport)           { outStr += "\r\n  Generate Scenario Summary Report"; }
            if (this.GenerateOptimizedIndustryReportExtended) { outStr += "\r\n  Generate Optimized Industry Report, Extended"; }
            writer.Summary.WriteLine(outStr + "\r\n");
        }
        #endregion
        #region 
        public string OutputPath;
        public bool GenerateReports;
        public bool GenerateIndustryReport;
        public bool GenerateManufacturersReport;
        public bool GenerateVehiclesReport;
        public bool GenerateScenarioSummaryReport;
        public bool GenerateEffectsReport;
        public bool GenerateEnvironmentalAssessmentReport;
        public bool GenerateOptimizedIndustryReportExtended;
        #endregion
    }
}

