using System;
namespace Volpe.Utils
{
    [Serializable]
    public struct XlCryptoSettings
    {
        #region 
        public bool IsEmpty { get { return this._isEmpty; } }
        public static XlCryptoSettings Empty
        {
            get
            {
                XlCryptoSettings crypto = new XlCryptoSettings();
                crypto._isEmpty = true;
                return crypto;
            }
        }
        public static XlCryptoSettings OfficeXor
        {
            get
            {
                XlCryptoSettings crypto = new XlCryptoSettings();
                crypto.EncryptionProvider = "";
                crypto.EncryptionAlgorithm = "OfficeXor";
                crypto.EncryptionKeyLength = -1;
                crypto.EncryptDocumentProperties = false;
                crypto._isEmpty = false;
                return crypto;
            }
        }
        public static XlCryptoSettings OfficeStandard
        {
            get
            {
                XlCryptoSettings crypto = new XlCryptoSettings();
                crypto.EncryptionProvider = "";
                crypto.EncryptionAlgorithm = "OfficeStandard";
                crypto.EncryptionKeyLength = 40;
                crypto.EncryptDocumentProperties = false;
                crypto._isEmpty = false;
                return crypto;
            }
        }
        #endregion
        #region 
        public string EncryptionProvider;
        public string EncryptionAlgorithm;
        public int EncryptionKeyLength;
        public bool EncryptDocumentProperties;
        private bool _isEmpty;
        #endregion
    }
}

