using System;
namespace Volpe.Utils
{
    [Serializable]
    public class XlSeriesFormat
    {
        #region 
        public XlSeriesFormat()
            : this(null)
        {
        }
        public XlSeriesFormat(string name)
            : this(name, (XlRange)null, (XlRange)null)
        {
        }
        public XlSeriesFormat(string name, XlRange values, XlRange xValues)
            : this(name, values, xValues, null, null, true, false, false, null, XlColor.Automatic, XlColor.Automatic, false,
                XlColor.Automatic, XlColor.Automatic, -1, false)
        {
        }
        public XlSeriesFormat(string name, object values, object xValues)
            : this(name, null, null, values, xValues, true, false, false, null, XlColor.Automatic, XlColor.Automatic, false,
                XlColor.Automatic, XlColor.Automatic, -1, false)
        {
        }
        public XlSeriesFormat(string name, XlRange values, XlRange xValues, object custValues, object custXValues,
            bool solidLine, bool thickLine, bool hasDataLabels, XlDataLabelsFormat dataLabels, XlColor color,
            XlColor patternColor, bool invertIfNeg, XlColor markerForeColor, XlColor markerBackColor, int markerSize, bool shadow)
        {
            this._name             = name;
            this._values           = values;
            this._xValues          = xValues;
            this._customValues     = custValues;
            this._customXValues    = custXValues;
            this._solidLine        = solidLine;
            this._thickLine        = thickLine;
            this._color            = color;
            this._patternColor     = patternColor;
            this._invertIfNegative = invertIfNeg;
            this._hasDataLabels    = hasDataLabels;
            this._dataLabels       = dataLabels;
            this._markerForeColor  = markerForeColor;
            this._markerBackColor  = markerBackColor;
            this._markerSize       = markerSize;
            this._shadow           = shadow;
        }
        #endregion
        #region 
        public override string ToString()
        {
            return "{IsValid="        + this.IsValid +
                ", Name="             + this._name +
                ", Values="           + this._values +
                ", XValues="          + this._xValues +
                ", UseCustomValues="  + this.UseCustomValues +
                ", CustomValues="     + this.CustomValuesString +
                ", CustomXValues="    + this.CustomXValuesString +
                ", SolidLine="        + this._solidLine +
                ", ThickLine="        + this._thickLine +
                ", Color="            + this._color +
                ", PatternColor="     + this._patternColor +
                ", InvertIfNegative=" + this._invertIfNegative +
                ", HasDataLabels="    + this._hasDataLabels +
                ", DataLabels="       + this._dataLabels +
                ", MarkerForeColor="  + this._markerForeColor +
                ", MarkerBackColor="  + this._markerBackColor +
                ", MarkerSize="       + this._markerSize +
                ", Shadow="           + this._shadow + "}";
        }
        private string ConvertCustomValues(object values)
        {
            if (values == null) { return null; }
            if (values is object[])
            {
                object[] valuesArr = (object[])values;
                string str = "{";
                for (int i = 0, count = valuesArr.Length; i < count; i++)
                {
                    str += valuesArr[i].ToString() + ",";
                }
                return str.TrimEnd(',') + "}";
            }
            else { return values.ToString(); }
        }
        #endregion
        #region 
        public bool IsValid
        {
            get
            {
                return (this._name != null) || !((this._values == null || this._xValues == null) &&
                    (this._customValues == null || this._customXValues == null));
            }
        }
        public string Name
        {
            get { return this._name; }
            set { this._name = value; }
        }
        public XlRange Values
        {
            get { return this._values; }
            set { this._values = value; }
        }
        public XlRange XValues
        {
            get { return this._xValues; }
            set { this._xValues = value; }
        }
        public object CustomValues
        {
            get { return this._customValues; }
            set { this._customValues = value; }
        }
        public object CustomXValues
        {
            get { return this._customXValues; }
            set { this._customXValues = value; }
        }
        public string CustomValuesString  { get { return this.ConvertCustomValues(this._customValues); } }
        public string CustomXValuesString { get { return this.ConvertCustomValues(this._customXValues); } }
        public bool UseCustomValues       { get { return this._customValues != null && this._customXValues != null; } }
        public bool SolidLine
        {
            get { return this._solidLine; }
            set { this._solidLine = value; }
        }
        public bool ThickLine
        {
            get { return this._thickLine; }
            set { this._thickLine = value; }
        }
        public XlColor Color
        {
            get { return this._color; }
            set { this._color = value; }
        }
        public XlColor PatternColor
        {
            get { return this._patternColor; }
            set { this._patternColor = value; }
        }
        public bool InvertIfNegative
        {
            get { return this._invertIfNegative; }
            set { this._invertIfNegative = value; }
        }
        public bool HasDataLabels
        {
            get { return this._hasDataLabels; }
            set { this._hasDataLabels = value; }
        }
        public XlDataLabelsFormat DataLabels
        {
            get { return this._dataLabels; }
            set { this._dataLabels = value; }
        }
        public XlColor MarkerForeColor
        {
            get { return this._markerForeColor; }
            set { this._markerForeColor = value; }
        }
        public XlColor MarkerBackColor
        {
            get { return this._markerBackColor; }
            set { this._markerBackColor = value; }
        }
        public int MarkerSize
        {
            get { return this._markerSize; }
            set { this._markerSize = value; }
        }
        public bool Shadow
        {
            get { return this._shadow; }
            set { this._shadow = value; }
        }
        #endregion
        #region 
        private string _name;
        private XlRange _values;
        private XlRange _xValues;
        private object _customValues;
        private object _customXValues;
        private bool _solidLine;
        private bool _thickLine;
        private XlColor _color;
        private XlColor _patternColor;
        private bool _invertIfNegative;
        private bool _hasDataLabels;
        private XlDataLabelsFormat _dataLabels;
        private XlColor _markerForeColor;
        private XlColor _markerBackColor;
        private int _markerSize;
        private bool _shadow;
        #endregion
    }
}

