using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
namespace Volpe.Cafe.Ui
{
    public class Customize : System.Windows.Forms.Form
    {
        #region 
        private struct ControlSet
        {
            public void Reset()
            {
                this.NameButton = null;
                this.DescriptionTextBox = null;
                this.ImageSetPanel = null;
                this.Alternatives = null;
            }
            public RadioButton NameButton;
            public TextBox DescriptionTextBox;
            public Panel ImageSetPanel;
            public RadioButton[] Alternatives;
        }
        #endregion
        #region 
        public Customize(bool showFileMenu, bool showStandardToolbar)
        {
            this.InitializeComponent();
            this.ux_showFileMenuCheckBox.Checked = showFileMenu;
            this.ux_showStandardToolbarCheckBox.Checked = showStandardToolbar;
            this._themeControls = new ArrayList();
        }
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }
        #endregion
        #region 
        #region 
        private void InitializeComponent()
        {
            this.ux_generalGroupBox = new System.Windows.Forms.GroupBox();
            this.ux_showStandardToolbarCheckBox = new System.Windows.Forms.CheckBox();
            this.ux_showFileMenuCheckBox = new System.Windows.Forms.CheckBox();
            this.ux_themesGroupBox = new System.Windows.Forms.GroupBox();
            this.ux_themesPanel = new System.Windows.Forms.Panel();
            this.ux_saveLabelButton = new Volpe.Cafe.Ui.LabelButton();
            this.ux_closeLabelButton = new Volpe.Cafe.Ui.LabelButton();
            this.ux_generalGroupBox.SuspendLayout();
            this.ux_themesGroupBox.SuspendLayout();
            this.SuspendLayout();
            this.ux_generalGroupBox.Controls.Add(this.ux_showStandardToolbarCheckBox);
            this.ux_generalGroupBox.Controls.Add(this.ux_showFileMenuCheckBox);
            this.ux_generalGroupBox.Location = new System.Drawing.Point(8, 8);
            this.ux_generalGroupBox.Name = "ux_generalGroupBox";
            this.ux_generalGroupBox.Size = new System.Drawing.Size(336, 72);
            this.ux_generalGroupBox.TabIndex = 0;
            this.ux_generalGroupBox.TabStop = false;
            this.ux_generalGroupBox.Text = "General";
            this.ux_showStandardToolbarCheckBox.Location = new System.Drawing.Point(16, 48);
            this.ux_showStandardToolbarCheckBox.Name = "ux_showStandardToolbarCheckBox";
            this.ux_showStandardToolbarCheckBox.Size = new System.Drawing.Size(144, 16);
            this.ux_showStandardToolbarCheckBox.TabIndex = 1;
            this.ux_showStandardToolbarCheckBox.Text = "Show standard toolbar.";
            this.ux_showFileMenuCheckBox.Enabled = false;
            this.ux_showFileMenuCheckBox.Location = new System.Drawing.Point(16, 24);
            this.ux_showFileMenuCheckBox.Name = "ux_showFileMenuCheckBox";
            this.ux_showFileMenuCheckBox.Size = new System.Drawing.Size(112, 16);
            this.ux_showFileMenuCheckBox.TabIndex = 0;
            this.ux_showFileMenuCheckBox.Text = "Show file menu.";
            this.ux_themesGroupBox.Controls.Add(this.ux_themesPanel);
            this.ux_themesGroupBox.Location = new System.Drawing.Point(8, 88);
            this.ux_themesGroupBox.Name = "ux_themesGroupBox";
            this.ux_themesGroupBox.Size = new System.Drawing.Size(336, 192);
            this.ux_themesGroupBox.TabIndex = 1;
            this.ux_themesGroupBox.TabStop = false;
            this.ux_themesGroupBox.Text = "Themes";
            this.ux_themesPanel.AutoScroll = true;
            this.ux_themesPanel.Dock = System.Windows.Forms.DockStyle.Fill;
            this.ux_themesPanel.Location = new System.Drawing.Point(3, 17);
            this.ux_themesPanel.Name = "ux_themesPanel";
            this.ux_themesPanel.Size = new System.Drawing.Size(330, 172);
            this.ux_themesPanel.TabIndex = 0;
            this.ux_saveLabelButton.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_saveLabelButton.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_saveLabelButton.Location = new System.Drawing.Point(264, 290);
            this.ux_saveLabelButton.Name = "ux_saveLabelButton";
            this.ux_saveLabelButton.Size = new System.Drawing.Size(32, 32);
            this.ux_saveLabelButton.TabIndex = 2;
            this.ux_saveLabelButton.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.ux_saveLabelButton.Click += new System.EventHandler(this.ux_saveLabel_Click);
            this.ux_closeLabelButton.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_closeLabelButton.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_closeLabelButton.Location = new System.Drawing.Point(304, 290);
            this.ux_closeLabelButton.Name = "ux_closeLabelButton";
            this.ux_closeLabelButton.Size = new System.Drawing.Size(32, 32);
            this.ux_closeLabelButton.TabIndex = 3;
            this.ux_closeLabelButton.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.ux_closeLabelButton.Click += new System.EventHandler(this.ux_closeLabel_Click);
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 14);
            this.ClientSize = new System.Drawing.Size(354, 335);
            this.Controls.Add(this.ux_closeLabelButton);
            this.Controls.Add(this.ux_saveLabelButton);
            this.Controls.Add(this.ux_themesGroupBox);
            this.Controls.Add(this.ux_generalGroupBox);
            this.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
            this.HelpButton = true;
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.Name = "Customize";
            this.ShowInTaskbar = false;
            this.Text = "Customize";
            this.Load += new System.EventHandler(this.Customize_Load);
            this.ux_generalGroupBox.ResumeLayout(false);
            this.ux_themesGroupBox.ResumeLayout(false);
            this.ResumeLayout(false);
        }
        #endregion
        private void Customize_Load(object sender, System.EventArgs e)
        {
            this.Font = Cafe2d.DefaultFont;
            this.ux_saveLabelButton.ThemeInitialize("ok", true);
            this.ux_closeLabelButton.ThemeInitialize("cancel", true);
            this.LoadThemes();
            this.SelectTheme(Cafe2d.Themes.SelectedThemeIndex, Cafe2d.Themes.ThemeAlternative);
        }
        private void LoadThemes()
        {
            Theme[] list = Cafe2d.Themes.List;
            int yOffset = 0;
            for (int i = 0; i < list.Length; i++)
            {
                int width = this.ux_themesPanel.Width - 34;
                Theme theme = list[i];
                int alts = theme.Alternatives;
                ControlSet controls = new ControlSet();
                controls.Reset();
                controls.Alternatives = new RadioButton[alts];
                RadioButton btn = new RadioButton();
                btn.Text = theme.Name;
                btn.Size = new Size(width, 16);
                btn.Location = new Point(16, yOffset + 8);
                btn.Tag = i.ToString();
                btn.CheckedChanged += new EventHandler(this.ThemeButton_CheckedChanged);
                TextBox descr = new TextBox();
                descr.BorderStyle = BorderStyle.None;
                descr.Multiline = true;
                descr.ReadOnly = true;
                descr.TabStop = false;
                descr.Text = theme.Description;
                descr.Size = new Size(width, (theme.Description.Length > 60) ? 32 : 16);
                descr.Location = new Point(16, yOffset + 24);
                descr.Enabled = false;
                Panel images = new Panel();
                images.Size = new Size(width, alts * 24);
                images.Location = new Point(16, yOffset + 40 +
                    ((theme.Description.Length > 60) ? 16 : 0));
                images.Enabled = false;
                for (int j = 0; j < alts; j++)
                {
                    RadioButton setOpt = new RadioButton();
                    setOpt.Text = "";
                    setOpt.Size = new Size(16, 16);
                    setOpt.Location = new Point(8, 0 + 24 * j);
                    setOpt.Tag = j.ToString();
                    setOpt.Checked = (j == 0);
                    setOpt.CheckedChanged += new EventHandler(this.ThemeAlternativesButton_CheckedChanged);
                    controls.Alternatives[j] = setOpt;
                    PictureBox[] setImages = new PictureBox[9];
                    setImages[0] = new PictureBox();
                    setImages[0].Size = new Size(24, 24);
                    setImages[0].Location = new Point(24, 0 + 24 * j);
                    setImages[0].Image = (theme.Scaling) ? theme.X22[j].GetImage(0) : theme.BaseSmall[j].GetImage(0);
                    setImages[1] = new PictureBox();
                    setImages[1].Size = new Size(24, 24);
                    setImages[1].Location = new Point(48, 0 + 24 * j);
                    setImages[1].Image = (theme.Scaling) ? theme.X22[j].GetImage(1) : theme.AltSmall[j].GetImage(1);
                    setImages[2] = new PictureBox();
                    setImages[2].Size = new Size(24, 24);
                    setImages[2].Location = new Point(72, 0 + 24 * j);
                    setImages[2].Image = (theme.Scaling) ? theme.X22[j].GetImage(2) : theme.BaseSmall[j].GetImage(2);
                    setImages[3] = new PictureBox();
                    setImages[3].Size = new Size(24, 24);
                    setImages[3].Location = new Point(96, 0 + 24 * j);
                    setImages[3].Image = (theme.Scaling) ? theme.X22[j].GetImage(3) : theme.AltSmall[j].GetImage(3);
                    setImages[4] = new PictureBox();
                    setImages[4].Size = new Size(24, 24);
                    setImages[4].Location = new Point(120, 0 + 24 * j);
                    setImages[4].Image = (theme.Scaling) ? theme.X22[j].GetImage(4) : theme.BaseSmall[j].GetImage(4);
                    setImages[5] = new PictureBox();
                    setImages[5].Size = new Size(24, 24);
                    setImages[5].Location = new Point(144, 0 + 24 * j);
                    setImages[5].Image = (theme.Scaling) ? theme.X22[j].GetImage(5) : theme.AltSmall[j].GetImage(5);
                    setImages[6] = new PictureBox();
                    setImages[6].Size = new Size(24, 24);
                    setImages[6].Location = new Point(168, 0 + 24 * j);
                    setImages[6].Image = (theme.Scaling) ? theme.X22[j].GetImage(6) : theme.BaseSmall[j].GetImage(6);
                    setImages[7] = new PictureBox();
                    setImages[7].Size = new Size(24, 24);
                    setImages[7].Location = new Point(192, 0 + 24 * j);
                    setImages[7].Image = (theme.Scaling) ? theme.X22[j].GetImage(7) : theme.AltSmall[j].GetImage(7);
                    setImages[8] = new PictureBox();
                    setImages[8].Size = new Size(24, 24);
                    setImages[8].Location = new Point(216, 0 + 24 * j);
                    setImages[8].Image = (theme.Scaling) ? theme.X22[j].GetImage(8) : theme.BaseSmall[j].GetImage(8);
                    images.Controls.Add(setOpt);
                    images.Controls.AddRange(setImages);
                }
                controls.NameButton = btn;
                controls.DescriptionTextBox = descr;
                controls.ImageSetPanel = images;
                this._themeControls.Add(controls);
                this.ux_themesPanel.Controls.Add(btn);
                this.ux_themesPanel.Controls.Add(descr);
                this.ux_themesPanel.Controls.Add(images);
                yOffset  = images.Height + images.Top;
            }
        }
        private void ThemeAlternativesButton_CheckedChanged(object sender, EventArgs e)
        {
            RadioButton btn = (RadioButton)sender;
            if (btn.Checked)
            {
                this._altIndex = int.Parse(btn.Tag.ToString());
            }
        }
        private void ThemeButton_CheckedChanged(object sender, EventArgs e)
        {
            RadioButton btn = (RadioButton)sender;
            int index = int.Parse(btn.Tag.ToString());
            if (btn.Checked)
            {
                this.SelectTheme(index, -1);
            }
            else
            {
                this.DeselectTheme(index);
            }
        }
        private void SelectTheme(int index, int alternative)
        {
            ControlSet controls = (ControlSet)this._themeControls[index];
            controls.NameButton.Checked = true;
            controls.DescriptionTextBox.Enabled = true;
            controls.ImageSetPanel.Enabled = true;
            this._themeIndex = index;
            if (alternative == -1)
            {
                for (int i = 0; i < controls.Alternatives.Length; i++)
                {
                    if (controls.Alternatives[i].Checked)
                    {
                        this._altIndex = i;
                        break;
                    }
                }
            }
            else
            {
                this._altIndex = alternative;
                controls.Alternatives[alternative].Checked = true;
            }
        }
        private void DeselectTheme(int index)
        {
            ControlSet controls = (ControlSet)this._themeControls[index];
            controls.NameButton.Checked = false;
            controls.DescriptionTextBox.Enabled = false;
            controls.ImageSetPanel.Enabled = false;
        }
        private void ux_saveLabel_Click(object sender, System.EventArgs e)
        {
            Cafe2d.Themes.SelectedThemeIndex = this._themeIndex;
            Cafe2d.Themes.ThemeAlternative = this._altIndex;
            this.DialogResult = DialogResult.OK;
        }
        private void ux_closeLabel_Click(object sender, System.EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }
        #endregion
        #region 
        public bool ShowFileMenu
        {
            get
            {
                return this.ux_showFileMenuCheckBox.Checked;
            }
        }
        public bool ShowStandardToolbar
        {
            get
            {
                return this.ux_showStandardToolbarCheckBox.Checked;
            }
        }
        #endregion
        #region 
        #region 
        private System.Windows.Forms.CheckBox ux_showStandardToolbarCheckBox;
        private System.Windows.Forms.CheckBox ux_showFileMenuCheckBox;
        private System.Windows.Forms.Panel ux_themesPanel;
        private System.Windows.Forms.GroupBox ux_generalGroupBox;
        private System.Windows.Forms.GroupBox ux_themesGroupBox;
        private LabelButton ux_saveLabelButton;
        private LabelButton ux_closeLabelButton;
        private System.ComponentModel.Container components = null;
        #endregion
        private ArrayList _themeControls;
        private int _themeIndex;
        private int _altIndex;
        #endregion
    }
}

