using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using Volpe.Cafe.Data;
using Volpe.Cafe.Model;
using Volpe.Cafe.Model.MonteCarlo;
using Volpe.Cafe.Model.Optimization;
using Volpe.Cafe.Ui.Panels;
namespace Volpe.Cafe.Ui
{
    public class ManageModelingSettings : Form
    {
        #region 
        public ManageModelingSettings(Session2d session)
        {
            this.InitializeComponent();
            this.InitializeNavigationTreeView();
            this._session = session;
            this._inputPanelInitialized = false;
            Industry data = session.Data;
            if (data == null)
            {
                this._minYear = DateTime.Now.Year;
                this._maxYear = this._minYear + 25;
            }
            else
            {
                this._minYear = data.MinYear.Year;
                this._maxYear = data.MaxYear.Year;
            }
        }
        protected override void Dispose(bool disposing)
        {
            base.Dispose(disposing);
        }
        #endregion
        #region 
        #region 
        void InitializeComponent()
        {
            this.ux_navigationTreeView = new TreeView();
            this.ux_settingsPanel = new Panel();
            this.ux_panel = new Panel();
            this.ux_toolbarPanel = new Panel();
            this.ux_closeLabelButton = new Volpe.Cafe.Ui.LabelButton();
            this.ux_saveLabelButton = new Volpe.Cafe.Ui.LabelButton();
            this.ux_statusLabel = new Label();
            this.ux_panel.SuspendLayout();
            this.ux_toolbarPanel.SuspendLayout();
            this.SuspendLayout();
            this.ux_navigationTreeView.Dock = DockStyle.Left;
            this.ux_navigationTreeView.FullRowSelect = true;
            this.ux_navigationTreeView.HotTracking = true;
            this.ux_navigationTreeView.ImageIndex = -1;
            this.ux_navigationTreeView.Indent = 16;
            this.ux_navigationTreeView.Location = new Point(0, 0);
            this.ux_navigationTreeView.Name = "ux_navigationTreeView";
            this.ux_navigationTreeView.SelectedImageIndex = -1;
            this.ux_navigationTreeView.Size = new Size(144, 353);
            this.ux_navigationTreeView.TabIndex = 0;
            this.ux_navigationTreeView.AfterSelect += new TreeViewEventHandler(this.NavigationTreeView_AfterSelect);
            this.ux_settingsPanel.Dock = DockStyle.Fill;
            this.ux_settingsPanel.Location = new Point(0, 0);
            this.ux_settingsPanel.Name = "ux_settingsPanel";
            this.ux_settingsPanel.Size = new Size(418, 297);
            this.ux_settingsPanel.TabIndex = 0;
            this.ux_panel.Controls.Add(this.ux_settingsPanel);
            this.ux_panel.Controls.Add(this.ux_toolbarPanel);
            this.ux_panel.Dock = DockStyle.Fill;
            this.ux_panel.Location = new Point(144, 0);
            this.ux_panel.Name = "ux_panel";
            this.ux_panel.Size = new Size(418, 353);
            this.ux_panel.TabIndex = 1;
            this.ux_toolbarPanel.Controls.Add(this.ux_closeLabelButton);
            this.ux_toolbarPanel.Controls.Add(this.ux_saveLabelButton);
            this.ux_toolbarPanel.Controls.Add(this.ux_statusLabel);
            this.ux_toolbarPanel.Dock = DockStyle.Bottom;
            this.ux_toolbarPanel.Location = new Point(0, 297);
            this.ux_toolbarPanel.Name = "ux_toolbarPanel";
            this.ux_toolbarPanel.Size = new Size(418, 56);
            this.ux_toolbarPanel.TabIndex = 1;
            this.ux_closeLabelButton.BorderStyle = BorderStyle.FixedSingle;
            this.ux_closeLabelButton.Location = new Point(376, 8);
            this.ux_closeLabelButton.Name = "ux_closeLabelButton";
            this.ux_closeLabelButton.Size = new Size(32, 32);
            this.ux_closeLabelButton.TabIndex = 4;
            this.ux_closeLabelButton.TextAlign = ContentAlignment.MiddleCenter;
            this.ux_closeLabelButton.Click += new System.EventHandler(this.CloseLabelButton_Click);
            this.ux_saveLabelButton.BorderStyle = BorderStyle.FixedSingle;
            this.ux_saveLabelButton.Location = new Point(336, 8);
            this.ux_saveLabelButton.Name = "ux_saveLabelButton";
            this.ux_saveLabelButton.Size = new Size(32, 32);
            this.ux_saveLabelButton.TabIndex = 3;
            this.ux_saveLabelButton.TextAlign = ContentAlignment.MiddleCenter;
            this.ux_saveLabelButton.Click += new System.EventHandler(this.SaveLabelButton_Click);
            this.ux_statusLabel.Location = new Point(8, 8);
            this.ux_statusLabel.Name = "ux_statusLabel";
            this.ux_statusLabel.Size = new Size(320, 40);
            this.ux_statusLabel.TabIndex = 2;
            this.AutoScaleBaseSize = new Size(5, 14);
            this.ClientSize = new Size(562, 353);
            this.Controls.Add(this.ux_panel);
            this.Controls.Add(this.ux_navigationTreeView);
            this.Font = new Font("Tahoma", 8.25F, FontStyle.Regular, GraphicsUnit.Point, ((System.Byte)(0)));
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
            this.HelpButton = true;
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.Name = "ManageModelingSettings";
            this.ShowInTaskbar = false;
            this.Text = "Modeling Settings";
            this.Load += new System.EventHandler(this.ModelingSettings_Load);
            this.ux_panel.ResumeLayout(false);
            this.ux_toolbarPanel.ResumeLayout(false);
            this.ResumeLayout(false);
        }
        void InitializeNavigationTreeView()
        {
            this.ux_optimizationNode = new TreeNode("Optimization Settings");
            this.ux_monteCarloNode = new TreeNode("Monte-Carlo Settings");
            this.ux_navigationTreeView.Nodes.AddRange(
                new TreeNode[]
                {
                    new TreeNode("Compliance Settings",
                                 new TreeNode[]
                                 {
                                     new TreeNode("General")
                                 }),
                    new TreeNode("I/O Settings",
                                 new TreeNode[]
                                 {
                                     new TreeNode("Encryption Settings"),
                                     new TreeNode("Input Settings"),
                                     new TreeNode("Output Settings")
                                 }),
                    new TreeNode("Modeling Settings",
                                 new TreeNode[]
                                 {
                                     new TreeNode("Operating Modes"),
                                     this.ux_optimizationNode,
                                     this.ux_monteCarloNode
                                 })
                });
        }
        #endregion
        #region 
        private void ModelingSettings_Idle(object sender, System.EventArgs e)
        {
            GeneralCompliancePanel gcp = (GeneralCompliancePanel)this.ux_generalComlianceSettingsPanel.Controls[1];
            EncryptionPanel        ep  = (EncryptionPanel       )this.ux_encryptionSettingsPanel      .Controls[1];
            InputPanel             ip  = (InputPanel            )this.ux_inputSettingsPanel           .Controls[1];
            OutputPanel            op  = (OutputPanel           )this.ux_outputSettingsPanel          .Controls[1];
            OpModesPanel           omp = (OpModesPanel          )this.ux_operatingModesPanel          .Controls[1];
            OptimizationPanel      opp = (OptimizationPanel     )this.ux_optimizationSettingsPanel    .Controls[1];
            MonteCarloPanel        mcp = (MonteCarloPanel       )this.ux_monteCarloSettingsPanel      .Controls[1];
            ICompliance selCompliance = gcp.SelectedCompliance;
            if (selCompliance != null)
            {
                ip.ShowMarketData   = selCompliance.RequiresMarketData;
                ip.ShowTechnologies = selCompliance.RequiresTechnologies;
                ip.ShowParameters   = selCompliance.RequiresParameters;
                ip.ShowEmissions    = selCompliance.RequiresEmissions;
                ip.ShowScenarios    = selCompliance.RequiresScenarios;
            }
            bool isOpt    = (selCompliance == null) ? false : (selCompliance is Optimization);
            bool isMc     = (selCompliance == null) ? false : (selCompliance is MonteCarlo);
            int numChanged = 0;
            int numAttn = 0;
            int changedIndex = -1;      
            int attnIndex = -1;         
            string[] names = {"General Compliance Settings",
                "Encryption Settings", "Input Settings", "Output Settings",
                "Operating Modes", "Optimization Settings", "Monte-Carlo Settings"};
            bool[] changed = {gcp.SettingsChanged,
                ep.SettingsChanged, ip.SettingsChanged, op.SettingsChanged,
                omp.SettingsChanged, isOpt && opp.SettingsChanged, isMc && mcp.SettingsChanged};
            bool[] attn = {gcp.Messages.HasMessages,
                ep.Messages.HasMessages, ip.Messages.HasMessages, op.Messages.HasMessages,
                omp.Messages.HasMessages, isOpt && opp.Messages.HasMessages, isMc && mcp.Messages.HasMessages};
            for (int i = 0; i < changed.Length; i++)
            {
                if (changed[i]) { numChanged++; changedIndex = i; }
                if (attn   [i]) { numAttn   ++; attnIndex    = i; }
            }
            if (numAttn == 1)
            {
                this.ux_statusLabel.Text = "The " + names[attnIndex] + " Panel requires you attention.";
                this.ux_statusLabel.ForeColor = Color.Red;
            }
            else if (numAttn > 1)
            {
                this.ux_statusLabel.Text = "Some of the panels require you attention.";
                this.ux_statusLabel.ForeColor = Color.Red;
            }
            else if (numChanged == 1)
            {
                this.ux_statusLabel.Text = "Some of the settings on the " + names[changedIndex] + " Panel have not been saved.";
                this.ux_statusLabel.ForeColor = Color.Blue;
            }
            else if (numChanged > 1)
            {
                this.ux_statusLabel.Text = "Some of the settings have not been saved.";
                this.ux_statusLabel.ForeColor = Color.Blue;
            }
            else
            {
                this.ux_statusLabel.Text = "";
                this.ux_statusLabel.ForeColor = Color.Black;
            }
            this.ux_saveLabelButton.Enabled = (numChanged > 0); 
            TreeNodeCollection settingsNodes = this.ux_navigationTreeView.Nodes[2].Nodes;
            this.ux_modelingSettingsOptAndMcControls[0].Visible = isOpt;
            this.ux_modelingSettingsOptAndMcControls[1].Visible = isOpt;
            int optNodeIndex = settingsNodes.IndexOf(this.ux_optimizationNode);
            if      ( isOpt && optNodeIndex == -1) { settingsNodes.Add(this.ux_optimizationNode); }
            else if (!isOpt && optNodeIndex != -1) { settingsNodes.RemoveAt(optNodeIndex); }
            this.ux_modelingSettingsOptAndMcControls[2].Visible = isMc;
            this.ux_modelingSettingsOptAndMcControls[3].Visible = isMc;
            int mcNodeIndex = settingsNodes.IndexOf(this.ux_monteCarloNode);
            if      ( isMc && mcNodeIndex == -1) { settingsNodes.Add(this.ux_monteCarloNode); }
            else if (!isMc && mcNodeIndex != -1) { settingsNodes.RemoveAt(mcNodeIndex);       }
        }
        private void ModelingSettings_Load(object sender, System.EventArgs e)
        {
            this.Font = Cafe2d.DefaultFont;
            this.ux_saveLabelButton.ThemeInitialize("ok", true);
            this.ux_closeLabelButton.ThemeInitialize("cancel", true);
            this.DefaultPanelLocation = new Point(8, 24);
            this.DefaultPanelSize     = new Size (this.ux_settingsPanel.Width - 16, this.ux_settingsPanel.Height - 24);
            this.GenerateComplianceSettingsPanel();
            this.GenerateGeneralComplianceSettingsPanel();
            this.GenerateIOSettingsPanel();
            this.GenerateEncryptionSettingsPanel();
            this.GenerateInputSettingsPanel();
            this.GenerateOutputSettingsPanel();
            this.GenerateModelingSettingsPanel();
            this.GenerateOperatingModesPanel();
            this.GenerateOptimizationSettingsPanel();
            this.GenerateMonteCarloSettingsPanel();
            this.ux_navigationTreeView.ExpandAll();
            Application.Idle += new EventHandler(this.ModelingSettings_Idle);
            this.Closing += new System.ComponentModel.CancelEventHandler(this.ManageModelingSettings_Closing);
            InputPanel ip = (InputPanel)this.ux_inputSettingsPanel.Controls[1];
            ip.SetInitialState(this._session.Settings.InputSettings, this._session.Settings.EncryptionSettings.InputPassword);
            this._inputPanelInitialized = true;
        }
        private void ManageModelingSettings_Closing(object sender, CancelEventArgs e)
        {
            Application.Idle -= new EventHandler(this.ModelingSettings_Idle);
        }
        private void RootSettingsPanel_LinkClicked(object sender, EventArgs e)
        {
            this.ux_navigationTreeView.SelectedNode = (TreeNode)((LinkLabel)sender).Tag;
        }
        private void NavigationTreeView_AfterSelect(object sender, TreeViewEventArgs e)
        {
            if (!e.Node.IsExpanded)
            {
                e.Node.Expand();
            }
            this.ux_settingsPanel.Controls.Clear();
            this.ux_settingsPanel.Controls.Add(((Panel)e.Node.Tag));
            if (e.Node.Tag == this.ux_inputSettingsPanel)
            {
                if (!this._inputPanelInitialized)
                {
                    InputPanel ip = (InputPanel)this.ux_inputSettingsPanel.Controls[1];
                    ip.SetInitialState(this._session.Settings.InputSettings,
                        this._session.Settings.EncryptionSettings.InputPassword);
                    this._inputPanelInitialized = true;
                }
            }
        }
        private void InputPanel_InputStateChanged(object sender, bool enabled)
        {
            this.ux_navigationTreeView.Enabled = enabled;
            this.ux_toolbarPanel.Enabled = enabled;
            this.ControlBox = enabled;
        }
        private void InputPanel_FilesLoaded(object sender, EventArgs e)
        {
            InputPanel ip = (InputPanel)sender;
            if (ip.MarketData != null)
            {
                this._session.Data = ip.MarketData;
                this._session.Settings.InputSettings.MarketDataFile = ip.MarketDataFile;
                this._session.Settings.InputSettings.MarketDataFileLoaded = true;
                this._session.Settings.Changes.ModelingDataChanged = true;
            }
            if (ip.Technologies != null)
            {
                this._session.Settings.Technologies = ip.Technologies.Data;
                this._session.Settings.InputSettings.TechnologiesFile = ip.TechnologiesFile;
                this._session.Settings.InputSettings.TechnologiesFileLoaded = true;
                this._session.Settings.Changes.TechnologiesDataChanged = true;
            }
            if (ip.Parameters != null)
            {
                this._session.Settings.Parameters = ip.Parameters;
                this._session.Settings.InputSettings.ParametersFile = ip.ParametersFile;
                this._session.Settings.InputSettings.ParametersFileLoaded = true;
                this._session.Settings.Changes.ParametersDataChanged = true;
            }
            if (ip.EmissionsRates != null)
            {
                this._session.Settings.EmissionsRates = ip.EmissionsRates;
                this._session.Settings.InputSettings.EmissionsRatesFile = ip.EmissionsRatesFile;
                this._session.Settings.InputSettings.EmissionsRatesFileLoaded = true;
                this._session.Settings.Changes.EmissionsDataChanged = true;
            }
            if (ip.Scenarios != null)
            {
                this._session.Settings.Scenarios = ip.Scenarios.Data;
                this._session.Settings.InputSettings.ScenariosFile = ip.ScenariosFile;
                this._session.Settings.InputSettings.ScenariosFileLoaded = true;
                this._session.Settings.Changes.ScenariosDataChanged = true;
            }
        }
        private void SaveLabelButton_Click(object sender, System.EventArgs e)
        {
            GeneralCompliancePanel gcp = (GeneralCompliancePanel)this.ux_generalComlianceSettingsPanel.Controls[1];
            EncryptionPanel        ep  = (EncryptionPanel       )this.ux_encryptionSettingsPanel      .Controls[1];
            InputPanel             ip  = (InputPanel            )this.ux_inputSettingsPanel           .Controls[1];
            OutputPanel            op  = (OutputPanel           )this.ux_outputSettingsPanel          .Controls[1];
            OpModesPanel           omp = (OpModesPanel          )this.ux_operatingModesPanel          .Controls[1];
            OptimizationPanel      opp = (OptimizationPanel     )this.ux_optimizationSettingsPanel    .Controls[1];
            MonteCarloPanel        mcp = (MonteCarloPanel       )this.ux_monteCarloSettingsPanel      .Controls[1];
            bool isOpt    = (gcp.SelectedCompliance == null) ? false : (gcp.SelectedCompliance is Optimization   );
            bool isMc     = (gcp.SelectedCompliance == null) ? false : (gcp.SelectedCompliance is MonteCarlo     );
            bool gcpChanged = gcp.SettingsChanged;
            this._session.Settings.Changes.InputChanged |= ip.SettingsChanged;
            this._session.Settings.Changes.OutputChanged |= op.SettingsChanged;
            this._session.Settings.Changes.EncryptionChanged |= ep.SettingsChanged;
            this._session.Settings.Changes.OperatingModesChanged |= omp.SettingsChanged;
            if (isOpt) { this._session.Settings.Changes.OptimizationChanged |= opp.SettingsChanged; }
            if (isMc ) { this._session.Settings.Changes.MonteCarloChanged   |= mcp.SettingsChanged; }
            if (this._inputPanelInitialized)
            {
                ip.SaveChanges();    
            }
            gcp.SaveChanges();
            ep .SaveChanges();
            op .SaveChanges();
            omp.SaveChanges();
            if (isOpt   ) { opp.SaveChanges(); }
            if (isMc    ) { mcp.SaveChanges(); }
            if (gcpChanged)
            {
                this._session.Compliance = gcp.Compliance;
            }
            this._session.Settings.EncryptionSettings = ep.EncryptionSettings;
            this._session.Settings.OutputSettings = op .OutputSettings;
            this._session.Settings.OperatingModes = omp.OperatingModes;
            if (isOpt) { this._session.Settings.OptimizationSettings = opp.OptimizationSettings; }
            if (isMc ) { this._session.Settings.MonteCarloSettings   = mcp.MonteCarloSettings;   }
        }
        private void CloseLabelButton_Click(object sender, System.EventArgs e)
        {
            this.Close();
        }
        #endregion
        #region 
        private Label CreateTitleLabel(string title)
        {
            Label label = new Label();
            label.AutoSize = true;
            label.Font = new Font(Cafe2d.DefaultFont.Name,
                label.Font.Size + 2, FontStyle.Bold);
            label.Location = new Point(8, 8);
            label.Name = "titleLabel";
            label.Text = title;
            return label;
        }
        private RichTextBox CreateStatusTextBox(Point location, Size size)
        {
            RichTextBox statusTextBox = new RichTextBox();
            statusTextBox.BackColor = SystemColors.Control;
            statusTextBox.BorderStyle = BorderStyle.None;
            statusTextBox.Location = location;
            statusTextBox.Name = "statusTextBox";
            statusTextBox.ReadOnly = true;
            statusTextBox.ScrollBars = RichTextBoxScrollBars.Vertical;
            statusTextBox.Size = size;
            statusTextBox.TabStop = false;
            statusTextBox.Text = "";
            return statusTextBox;
        }
        private Panel GenerateRootPanelCommon(int id, string title, string[] names, string[] descriptions)
        {
            Panel panel = new Panel();
            panel.AutoScroll = true;
            panel.Dock = DockStyle.Fill;
            Label titleLabel = this.CreateTitleLabel(title);
            panel.Controls.Add(titleLabel);
            for (int i = 0; i < names.Length; i++)
            {
                LinkLabel link = new LinkLabel();
                link.AutoSize = true;
                link.Location = new Point(16, 32 + 64 * i);
                link.Name = "link" + i.ToString();
                link.Text = names[i];
                link.Tag = this.ux_navigationTreeView.Nodes[id].Nodes[i];
                link.Click += new EventHandler(this.RootSettingsPanel_LinkClicked);
                Label label = new Label();
                label.AutoSize = false;
                label.Location = new Point(16, 48 + 64 * i);
                label.Name = "label" + i.ToString();
                label.Size = new Size(328, 40);
                label.Text = ((descriptions[i] == "") ?
                    "Click here to configure " + names[i] + " for the modeling system." :
                    descriptions[i]);
                panel.Controls.AddRange(new Control[] {link, label});
                if (id == ModelingSettingsNode)
                {
                    int linkIndex, labelIndex;
                    if      (names[i] == "Optimization Settings") { linkIndex = 0; labelIndex = 1; }
                    else if (names[i] == "Monte-Carlo Settings" ) { linkIndex = 2; labelIndex = 3; }
                    else                                                           { continue; }
                    this.ux_modelingSettingsOptAndMcControls[linkIndex ] = link;
                    this.ux_modelingSettingsOptAndMcControls[labelIndex] = label;
                }
            }
            return panel;
        }
        private void GenerateComplianceSettingsPanel()
        {
            this.ux_complianceSettingsPanel = this.GenerateRootPanelCommon(ComplianceSettingsNode, "Compliance Settings",
                new string[] {"General"},
                new string[] {
                                 "Click here to select the Compliance Model that will be used during the modeling process."
                             });
            this.ux_navigationTreeView.Nodes[ComplianceSettingsNode].Tag = this.ux_complianceSettingsPanel;
        }
        private void GenerateGeneralComplianceSettingsPanel()
        {
            this.ux_generalComlianceSettingsPanel = new Panel();
            this.ux_generalComlianceSettingsPanel.Dock = DockStyle.Fill;
            Label titleLabel = this.CreateTitleLabel("General Compliance Settings");
            GeneralCompliancePanel panel = new GeneralCompliancePanel();
            panel.Font                   = Cafe2d.DefaultFont;
            panel.AutoScroll             = true;
            panel.Location               = this.DefaultPanelLocation;
            panel.Size                   = this.DefaultPanelSize;
            panel.SetInitialState(this._session.Compliance);
            this.ux_generalComlianceSettingsPanel.Controls.Add(titleLabel);
            this.ux_generalComlianceSettingsPanel.Controls.Add(panel);
            this.ux_navigationTreeView.Nodes[ComplianceSettingsNode].Nodes[0].Tag = this.ux_generalComlianceSettingsPanel;
        }
        private void GenerateIOSettingsPanel()
        {
            this.ux_ioSettingsPanel = this.GenerateRootPanelCommon(IOSettingsNode, "I/O Settings",
                new string[] {"Encryption Settings", "Input Settings", "Output Settings"},
                new string[] {
                                 "Click here to specify whether you want the model to be able to open password protected " +
                                 "Excel workbooks and whether you want to encrypt the Excel reports generated by the model.",
                                 "Click here to choose the input data files you want the model to use.  The Input Settings " +
                                 "panel allows you to select and load some or all of the Excel workbooks at a time.",
                                 "Click here to configure the locations of output and log files generated by the model, and " +
                                 "to customize which reports will be generated during the modeling process."
                             });
            this.ux_navigationTreeView.Nodes[IOSettingsNode].Tag = this.ux_ioSettingsPanel;
        }
        private void GenerateEncryptionSettingsPanel()
        {
            this.ux_encryptionSettingsPanel = new Panel();
            this.ux_encryptionSettingsPanel.Dock = DockStyle.Fill;
            Label titleLabel = this.CreateTitleLabel("Encryption Settings");
            EncryptionPanel panel = new EncryptionPanel();
            panel.Font            = Cafe2d.DefaultFont;
            panel.AutoScroll      = true;
            panel.Location        = this.DefaultPanelLocation;
            panel.Size            = this.DefaultPanelSize;
            panel.SetInitialState(this._session.Settings.EncryptionSettings);
            this.ux_encryptionSettingsPanel.Controls.Add(titleLabel);
            this.ux_encryptionSettingsPanel.Controls.Add(panel);
            this.ux_navigationTreeView.Nodes[IOSettingsNode].Nodes[0].Tag = this.ux_encryptionSettingsPanel;
        }
        private void GenerateInputSettingsPanel()
        {
            this.ux_inputSettingsPanel = new Panel();
            this.ux_inputSettingsPanel.Dock = DockStyle.Fill;
            this._inputPanelInitialized = false;
            Label titleLabel = this.CreateTitleLabel("Input Settings");
            InputPanel panel = new InputPanel();
            panel.Font       = Cafe2d.DefaultFont;
            panel.AutoScroll = true;
            panel.Location   = this.DefaultPanelLocation;
            panel.Size       = this.DefaultPanelSize;
            panel.InputStateChanged += new InputStateChangedEventHandler(this.InputPanel_InputStateChanged);
            panel.FilesLoaded       += new EventHandler(this.InputPanel_FilesLoaded);
            this.ux_inputSettingsPanel.Controls.Add(titleLabel);
            this.ux_inputSettingsPanel.Controls.Add(panel);
            this.ux_navigationTreeView.Nodes[IOSettingsNode].Nodes[1].Tag = this.ux_inputSettingsPanel;
        }
        private void GenerateOutputSettingsPanel()
        {
            this.ux_outputSettingsPanel = new Panel();
            this.ux_outputSettingsPanel.Dock = DockStyle.Fill;
            Label titleLabel = this.CreateTitleLabel("Output Settings");
            OutputPanel panel = new OutputPanel();
            panel.Font        = Cafe2d.DefaultFont;
            panel.AutoScroll  = true;
            panel.Location    = this.DefaultPanelLocation;
            panel.Size        = this.DefaultPanelSize;
            panel.SetInitialState(this._session.Settings.OutputSettings);
            this.ux_outputSettingsPanel.Controls.Add(titleLabel);
            this.ux_outputSettingsPanel.Controls.Add(panel);
            this.ux_navigationTreeView.Nodes[IOSettingsNode].Nodes[2].Tag = this.ux_outputSettingsPanel;
        }
        private void GenerateModelingSettingsPanel()
        {
            this.ux_modelingSettingsOptAndMcControls = new Control[4];
            this.ux_modelingSettingsPanel = this.GenerateRootPanelCommon(ModelingSettingsNode, "Modeling Settings",
                new string[] {
                                 "Operating Modes",
                                 "Optimization Settings",
                                 "Monte-Carlo Settings"
                             },
                new string[] {
                                 "Click here to select the operating modes you want the model to consider when applying " +
                                 "technologies to vehicles during the compliance loop.",
                                 "Click here to set up the modeling settings specific to the optimization model, such as the " +
                                 "range of standards to examine when optimizing manufacturers.",
                                 "Click here to select the Monte-Carlo model specific settings, such as the number of trial " +
                                 "pairs to examine and whether to distribute the Monte-Carlo modeling."
                             });
            this.ux_navigationTreeView.Nodes[ModelingSettingsNode].Tag = this.ux_modelingSettingsPanel;
        }
        private void GenerateOperatingModesPanel()
        {
            this.ux_operatingModesPanel = new Panel();
            this.ux_operatingModesPanel.Dock = DockStyle.Fill;
            Label titleLabel = this.CreateTitleLabel("Operating Modes");
            OpModesPanel panel = new OpModesPanel();
            panel.Font         = Cafe2d.DefaultFont;
            panel.AutoScroll   = true;
            panel.Location     = this.DefaultPanelLocation;
            panel.Size         = this.DefaultPanelSize;
            panel.SetInitialState(this._session.Settings.OperatingModes, this._minYear, this._maxYear);
            this.ux_operatingModesPanel.Controls.Add(titleLabel);
            this.ux_operatingModesPanel.Controls.Add(panel);
            this.ux_navigationTreeView.Nodes[ModelingSettingsNode].Nodes[0].Tag = this.ux_operatingModesPanel;
        }
        private void GenerateOptimizationSettingsPanel()
        {
            this.ux_optimizationSettingsPanel = new Panel();
            this.ux_optimizationSettingsPanel.Dock = DockStyle.Fill;
            Label titleLabel = this.CreateTitleLabel("Optimization Settings");
            OptimizationPanel panel = new OptimizationPanel();
            panel.Font              = Cafe2d.DefaultFont;
            panel.AutoScroll        = true;
            panel.Location          = this.DefaultPanelLocation;
            panel.Size              = this.DefaultPanelSize;
            panel.SetInitialState(this._session.Settings.OptimizationSettings, this._minYear, this._maxYear);
            this.ux_optimizationSettingsPanel.Controls.Add(titleLabel);
            this.ux_optimizationSettingsPanel.Controls.Add(panel);
            this.ux_navigationTreeView.Nodes[ModelingSettingsNode].Nodes[1].Tag = this.ux_optimizationSettingsPanel;
        }
        private void GenerateMonteCarloSettingsPanel()
        {
            this.ux_monteCarloSettingsPanel = new Panel();
            this.ux_monteCarloSettingsPanel.Dock = DockStyle.Fill;
            Label titleLabel = this.CreateTitleLabel("Monte-Carlo Settings");
            MonteCarloPanel panel = new MonteCarloPanel();
            panel.Font            = Cafe2d.DefaultFont;
            panel.AutoScroll      = true;
            panel.Location        = this.DefaultPanelLocation;
            panel.Size            = this.DefaultPanelSize;
            panel.SetInitialState(this._session.Settings.MonteCarloSettings);
            this.ux_monteCarloSettingsPanel.Controls.Add(titleLabel);
            this.ux_monteCarloSettingsPanel.Controls.Add(panel);
            this.ux_navigationTreeView.Nodes[ModelingSettingsNode].Nodes[2].Tag = this.ux_monteCarloSettingsPanel;
        }
        #endregion
        #endregion
        #region 
        #region 
        private TreeView    ux_navigationTreeView;
        private TreeNode    ux_optimizationNode;
        private TreeNode    ux_monteCarloNode;
        private Panel       ux_settingsPanel;
        private Panel       ux_panel;
        private Panel       ux_toolbarPanel;
        private Label       ux_statusLabel;
        private LabelButton ux_closeLabelButton;
        private LabelButton ux_saveLabelButton;
        #endregion
        #region 
        private Point DefaultPanelLocation;
        private Size  DefaultPanelSize;
        private Panel ux_complianceSettingsPanel;
        private Panel ux_generalComlianceSettingsPanel;
        private Panel ux_ioSettingsPanel;
        private Panel ux_encryptionSettingsPanel;
        private Panel ux_inputSettingsPanel;
        private Panel ux_outputSettingsPanel;
        private Panel ux_modelingSettingsPanel;
        private Panel ux_operatingModesPanel;
        private Panel ux_optimizationSettingsPanel;
        private Panel ux_monteCarloSettingsPanel;
        private Control[] ux_modelingSettingsOptAndMcControls;
        #endregion
        const int ComplianceSettingsNode = 0;
        const int IOSettingsNode = 1;
        const int ModelingSettingsNode = 2;
        Session2d _session;
        bool      _inputPanelInitialized;
        int _minYear;
        int _maxYear;
        #endregion
    }
}

