using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using Volpe.Cafe;
namespace Volpe.Cafe.Ui.Panels
{
    public abstract class CafeUiPanel : Panel
    {
        #region 
        protected CafeUiPanel()
            : base()
        {
            this.InitializeComponent();
            this._messages = new Messages();
            this._checkChanges = new ArrayList();
            this._visualTracking = true;
            this._visualTrackingColor = Color.Blue;
        }
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (this.components != null)
                {
                    this.components.Dispose();
                }
            }
            base.Dispose(disposing);
        }
        #endregion
        #region 
        #region 
        private void InitializeComponent()
        {
        }
        #endregion
        public abstract void SaveChanges();
        protected void InitializeCheckBoxes(CheckBox parent, params CheckBox[] children)
        {
            parent.Tag = children;
            parent.CheckedChanged += new EventHandler(this.ParentCheckBox_CheckedChanged);
            for (int i = 0; i < children.Length; i++)
            {
                children[i].Tag = parent;
                children[i].CheckedChanged += new EventHandler(this.CheckChangesDetector);
                children[i].CheckedChanged += new EventHandler(this.ChildCheckBox_CheckedChanged);
            }
        }
        protected void ParentCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            CheckBox parent = (CheckBox)sender;
            CheckBox[] children = (CheckBox[])parent.Tag;
            for (int i = 0; i < children.Length; i++)
            {
                children[i].CheckedChanged -= new EventHandler(this.ChildCheckBox_CheckedChanged);
                if (parent.CheckState == CheckState.Checked)
                {
                    children[i].Checked = true;
                }
                else if (parent.CheckState == CheckState.Unchecked)
                {
                    children[i].Checked = false;
                }
                children[i].CheckedChanged += new EventHandler(this.ChildCheckBox_CheckedChanged);
            }
        }
        protected void ChildCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            CheckBox child = (CheckBox)sender;
            CheckBox parent = (CheckBox)child.Tag;
            CheckBox[] siblings = (CheckBox[])parent.Tag;
            int count = 0;
            for (int i = 0; i < siblings.Length; i++)
            {
                if (siblings[i].Checked)
                {
                    count++;
                }
            }
            if (count == siblings.Length)
            {
                parent.CheckState = CheckState.Checked;
            }
            else if (count == 0)
            {
                parent.CheckState = CheckState.Unchecked;
            }
            else
            {
                parent.CheckState = CheckState.Indeterminate;
            }
        }
        protected void CheckChangesDetector(object sender, System.EventArgs e)
        {
            if (this._checkChanges != null)
            {
                if (this._checkChanges.Contains(sender))
                {
                    this._checkChanges.Remove(sender);
                    if (this._visualTracking)
                    {
                        ((Control)sender).ForeColor = Control.DefaultForeColor;
                        ((Control)sender).Font = this.Font;
                    }
                }
                else
                {
                    this._checkChanges.Add(sender);
                    if (this._visualTracking)
                    {
                        ((Control)sender).ForeColor = this._visualTrackingColor;
                    }
                }
            }
        }
        #endregion
        #region 
        [Browsable(false)]
        public Messages Messages
        {
            get
            {
                return this._messages;
            }
        }
        [Browsable(false)]
        public virtual bool SettingsChanged
        {
            get
            {
                return this._checkChanges.Count != 0;
            }
        }
        [Browsable(true)]
        [Category("Behavior")]
        [Description("Specifies whether settings, which have changed since the last save, will be color-coded.")]
        [DefaultValue(true)]
        public bool VisualTracking
        {
            get
            {
                return this._visualTracking;
            }
            set
            {
                this._visualTracking = value;
            }
        }
        [Browsable(true)]
        [Category("Behavior")]
        [Description("Specifies the color to use when color-coding settings that have changed " +
             "since the last save.")]
        public Color VisualTrackingColor
        {
            get
            {
                return this._visualTrackingColor;
            }
            set
            {
                this._visualTrackingColor = value;
            }
        }
        #endregion
        #region 
        #region 
        protected System.ComponentModel.IContainer components = null;
        #endregion
        protected Messages _messages;
        protected ArrayList _checkChanges;
        protected bool _visualTracking;
        protected Color _visualTrackingColor;
        #endregion
    }
}

