using System;
using System.IO;
namespace Volpe.Cafe.Ui
{
    public class ProgramArgs
    {
        #region 
        internal void Parse(string[] args)
        {
            this.HasArgs = false;
            this.ArgCount = 0;
            int argCount = args.Length;
            if (argCount == 1)
            {   
                string path = args[0];
                if (File.Exists(path) && Path.GetExtension(path).ToUpper() == ".CMSD")
                {    
                    this.HasArgs = true;
                    this.ArgCount = 1;
                    this.CMSDNoPrompt = false;
                    this.CMSDPath = path;
                    return;
                }
            }
            for (int i = 0; i < argCount; i++)
            {   
                bool foundArg = true;
                string curArg = args[i];
                string curArgKey = (curArg.Length > 1)                       ? curArg.Substring(0, 2) : curArg;
                string curArgPrm = (curArg.Length > 2 && curArg[2] == '=') ? curArg.Substring(3)    : null;
                switch (curArgKey.ToLower())
                {
                    case "/u":
                        if (curArgPrm != null)
                        {
                            this.Uninstall = true;
                            this.UninstallProductKey = curArgPrm;
                        }
                        break;
                    case "/s":
                        if (curArgPrm != null && File.Exists(curArgPrm) &&
                            Path.GetExtension(curArgPrm).ToUpper() == ".CMSD")
                        {
                            this.CMSDNoPrompt = true;
                            this.CMSDPath = curArgPrm;
                        }
                        break;
                    case "/o":
                        if (curArgPrm != null)
                        {   
                        }
                        break;
                    default:
                        foundArg = false;
                        break;    
                }
                if (foundArg) { this.ArgCount++; }
            }
            this.HasArgs = (this.ArgCount > 0);
        }
        #endregion
        #region 
        internal bool   HasArgs;
        internal int    ArgCount;
        internal bool   Uninstall;
        internal string UninstallProductKey;
        internal bool   CMSDNoPrompt;
        internal string CMSDPath;
        #endregion
    }
}

