using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
namespace Volpe.Cafe.Ui.Wizards
{
    internal class NSW_EnterOutputPassword : Panel
    {
        #region 
        public NSW_EnterOutputPassword()
        {
            this.InitializeComponent();
        }
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (this.components != null)
                {
                    this.components.Dispose();
                }
            }
            base.Dispose(disposing);
        }
        #endregion
        #region 
        private void InitializeComponent()
        {
            this.ux_bodyLabel = new System.Windows.Forms.Label();
            this.ux_passwordLabel = new System.Windows.Forms.Label();
            this.ux_passwordTextBox = new System.Windows.Forms.TextBox();
            this.ux_verifyLabel = new System.Windows.Forms.Label();
            this.ux_verifyTextBox = new System.Windows.Forms.TextBox();
            this.SuspendLayout();
            this.ux_bodyLabel.Location = new System.Drawing.Point(8, 8);
            this.ux_bodyLabel.Name = "ux_bodyLabel";
            this.ux_bodyLabel.Size = new System.Drawing.Size(408, 56);
            this.ux_bodyLabel.TabIndex = 0;
            this.ux_bodyLabel.Text = "Password protecting critical information helps keep " +
                "your data safe.  This screen allows you to enter a password that the model " +
                "will use when generating reports.  If you do not want to select a password " +
                "at this time, you may skip this section.  Otherwise, please enter your " +
                "password below.";
            this.ux_passwordLabel.AutoSize = true;
            this.ux_passwordLabel.Location = new System.Drawing.Point(16, 72);
            this.ux_passwordLabel.Name = "ux_passwordLabel";
            this.ux_passwordLabel.Size = new System.Drawing.Size(85, 17);
            this.ux_passwordLabel.TabIndex = 1;
            this.ux_passwordLabel.Text = "Enter password:";
            this.ux_passwordTextBox.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_passwordTextBox.Location = new System.Drawing.Point(16, 88);
            this.ux_passwordTextBox.MaxLength = 64;
            this.ux_passwordTextBox.Name = "ux_passwordTextBox";
            this.ux_passwordTextBox.PasswordChar = '*';
            this.ux_passwordTextBox.Size = new System.Drawing.Size(128, 21);
            this.ux_passwordTextBox.TabIndex = 2;
            this.ux_passwordTextBox.Text = "";
            this.ux_passwordTextBox.TextChanged += new EventHandler(this.VerifyPasswordTextBox_TextChanged);
            this.ux_verifyLabel.AutoSize = true;
            this.ux_verifyLabel.Location = new System.Drawing.Point(152, 72);
            this.ux_verifyLabel.Name = "ux_verifyLabel";
            this.ux_verifyLabel.Size = new System.Drawing.Size(88, 17);
            this.ux_verifyLabel.TabIndex = 3;
            this.ux_verifyLabel.Text = "Verify password:";
            this.ux_verifyTextBox.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_verifyTextBox.Location = new System.Drawing.Point(152, 88);
            this.ux_verifyTextBox.MaxLength = 64;
            this.ux_verifyTextBox.Name = "ux_verifyTextBox";
            this.ux_verifyTextBox.PasswordChar = '*';
            this.ux_verifyTextBox.Size = new System.Drawing.Size(128, 21);
            this.ux_verifyTextBox.TabIndex = 4;
            this.ux_verifyTextBox.Text = "";
            this.ux_verifyTextBox.TextChanged += new EventHandler(this.VerifyPasswordTextBox_TextChanged);
            this.Controls.AddRange(
                new Control[] {
                                  this.ux_bodyLabel,
                                  this.ux_passwordTextBox,
                                  this.ux_passwordLabel,
                                  this.ux_verifyTextBox,
                                  this.ux_verifyLabel
                              });
            this.Name = "NSW_EnterOutputPassword";
            this.Size = new System.Drawing.Size(416, 335);
            this.ResumeLayout(false);
        }
        private void VerifyPasswordTextBox_TextChanged(object sender, EventArgs e)
        {
            bool pwMatch = this.PasswordsMatch;
            Color backColor = (pwMatch) ? Color.White : Color.LightYellow;
            Color foreColor = (pwMatch) ? Color.Black : Color.Red;
            this.ux_passwordTextBox.BackColor = this.ux_verifyTextBox.BackColor = backColor;
            this.ux_passwordTextBox.ForeColor = this.ux_verifyTextBox.ForeColor = foreColor;
        }
        public void SetInitialState(ModelingSettings modelingSettings)
        {
            this.ux_passwordTextBox.Text = modelingSettings.EncryptionSettings.OutputPasswordToOpen;
            this.ux_verifyTextBox.Text = modelingSettings.EncryptionSettings.OutputPasswordToOpen;
        }
        #endregion
        #region 
        public string OutputPassword
        {
            get
            {
                return (this.PasswordsMatch) ? this.ux_passwordTextBox.Text : "";
            }
        }
        public bool PasswordsMatch
        {
            get
            {
                return (this.ux_passwordTextBox.Text == this.ux_verifyTextBox.Text);
            }
        }
        #endregion
        #region 
        #region 
        private System.Windows.Forms.Label ux_bodyLabel;
        private System.Windows.Forms.Label ux_passwordLabel;
        private System.Windows.Forms.TextBox ux_passwordTextBox;
        private System.Windows.Forms.Label ux_verifyLabel;
        private System.Windows.Forms.TextBox ux_verifyTextBox;
        protected System.ComponentModel.IContainer components = null;
        #endregion
        #endregion
    }
}

