using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Reflection;
using System.Windows.Forms;
using Volpe.Cafe.Model;
namespace Volpe.Cafe.Ui.Wizards
{
    internal class NSW_SelectComplianceModel : Panel
    {
        #region 
        public NSW_SelectComplianceModel()
        {
            this.InitializeComponent();
        }
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (this.components != null)
                {
                    this.components.Dispose();
                }
            }
            base.Dispose(disposing);
        }
        #endregion
        #region 
        private void InitializeComponent()
        {
            this.ux_bodyLabel = new System.Windows.Forms.Label();
            this.ux_complianceListPanel = new System.Windows.Forms.Panel();
            this.ux_complianceListPanel.SuspendLayout();
            this.SuspendLayout();
            this.ux_bodyLabel.Location = new System.Drawing.Point(8, 8);
            this.ux_bodyLabel.Name = "ux_bodyLabel";
            this.ux_bodyLabel.Size = new System.Drawing.Size(408, 72);
            this.ux_bodyLabel.TabIndex = 0;
            this.ux_bodyLabel.Text = @"This screen lets you specify which compliance modeling logic you would like to use during the modeling process.  The Compliance Model serves as the heart of the CAFE Model application, and performs all of the essential calculations.  Below, please find the list of available Compliance Models, along with their descriptions, and select the one you would like to use.";
            this.ux_complianceListPanel.AutoScroll = true;
            this.ux_complianceListPanel.Location = new System.Drawing.Point(0, 80);
            this.ux_complianceListPanel.Name = "ux_complianceListPanel";
            this.ux_complianceListPanel.Size = new System.Drawing.Size(412, 248);
            this.ux_complianceListPanel.TabIndex = 1;
            this.Controls.AddRange(
                new Control[] {
                                  this.ux_bodyLabel,
                                  this.ux_complianceListPanel
                              });
            this.Name = "NSW_SelectComplianceModel";
            this.Size = new System.Drawing.Size(416, 335);
            this.ux_complianceListPanel.ResumeLayout(false);
            this.ResumeLayout(false);
        }
        private void SelectCompliance(object sender, EventArgs e)
        {
            RadioButton rdb = (RadioButton)sender;
            if (rdb.Checked)
            {
                ICompliance compliance = (ICompliance)rdb.Tag;
                this._selectedCompliance = compliance;
            }
        }
        public void SetInitialState(ICompliance defaultCompliance)
        {
            Type[] cmp = Cafe2d.ComplianceTypes;
            string defaultName = "volpe.cafe.model.compliance";
            string userDefault = (defaultCompliance == null) ? null : defaultCompliance.GetType().FullName.ToLower();
            bool defaultSet = false;
            int y = 8;
            int width = this.ux_complianceListPanel.Width - 48;
            for (int i = 0; i < cmp.Length; i++)
            {
                string complianceName = cmp[i].FullName.ToLower();
                ModelDescriptionAttribute attr = (ModelDescriptionAttribute)Attribute.GetCustomAttribute(cmp[i],
                    typeof(ModelDescriptionAttribute));
                ConstructorInfo ctor = cmp[i].GetConstructor(Type.EmptyTypes);
                ICompliance compliance = (ICompliance)ctor.Invoke(new object[] {});
                RadioButton rdb = new RadioButton();
                rdb.Text = attr.FullTitle;
                rdb.Tag = compliance;
                rdb.Location = new Point(16, y);
                rdb.Size = new Size(width, 16);
                rdb.CheckedChanged += new EventHandler(this.SelectCompliance);
                y = rdb.Top + rdb.Height;
                Label lbl = new Label();
                lbl.Text = attr.Description;
                lbl.Location = new Point(32, y);
                Global.AutoSizeLabel(lbl, width);
                y = lbl.Top + lbl.Height;
                this.ux_complianceListPanel.Controls.AddRange(new Control[] {rdb, lbl});
                if (complianceName == userDefault || (!defaultSet && complianceName == defaultName))
                {
                    rdb.Checked = true;
                    defaultSet = true;
                }
            }
        }
        #endregion
        #region 
        public ICompliance SelectedCompliance
        {
            get
            {
                return this._selectedCompliance;
            }
        }
        #endregion
        #region 
        #region 
        private System.Windows.Forms.Label ux_bodyLabel;
        private System.Windows.Forms.Panel ux_complianceListPanel;
        protected System.ComponentModel.IContainer components = null;
        #endregion
        private ICompliance _selectedCompliance;
        #endregion
    }
}

