using System;
namespace Volpe.Cafe.Data
{
    [Serializable]
    public class ManufacturerDescription : ICloneable
    {
        #region 
        public ManufacturerDescription()
            : base()
        {
        }
        #endregion
        #region 
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        public ManufacturerDescription Clone()
        {
            ManufacturerDescription md = new ManufacturerDescription();
            md.Code = this.Code;
            md.Name = this.Name;
            md.CostAllocationStrategy = this.CostAllocationStrategy;
            md.AverageMY2002LtCw      = this.AverageMY2002LtCw;
            md.DiscountRate           = this.DiscountRate;
            md.Optimize               = this.Optimize;
            md.WillingToPayFines      = (bool  [])Global.CloneArray(this.WillingToPayFines, typeof(bool  ));
            md.AvailableCredits       = (double[])Global.CloneArray(this.AvailableCredits , typeof(double));
            md.CreditsApplyToBaseline = this.CreditsApplyToBaseline;
            return md;
        }
        #endregion
        #endregion
        #region 
        public int Code;
        public string Name;
        public int CostAllocationStrategy;
        public double AverageMY2002LtCw;
        public double DiscountRate;
        public bool Optimize;
        public bool[] WillingToPayFines;
        public double[] AvailableCredits;
        public bool CreditsApplyToBaseline;
        #endregion
    }
}

