using System;
using System.Text;
namespace Volpe.Cafe.Data
{
    [Serializable]
    public class TransmissionDescription : ICloneable
    {
        #region 
        [Serializable]
        public struct TechnologyOverrides
        {
            public override string ToString()
            {
                return this.ToString(',');
            }
            public string ToString(char delimiter)
            {
                StringBuilder sb = new StringBuilder();
                sb.Append("MAN6="  + this.MAN6);    sb.Append(delimiter);
                sb.Append("IATC="  + this.IATC);    sb.Append(delimiter);
                sb.Append("CVT="   + this.CVT);     sb.Append(delimiter);
                sb.Append("NAUTO=" + this.NAUTO);   sb.Append(delimiter);
                sb.Append("DCTAM=" + this.DCTAM);
                return sb.ToString();
            }
            public TechnologyOverride this[string abbr]
            {
                get
                {
                    switch (abbr.ToUpper())
                    {
                        case "6MAN" : return this.MAN6 ;
                        case "IATC" : return this.IATC ;
                        case "CVT"  : return this.CVT  ;
                        case "NAUTO": return this.NAUTO;
                        case "DCTAM": return this.DCTAM;
                        default: return TechnologyOverride.None;
                    }
                }
            }
            public TechnologyOverride MAN6;
            public TechnologyOverride IATC;
            public TechnologyOverride CVT;
            public TechnologyOverride NAUTO;
            public TechnologyOverride DCTAM;
        }
        #endregion
        #region 
        public TransmissionDescription()
            : base()
        {
        }
        #endregion
        #region 
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        public TransmissionDescription Clone()
        {
            TransmissionDescription td = new TransmissionDescription();
            td.Code            = this.Code;
            td.Manufacturer    = this.Manufacturer;
            td.Name            = this.Name;
            td.Type            = this.Type;
            td.NumForwardGears = this.NumForwardGears;
            td.Control         = this.Control;
            td.Logic           = this.Logic;
            td.Overrides       = this.Overrides;
            return td;
        }
        #endregion
        #endregion
        #region 
        public int    Code;
        public string Manufacturer;
        public string Name;
        public string Type;
        public int    NumForwardGears;
        public string Control;
        public string Logic;
        public TransmissionDescription.TechnologyOverrides Overrides;
        #endregion
    }
}

