using System;
using System.Text;
namespace Volpe.Cafe.Data
{
    [Serializable]
    public class VehicleDescription : ICloneable
    {
        #region 
        [Serializable]
        public struct TechnologyOverrides
        {
            public override string ToString()
            {
                return this.ToString(',');
            }
            public string ToString(char delimiter)
            {
                StringBuilder sb = new StringBuilder();
                sb.Append("EPS="   + this.EPS);     sb.Append(delimiter);
                sb.Append("IACC="  + this.IACC);    sb.Append(delimiter);
                sb.Append("MHEV="  + this.MHEV);    sb.Append(delimiter);
                sb.Append("HVIA="  + this.HVIA);    sb.Append(delimiter);
                sb.Append("BISG="  + this.BISG);    sb.Append(delimiter);
                sb.Append("CISG="  + this.CISG);    sb.Append(delimiter);
                sb.Append("PSHEV=" + this.PSHEV);   sb.Append(delimiter);
                sb.Append("MHEV2=" + this.MHEV2);   sb.Append(delimiter);
                sb.Append("PHEV="  + this.PHEV);    sb.Append(delimiter);
                sb.Append("MS1="   + this.MS1);     sb.Append(delimiter);
                sb.Append("MS2="   + this.MS2);     sb.Append(delimiter);
                sb.Append("MS5="   + this.MS5);     sb.Append(delimiter);
                sb.Append("ROLL="  + this.ROLL);    sb.Append(delimiter);
                sb.Append("LDB="   + this.LDB);     sb.Append(delimiter);
                sb.Append("SAXU="  + this.SAXU);    sb.Append(delimiter);
                sb.Append("SAXL="  + this.SAXL);    sb.Append(delimiter);
                sb.Append("AERO="  + this.AERO);
                return sb.ToString();
            }
            public TechnologyOverride this[string abbr]
            {
                get
                {
                    switch (abbr.ToUpper())
                    {
                        case "EPS"  : return this.EPS;
                        case "IACC" : return this.IACC;
                        case "MHEV" : return this.MHEV;
                        case "HVIA" : return this.HVIA;
                        case "BISG" : return this.BISG;
                        case "CISG" : return this.CISG;
                        case "PSHEV": return this.PSHEV;
                        case "2MHEV": return this.MHEV2;
                        case "PHEV" : return this.PHEV;
                        case "MS1"  : return this.MS1;
                        case "MS2"  : return this.MS2;
                        case "MS5"  : return this.MS5;
                        case "ROLL" : return this.ROLL;
                        case "LDB"  : return this.LDB;
                        case "SAXU" : return this.SAXU;
                        case "SAXL" : return this.SAXL;
                        case "AERO" : return this.AERO;
                        default: return TechnologyOverride.None;
                    }
                }
            }
            public TechnologyOverride EPS;
            public TechnologyOverride IACC;
            public TechnologyOverride MHEV;
            public TechnologyOverride HVIA;
            public TechnologyOverride BISG;
            public TechnologyOverride CISG;
            public TechnologyOverride PSHEV;
            public TechnologyOverride MHEV2;
            public TechnologyOverride PHEV;
            public TechnologyOverride MS1;
            public TechnologyOverride MS2;
            public TechnologyOverride MS5;
            public TechnologyOverride ROLL;
            public TechnologyOverride LDB;
            public TechnologyOverride SAXU;
            public TechnologyOverride SAXL;
            public TechnologyOverride AERO;
        }
        #endregion
        #region 
        public VehicleDescription(double baseWeight)
            : base()
        {
            this.BaseWeight = baseWeight;
        }
        #endregion
        #region 
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        public VehicleDescription Clone()
        {
            VehicleDescription vd = new VehicleDescription(this.BaseWeight);
            vd.Code                  = this.Code;
            vd.Manufacturer          = this.Manufacturer;
            vd.Model                 = this.Model;
            vd.Nameplate             = this.Nameplate;
            vd.RatedFuelEconomy      = this.RatedFuelEconomy;
            vd.ActualFuelEconomy     = this.ActualFuelEconomy;
            vd.EngineCode            = this.EngineCode;
            vd.TransmissionCode      = this.TransmissionCode;
            vd.Origin                = this.Origin;
            vd.Style                 = this.Style;
            vd.Class                 = this.Class;
            vd.Structure             = this.Structure;
            vd.Drive                 = this.Drive;
            vd.Wheelbase             = this.Wheelbase;
            vd.FrontTrackWidth       = this.FrontTrackWidth;
            vd.RearTrackWidth        = this.RearTrackWidth;
            vd.Footprint             = this.Footprint;
            vd.CurbWeight            = this.CurbWeight;
            vd.TestWeight            = this.TestWeight;
            vd.GVWR                  = this.GVWR;
            vd.FuelCapacity          = this.FuelCapacity;
            vd.Seating               = this.Seating;
            vd.HybridType            = this.HybridType;
            vd.USContent             = this.USContent;
            vd.CanadianContent       = this.CanadianContent;
            vd.MexicanContent        = this.MexicanContent;
            vd.PredecessorCode       = this.PredecessorCode;
            vd.RedesignYears         = (int[])Global.CloneArray(this.RedesignYears, typeof(int));
            vd.RefreshYears          = (int[])Global.CloneArray(this.RefreshYears , typeof(int));
            vd.EmploymentHours       = this.EmploymentHours;
            vd.Percent2Dr            = this.Percent2Dr;
            vd.AutoNewsMarketSegment = this.AutoNewsMarketSegment;
            vd.Cohort                = this.Cohort;
            vd.Outlier               = this.Outlier;
            vd.TechnologyClass       = this.TechnologyClass;
            vd.Overrides             = this.Overrides;
            vd.Sales = new double[this.Sales.Length];
            this.Sales.CopyTo(vd.Sales, 0);
            vd.Msrp = new double[this.Msrp.Length];
            this.Msrp.CopyTo(vd.Msrp, 0);
            vd.Price = new double[this.Price.Length];
            this.Price.CopyTo(vd.Price, 0);
            return vd;
        }
        #endregion
        #endregion
        #region 
        public double FuelEconomy
        {
            get { return (this.ActualFuelEconomy > 0) ? this.ActualFuelEconomy : this.RatedFuelEconomy; }
            set
            {
                if (this.ActualFuelEconomy > 0)
                {
                    this.ActualFuelEconomy = value;
                }
                else
                {
                    this.RatedFuelEconomy = value;
                }
            }
        }
        #endregion
        #region 
        public int    Code;
        public string Manufacturer;
        public string Model;
        public string Nameplate;
        public double RatedFuelEconomy;
        public double ActualFuelEconomy;
        public int EngineCode;
        public int TransmissionCode;
        public double[] Sales;
        public double[] Msrp;
        public double[] Price;
        public string Style;
        public string Class;
        public string Structure;
        public char   Drive;
        public double Wheelbase;
        public double FrontTrackWidth;
        public double RearTrackWidth;
        public double Footprint;
        readonly public double BaseWeight;
        public double CurbWeight;
        public double TestWeight;
        public double GVWR;
        public double FuelCapacity;
        public int    Seating;
        public string HybridType;
        public char   Origin;
        public double USContent;
        public double CanadianContent;
        public double MexicanContent;
        public int   PredecessorCode;
        public int[] RedesignYears;
        public int[] RefreshYears;
        public double EmploymentHours;
        public double Percent2Dr;
        public int    AutoNewsMarketSegment;
        public int  Cohort;
        public bool Outlier;
        public TechnologyClass TechnologyClass;
        public VehicleDescription.TechnologyOverrides Overrides;
        #endregion
    }
}

