using System;
using Volpe.Cafe.IO;
namespace Volpe.Cafe
{
    [Serializable]
    public struct OptimizationSettings
    {
        #region 
        internal void WriteSummaryLog(LogWriter writer)
        {
            if (writer.Summary == null) { return; }
            string outStr = "--- Optimization Settings ---"                   +
                "\r\n  Type="                   + this.Type                   +
                "\r\n  Mode="                   + this.Mode                   +
                "\r\n  AboveOptimum="           + this.AboveOptimum           +
                "\r\n  BelowOptimum="           + this.BelowOptimum           +
                "\r\n  Increment="              + this.Increment              +
                "\r\n  MergedFleet="            + this.MergedFleet            +
                "\r\n  BackstopStandard="       + this.BackstopStandard       +
                "\r\n  BackstopTargetFunction=" + this.BackstopTargetFunction +
                "\r\n  StartYear="              + this.StartYear              +
                "\r\n  StopOnFinedIterations="  + this.StopOnFinedIterations  +
                "\r\n  CountFinesTowardNB="     + this.CountFinesTowardNB     +
                "\r\n  DiscardMfrsWithFines="   + this.DiscardMfrsWithFines;
            writer.Summary.WriteLine(outStr + "\r\n");
        }
        #endregion
        #region 
        public OptimizationType Type;
        public OptimizationMode Mode;
        public int AboveOptimum;
        public int BelowOptimum;
        public double Increment;
        public bool MergedFleet;
        public bool BackstopStandard;
        public bool BackstopTargetFunction;
        public int StartYear;
        public bool StopOnFinedIterations;
        public bool CountFinesTowardNB;
        public bool DiscardMfrsWithFines;
        #endregion
    }
}

