using System;
using System.Threading;
using System.Diagnostics;
namespace Volpe.Interaction
{
    [Serializable]
    public class Monitor
    {
        #region 
        public delegate void PolledEventHandler(object sender);
        #endregion
        #region 
        public event PolledEventHandler Polled;
        #endregion
        #region 
        public Monitor() : this(1000)
        {
        }
        public Monitor(int pollInterval)
            : this(Process.GetCurrentProcess().Id, pollInterval)
        {
        }
        public Monitor(int pId, int pollInterval)
            : this(new int[] {pId}, pollInterval)
        {
        }
        public Monitor(int []pIds, int pollInterval)
        {
            this._pollInterval = pollInterval;
            this._numPIds = pIds.Length;
            this._pIds = new int[this._numPIds];
            Array.Copy(pIds, this._pIds, this._numPIds);
        }
        public Monitor(Process []processes, int pollInterval)
        {
            this._pollInterval = pollInterval;
            this._numPIds = processes.Length;
            this._pIds    = new int[this._numPIds];
            for (int i = 0; i < this._numPIds; i++)
            {
                this._pIds[i] = processes[i].Id;
            }
        }
        #endregion
        #region 
        public void Start()
        {
            this._pi = new ProcessInfo[this._numPIds];
            for (int i = 0; i < this._numPIds; i++)
            {
                this._pi[i] = new ProcessInfo(this._pIds[i]);
            }
            this._th = new Thread(new ThreadStart(this.PollThread));
            this._th.Name = "PollThread";
            this._th.Start();
        }
        public void Stop()
        {
            this._poll = false;
        }
        private void PollThread()
        {
            this._poll = true;
            while(this._poll)
            {
                for (int i = 0; i < this._numPIds; i++)
                {
                    if (this._poll) { this._pi[i].Poll(this._pollInterval); }
                }
                if (this._poll && this.Polled != null) { this.Polled(this); }
                Thread.Sleep(this._pollInterval);
            }
        }
        #endregion
        #region 
        public ProcessInfo[] ProcessInfo { get { return this._pi; } }
        public int PollInterval
        {
            get { return this._pollInterval; }
            set { this._pollInterval = value; }
        }
        #endregion
        #region 
        private int _numPIds;
        private int[] _pIds;
        private ProcessInfo[] _pi;
        private Thread _th;
        private int  _pollInterval;
        private bool _poll;
        #endregion
    }
}

