using System;
namespace Volpe.Utils
{
    [Serializable]
    public class XlAxisTitleFormat
    {
        #region 
        public XlAxisTitleFormat()
            : this(null)
        {
        }
        public XlAxisTitleFormat(string caption)
            : this(caption, 0)
        {
        }
        public XlAxisTitleFormat(string caption, XlFont font, XlTextAlignment textAlignment)
            : this(caption, font, textAlignment, 0)
        {
        }
        public XlAxisTitleFormat(string caption, int textOrientation)
            : this(caption, XlAxisTitleFormat.DefaultFont, XlAxisTitleFormat.DefaultAlignment, textOrientation)
        {
        }
        public XlAxisTitleFormat(string caption, XlFont font, XlTextAlignment textAlignment, int textOrientation)
            : this(caption, font, textAlignment, textOrientation, false, double.NaN, double.NaN)
        {
        }
        public XlAxisTitleFormat(string caption, XlFont font, XlTextAlignment textAlignment, int textOrientation,
            bool shadow, double top, double left)
        {
            this._caption         = caption;
            this._font            = font;
            this._textAlignment   = textAlignment;
            this._textOrientation = (textOrientation < -90) ? -90 : (textOrientation > 90) ? 90 : textOrientation;
            this._shadow          = shadow;
            this._top             = top;
            this._left            = left;
        }
        #endregion
        #region 
        public override string ToString()
        {
            return "{Caption="       + this._caption +
                ", Font="            + this._font +
                ", TextAlignment="   + this._textAlignment +
                ", TextOrientation=" + this._textOrientation +
                ", Shadow="          + this._shadow +
                ", Top="             + this._top +
                ", Left="            + this._left + "}";
        }
        #endregion
        #region 
        public string Caption
        {
            get { return this._caption; }
            set { this._caption = value; }
        }
        public XlFont Font
        {
            get { return this._font; }
            set { this._font = value; }
        }
        public XlTextAlignment TextAlignment
        {
            get { return this._textAlignment; }
            set { this._textAlignment = value; }
        }
        public int TextOrientation
        {
            get { return this._textOrientation; }
            set { this._textOrientation = (value < -90) ? -90 : (value > 90) ? 90 : value; }
        }
        public bool Shadow
        {
            get { return this._shadow; }
            set { this._shadow = value; }
        }
        public double Left
        {
            get { return this._left; }
            set { this._left = value; }
        }
        public double Top
        {
            get { return this._top; }
            set { this._top = value; }
        }
        #endregion
        #region 
        public static readonly XlFont DefaultFont = new XlFont("Arial", 10, false, true, false);
        public static readonly XlTextAlignment DefaultAlignment = new XlTextAlignment(XlHAlign.Center, XlVAlign.Center);
        private string _caption;
        private XlFont _font;
        private XlTextAlignment _textAlignment;
        private int    _textOrientation;
        private bool   _shadow;
        private double _left;
        private double _top;
        #endregion
    }
}

