using System;
using Volpe.Cafe.Collections;
using Volpe.Cafe.Data;
using CGlobal = Volpe.Cafe.Global;
namespace Volpe.Cafe.Reporter.ReportTypes
{
    internal class Calculate
    {
        public static double IndStandard(Industry data, ModelYear year, bool bigNOnly, bool includeUnregulated,
            bool isPreliminary)
        {
            RCDouble standardSum = RCDouble.Zero;
            RCDouble salesSum    = RCDouble.Zero;
            ManufacturerCollection mfrs = data.Manufacturers;
            for (int i = 0, mfrCount = mfrs.Count; i < mfrCount; i++)
            {
                Manufacturer mfr = mfrs[i];
                if (!bigNOnly || mfr.Description.Optimize)
                {
                    ManufacturerModelingData mmd = mfr.ModelingData;
                    standardSum += RCDouble.ZeroNaNs(mmd.Sales / ((isPreliminary) ? mmd.PreliminaryStandard : mmd.Standard));
                    salesSum    += mmd.Sales;
                }
            }
            return ((includeUnregulated) ? (salesSum.TotalAll / standardSum.TotalAll) : (salesSum.Total / standardSum.Total));
        }
        public static RCDouble IndBenefits(Industry data, bool bigNOnly)
        {
            if (!bigNOnly)
            {
                AggregateEffectsData ied = data.ModelingData.EffectsData;
                return ied.RcDiscSocialBenefits;
            }
            else
            {
                RCDouble sum = RCDouble.Zero;
                for (int i = 0, mfrCount = data.ManufacturerCount; i < mfrCount; i++)
                {
                    Manufacturer mfr = data.Manufacturers[i];
                    if (mfr.Description.Optimize)
                    {
                        sum += mfr.ModelingData.DiscSocialBenefits;
                    }
                }
                return sum;
            }
        }
        public static M6Double ArraySum(M6Double[] array)
        {
            M6Double value = new M6Double();
            for (int i = 0, arrLen = array.Length; i < arrLen; i++)
            {
                value += array[i];
            }
            return value;
        }
        [Obsolete("Use: \"mfr.Data.Optimize\" instead.", true)]
        public static bool IsBig7(Manufacturer mfr)
        {
            return CGlobal.StringCompareAny(mfr.Description.Name,
                new string[] {"GMC", "FMC", "DCC", "HON", "HYU", "NIS", "TOY"}, false);
        }
        [Obsolete("Use: \"TechnologyIndexes.TechAbbr\" instead.", true)]
        public static string[] GetTechAbbr(TechnologyCollection technologies)
        {
            string[] techs = new string[technologies.Count];
            for (int i = 0; i < technologies.Count; i++)
            {
                techs[i] = technologies[i].Abbr;
            }
            return techs;
        }
        public static string[] GetTechHeaders(TechnologyCollection technologies, bool noCr)
        {
            string[] techs = new string[TechnologyIndexes.TechnologyCount];
            string sp = (noCr) ? ". " : "\n";
            for (int i = 0; i < technologies.Count; i++)
            {
                techs[i] = (i + 1) + sp + TechnologyIndexes.TechAbbr[i];
            }
            return techs;
        }
        public static string[] GetRcHeaders()
        {
            return new string[] {"Unregulated", "Dom Auto", "Imp Auto", "Light Truck", "Overall"};
        }
        public static string[] GetMfrIndyVHeaders()
        {
            return new string[] {"Total Sales", "Value of Preliminary CAFE Standard", "Value of Final CAFE Standard",
                "Average Fuel Economy", "Average Curb Weight (lb.)", "Average Area (sq. ft.)",
                "Average Technology Costs (RPE)", "Average Fines Incurred (RPE)",
                "Average Price Increase Per Vehicle\n(Including Tech Costs and Fines)",
                "Total Incurred Technology Costs ($m)", "Total Fines Owed ($m)",
                "Total Increase in Sales Revenue ($m)"};
        }
        public static string[] GetVehHeaders()
        {
            return new string[] {"Index", "ID#", "Manufacturer", "Model", "Name Plate",
                "Reg Class", "Technology Class", "Pred\nID#", "Total Sales", "", "Initial\nMSRP\n($)", "Initial\nPrice\n($)",
                "Fuel Econ.\n(mpg)", "", "Curb\nWeight (lb)", "", "Area\n(sf)", "Engine",
                "", "", "", "Transmission", "", "Unit ($)", "", "Total ($k)", "", "Redesign\nState", "Refresh\nState"};
        }
        public const int RcHeadersCount = 5;
        public const int MfrIndyVHeadersCount = 12;
        public const int VehHeadersCount = 25;
    }
}

