using System;
using System.Collections;
using System.Drawing;
using System.Windows.Forms;
namespace Volpe.Cafe.Ui
{
    public class Messages
    {
        #region 
        private struct Message
        {
            public Message(string message, Color color, object key)
            {
                this.Text = message;
                this.Color = color;
                this.Key = key;
            }
            public string Text;
            public Color Color;
            public object Key;
        }
        #endregion
        #region 
        public event EventHandler MessagesChanged;
        #endregion
        #region 
        public Messages()
        {
            this._list = new ArrayList();
        }
        #endregion
        #region 
        public void ClearMessages()
        {
            this._list.Clear();
            this.OnMessagesChanged(EventArgs.Empty);
        }
        public void AddMessage(string message, Color color, object key)
        {
            this.RemoveMessage(key);
            this._list.Add(new Message(message, color, key));
            this.OnMessagesChanged(EventArgs.Empty);
        }
        public void RemoveMessage(object key)
        {
            int index = this.FindMessage(key);
            while (index != -1)
            {
                this.RemoveMessage(index);
                index = this.FindMessage(key);
            }
        }
        public void RemoveMessage(int index)
        {
            if (index != -1)
            {
                this._list.RemoveAt(index);
                this.OnMessagesChanged(EventArgs.Empty);
            }
        }
        public int FindMessage(object key)
        {
            for (int i = 0; i < this._list.Count; i++)
            {
                if (((Message)this._list[i]).Key == key)
                {
                    return i;
                }
            }
            return -1;
        }
        public override string ToString()
        {
            return this.ToString(false);
        }
        public string ToString(bool doubleSpaced)
        {
            RichTextBox rtf = new RichTextBox();
            for (int i = 0; i < this._list.Count; i++)
            {
                Message msg = (Message)this._list[i];
                rtf.Text += msg.Text;
                rtf.SelectionStart = rtf.TextLength - msg.Text.Length;
                rtf.SelectionLength = msg.Text.Length;
                rtf.SelectionColor = msg.Color;
                if (i != this._list.Count - 1)
                {
                    rtf.Text += ((doubleSpaced) ? "\r\n\r\n" : "\r\n");
                }
            }
            return rtf.Rtf;
        }
        protected void OnMessagesChanged(EventArgs e)
        {
            if (this.MessagesChanged != null)
            {
                this.MessagesChanged(this, e);
            }
        }
        #endregion
        #region 
        public bool HasMessages
        {
            get
            {
                return (this._list.Count > 0);
            }
        }
        #endregion
        #region 
        private ArrayList _list;
        #endregion
    }
}

