using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.IO;
using System.Windows.Forms;
using Volpe.Cafe;
namespace Volpe.Cafe.Ui.Panels
{
    public class OutputPanel : CafeUiPanel
    {
        #region 
        public OutputPanel()
        {
            this.InitializeComponent();
            this.InitializeControls();
            this.InitializeEventHandlers();
            this.SaveTextChanges();
            this._disableReportingOptions = false;
        }
        protected override void Dispose(bool disposing)
        {
            base.Dispose(disposing);
        }
        #endregion
        #region 
        #region 
        private void InitializeComponent()
        {
            this.ux_outputPathLabel = new System.Windows.Forms.Label();
            this.ux_outputPathTextBox = new System.Windows.Forms.TextBox();
            this.ux_outputPathLabelButton = new Volpe.Cafe.Ui.LabelButton();
            this.ux_reportingGroupBox = new System.Windows.Forms.GroupBox();
            this.ux_generateReportsCheckBox = new System.Windows.Forms.CheckBox();
            this.ux_generateOptimizedIndustryReportExtendedCheckBox = new System.Windows.Forms.CheckBox();
            this.ux_generateEnvironmentalAssessmentReportCheckBox = new System.Windows.Forms.CheckBox();
            this.ux_generateEffectsReportCheckBox = new System.Windows.Forms.CheckBox();
            this.ux_generateScenarioSummaryReportCheckBox = new System.Windows.Forms.CheckBox();
            this.ux_generateVehiclesReportCheckBox = new System.Windows.Forms.CheckBox();
            this.ux_generateManufacturersReportCheckBox = new System.Windows.Forms.CheckBox();
            this.ux_generateIndustryReportCheckBox = new System.Windows.Forms.CheckBox();
            this.ux_generateOtherReportsCheckBox = new System.Windows.Forms.CheckBox();
            this.ux_generateEmissionsReportsCheckBox = new System.Windows.Forms.CheckBox();
            this.ux_generateComplianceReportsCheckBox = new System.Windows.Forms.CheckBox();
            this.ux_reportingGroupBox.SuspendLayout();
            this.SuspendLayout();
            this.ux_outputPathLabel.AutoSize = true;
            this.ux_outputPathLabel.Location = new System.Drawing.Point(8, 8);
            this.ux_outputPathLabel.Name = "ux_outputPathLabel";
            this.ux_outputPathLabel.Size = new System.Drawing.Size(102, 17);
            this.ux_outputPathLabel.TabIndex = 0;
            this.ux_outputPathLabel.Text = "Select Output path:";
            this.ux_outputPathTextBox.Anchor = AnchorStyles.Top | AnchorStyles.Left | AnchorStyles.Right;
            this.ux_outputPathTextBox.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_outputPathTextBox.Location = new System.Drawing.Point(8, 24);
            this.ux_outputPathTextBox.Name = "ux_outputPathTextBox";
            this.ux_outputPathTextBox.Size = new System.Drawing.Size(312, 21);
            this.ux_outputPathTextBox.TabIndex = 1;
            this.ux_outputPathTextBox.Text = "";
            this.ux_outputPathTextBox.TextChanged += new System.EventHandler(this.OutputPathTextBox_TextChanged);
            this.ux_outputPathLabelButton.Anchor = AnchorStyles.Top | AnchorStyles.Right;
            this.ux_outputPathLabelButton.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_outputPathLabelButton.Location = new System.Drawing.Point(320, 22);
            this.ux_outputPathLabelButton.Name = "ux_outputPathLabelButton";
            this.ux_outputPathLabelButton.Size = new System.Drawing.Size(24, 24);
            this.ux_outputPathLabelButton.TabIndex = 2;
            this.ux_outputPathLabelButton.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.ux_outputPathLabelButton.Click += new System.EventHandler(this.OutputPathLabelButton_Click);
            this.ux_reportingGroupBox.Anchor = AnchorStyles.Top | AnchorStyles.Left | AnchorStyles.Right;
            this.ux_reportingGroupBox.Controls.Add(this.ux_generateOptimizedIndustryReportExtendedCheckBox);
            this.ux_reportingGroupBox.Controls.Add(this.ux_generateEnvironmentalAssessmentReportCheckBox);
            this.ux_reportingGroupBox.Controls.Add(this.ux_generateEffectsReportCheckBox);
            this.ux_reportingGroupBox.Controls.Add(this.ux_generateScenarioSummaryReportCheckBox);
            this.ux_reportingGroupBox.Controls.Add(this.ux_generateVehiclesReportCheckBox);
            this.ux_reportingGroupBox.Controls.Add(this.ux_generateManufacturersReportCheckBox);
            this.ux_reportingGroupBox.Controls.Add(this.ux_generateIndustryReportCheckBox);
            this.ux_reportingGroupBox.Controls.Add(this.ux_generateOtherReportsCheckBox);
            this.ux_reportingGroupBox.Controls.Add(this.ux_generateEmissionsReportsCheckBox);
            this.ux_reportingGroupBox.Controls.Add(this.ux_generateComplianceReportsCheckBox);
            this.ux_reportingGroupBox.Location = new System.Drawing.Point(0, 48);
            this.ux_reportingGroupBox.Name = "ux_reportingGroupBox";
            this.ux_reportingGroupBox.Size = new System.Drawing.Size(352, 104);
            this.ux_reportingGroupBox.TabIndex = 10;
            this.ux_reportingGroupBox.TabStop = false;
            this.ux_reportingGroupBox.Text = "Reporting";
            this.ux_generateReportsCheckBox.CheckAlign = System.Drawing.ContentAlignment.TopLeft;
            this.ux_generateReportsCheckBox.Location = new System.Drawing.Point(8, 48);
            this.ux_generateReportsCheckBox.Name = "ux_generateReportsCheckBox";
            this.ux_generateReportsCheckBox.Size = new System.Drawing.Size(152, 15);
            this.ux_generateReportsCheckBox.TabIndex = 9;
            this.ux_generateReportsCheckBox.Text = "Generate Output Reports";
            this.ux_generateOptimizedIndustryReportExtendedCheckBox.CheckAlign = System.Drawing.ContentAlignment.TopLeft;
            this.ux_generateOptimizedIndustryReportExtendedCheckBox.Location = new System.Drawing.Point(216, 32);
            this.ux_generateOptimizedIndustryReportExtendedCheckBox.Name = "ux_generateOptimizedIndustryReportExtendedCheckBox";
            this.ux_generateOptimizedIndustryReportExtendedCheckBox.Size = new System.Drawing.Size(128, 16);
            this.ux_generateOptimizedIndustryReportExtendedCheckBox.TabIndex = 11;
            this.ux_generateOptimizedIndustryReportExtendedCheckBox.Text = "Opt-Ind (Extended)";
            this.ux_generateEnvironmentalAssessmentReportCheckBox.CheckAlign = System.Drawing.ContentAlignment.TopLeft;
            this.ux_generateEnvironmentalAssessmentReportCheckBox.Location = new System.Drawing.Point(112, 48);
            this.ux_generateEnvironmentalAssessmentReportCheckBox.Name = "ux_generateEnvironmentalAssessmentReportCheckBox";
            this.ux_generateEnvironmentalAssessmentReportCheckBox.Size = new System.Drawing.Size(96, 32);
            this.ux_generateEnvironmentalAssessmentReportCheckBox.TabIndex = 7;
            this.ux_generateEnvironmentalAssessmentReportCheckBox.Text = "Environmental Assessment";
            this.ux_generateEffectsReportCheckBox.CheckAlign = System.Drawing.ContentAlignment.TopLeft;
            this.ux_generateEffectsReportCheckBox.Location = new System.Drawing.Point(112, 32);
            this.ux_generateEffectsReportCheckBox.Name = "ux_generateEffectsReportCheckBox";
            this.ux_generateEffectsReportCheckBox.Size = new System.Drawing.Size(96, 16);
            this.ux_generateEffectsReportCheckBox.TabIndex = 6;
            this.ux_generateEffectsReportCheckBox.Text = "Effects";
            this.ux_generateScenarioSummaryReportCheckBox.CheckAlign = System.Drawing.ContentAlignment.TopLeft;
            this.ux_generateScenarioSummaryReportCheckBox.Location = new System.Drawing.Point(8, 80);
            this.ux_generateScenarioSummaryReportCheckBox.Name = "ux_generateScenarioSummaryReportCheckBox";
            this.ux_generateScenarioSummaryReportCheckBox.Size = new System.Drawing.Size(120, 16);
            this.ux_generateScenarioSummaryReportCheckBox.TabIndex = 4;
            this.ux_generateScenarioSummaryReportCheckBox.Text = "Scenario Summary";
            this.ux_generateVehiclesReportCheckBox.CheckAlign = System.Drawing.ContentAlignment.TopLeft;
            this.ux_generateVehiclesReportCheckBox.Location = new System.Drawing.Point(8, 64);
            this.ux_generateVehiclesReportCheckBox.Name = "ux_generateVehiclesReportCheckBox";
            this.ux_generateVehiclesReportCheckBox.Size = new System.Drawing.Size(96, 16);
            this.ux_generateVehiclesReportCheckBox.TabIndex = 3;
            this.ux_generateVehiclesReportCheckBox.Text = "Vehicles";
            this.ux_generateManufacturersReportCheckBox.CheckAlign = System.Drawing.ContentAlignment.TopLeft;
            this.ux_generateManufacturersReportCheckBox.Location = new System.Drawing.Point(8, 48);
            this.ux_generateManufacturersReportCheckBox.Name = "ux_generateManufacturersReportCheckBox";
            this.ux_generateManufacturersReportCheckBox.Size = new System.Drawing.Size(96, 16);
            this.ux_generateManufacturersReportCheckBox.TabIndex = 2;
            this.ux_generateManufacturersReportCheckBox.Text = "Manufacturers";
            this.ux_generateIndustryReportCheckBox.CheckAlign = System.Drawing.ContentAlignment.TopLeft;
            this.ux_generateIndustryReportCheckBox.Location = new System.Drawing.Point(8, 32);
            this.ux_generateIndustryReportCheckBox.Name = "ux_generateIndustryReportCheckBox";
            this.ux_generateIndustryReportCheckBox.Size = new System.Drawing.Size(96, 16);
            this.ux_generateIndustryReportCheckBox.TabIndex = 1;
            this.ux_generateIndustryReportCheckBox.Text = "Industry";
            this.ux_generateOtherReportsCheckBox.CheckAlign = System.Drawing.ContentAlignment.TopLeft;
            this.ux_generateOtherReportsCheckBox.Location = new System.Drawing.Point(216, 16);
            this.ux_generateOtherReportsCheckBox.Name = "ux_generateOtherReportsCheckBox";
            this.ux_generateOtherReportsCheckBox.Size = new System.Drawing.Size(56, 16);
            this.ux_generateOtherReportsCheckBox.TabIndex = 8;
            this.ux_generateOtherReportsCheckBox.Text = "Other";
            this.ux_generateEmissionsReportsCheckBox.CheckAlign = System.Drawing.ContentAlignment.TopLeft;
            this.ux_generateEmissionsReportsCheckBox.Location = new System.Drawing.Point(112, 16);
            this.ux_generateEmissionsReportsCheckBox.Name = "ux_generateEmissionsReportsCheckBox";
            this.ux_generateEmissionsReportsCheckBox.Size = new System.Drawing.Size(72, 16);
            this.ux_generateEmissionsReportsCheckBox.TabIndex = 5;
            this.ux_generateEmissionsReportsCheckBox.Text = "Emissions";
            this.ux_generateComplianceReportsCheckBox.CheckAlign = System.Drawing.ContentAlignment.TopLeft;
            this.ux_generateComplianceReportsCheckBox.Location = new System.Drawing.Point(8, 16);
            this.ux_generateComplianceReportsCheckBox.Name = "ux_generateComplianceReportsCheckBox";
            this.ux_generateComplianceReportsCheckBox.Size = new System.Drawing.Size(88, 16);
            this.ux_generateComplianceReportsCheckBox.TabIndex = 0;
            this.ux_generateComplianceReportsCheckBox.Text = "Compliance";
            this.Controls.AddRange(
                new Control[] {
                                  this.ux_outputPathTextBox,
                                  this.ux_outputPathLabel,
                                  this.ux_outputPathLabelButton,
                                  this.ux_generateReportsCheckBox,
                                  this.ux_reportingGroupBox
                              });
            this.AutoScroll = true;
            this.DisableReportingOptions = false;
            this.Location = new Point(0, 0);
            this.Name = "OutputPanel";
            this.Size = new Size(352, 216);
            this.ux_reportingGroupBox.ResumeLayout(false);
            this.ResumeLayout(false);
        }
        #endregion
        #region 
        private void InitializeControls()
        {
            this.ux_generateReportsCheckBox.Checked = true;
        }
        private void InitializeEventHandlers()
        {
            this.InitializeCheckBoxes(this.ux_generateComplianceReportsCheckBox,
                new CheckBox[] {
                                   this.ux_generateIndustryReportCheckBox,
                                   this.ux_generateManufacturersReportCheckBox,
                                   this.ux_generateVehiclesReportCheckBox,
                                   this.ux_generateScenarioSummaryReportCheckBox
                               });
            this.InitializeCheckBoxes(this.ux_generateEmissionsReportsCheckBox,
                new CheckBox[] {
                                   this.ux_generateEffectsReportCheckBox,
                                   this.ux_generateEnvironmentalAssessmentReportCheckBox
                               });
            this.InitializeCheckBoxes(this.ux_generateOtherReportsCheckBox,
                new CheckBox[] {
                                   this.ux_generateOptimizedIndustryReportExtendedCheckBox
                               });
            this.ux_generateReportsCheckBox.CheckedChanged += new EventHandler(this.CheckChangesDetector);
            this.ux_generateReportsCheckBox.CheckedChanged += new EventHandler(this.GenerateReportsCheckBox_CheckedChanged);
        }
        private void InitializeTextBoxDragDrop(params TextBox[] values)
        {
            for (int i = 0; i < values.Length; i++)
            {
                values[i].AllowDrop = true;
                values[i].DragEnter += new DragEventHandler(this.ManageOutput_DragEnter);
                values[i].DragDrop += new DragEventHandler(this.ManageOutput_DragDrop);
            }
        }
        private void SaveTextChanges()
        {
            this._textChanges = new object[1];
            this._textChanges[0] = (string)this.ux_outputPathTextBox.Text;
        }
        #endregion
        #region 
        private void ManageOutput_DragEnter(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent(DataFormats.FileDrop, false))
            {
                e.Effect = DragDropEffects.All;
            }
        }
        private void ManageOutput_DragDrop(object sender, DragEventArgs e)
        {
            TextBox tb = (TextBox)sender;
            string[] files = (string[])e.Data.GetData(DataFormats.FileDrop, false);
            for (int i = 0; i < files.Length; i++)
            {
                if (Directory.Exists(files[i]))
                {
                    tb.Text = files[i];
                    break;
                }
            }
        }
        private void OutputPathTextBox_TextChanged(object sender, System.EventArgs e)
        {
            TextBox tb = (TextBox)sender;
            int type = 0;
            if (Directory.Exists(tb.Text))
            {
                bool textChanged = !this.ComparePaths((string)this._textChanges[type], tb.Text);
                if (this._visualTracking && textChanged)
                {
                    tb.ForeColor = this._visualTrackingColor;
                }
                else
                {
                    tb.ForeColor = Color.Black;
                    tb.Font = this.Font;
                }
                tb.BackColor = Color.White;
                this._messages.RemoveMessage(tb);
            }
            else
            {
                string[] names = {"Output Path", "Logs Path", "Templates File"};
                this._messages.AddMessage("The specified " + names[type] +
                    " does not exist on disk.", Color.Red, tb);
                tb.BackColor = Color.LightYellow;
                tb.ForeColor = Color.Red;
                tb.Font = this.Font;
            }
        }
        private void OutputPathLabelButton_Click(object sender, System.EventArgs e)
        {
            TextBox txt = (TextBox)((LabelButton)sender).Tag;
            FolderBrowserDialog fbd = new FolderBrowserDialog();
            fbd.ShowNewFolderButton = true;
            fbd.SelectedPath = Directory.Exists(txt.Text) ? txt.Text : "";
            if (fbd.ShowDialog() == DialogResult.OK)
            {
                txt.Text = fbd.SelectedPath;
            }
        }
        private void OutputFileLabelButton_Click(object sender, System.EventArgs e)
        {
            TextBox txt = (TextBox)((LabelButton)sender).Tag;
            OpenFileDialog ofd = new OpenFileDialog();
            ofd.Filter = "All Files (*.*)|*.*|All Microsoft Excel Files (*.xl*)|*.xl*|" +
                "Microsoft Excel Workbook Files (*.xls)|*.xls";
            ofd.FilterIndex = 3;
            ofd.Multiselect = false;
            ofd.FileName = File.Exists(txt.Text) ? txt.Text : "";
            if (ofd.ShowDialog() == DialogResult.OK)
            {
                txt.Text = ofd.FileName;
            }
        }
        private void GenerateReportsCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            this.ux_reportingGroupBox.Visible = this.ux_generateReportsCheckBox.Visible &&
                this.ux_generateReportsCheckBox.Checked;
        }
        #endregion
        private bool ComparePaths(string path1, string path2)
        {
            path1 = path1.TrimEnd('\\');
            path2 = path2.TrimEnd('\\');
            path1 = (Directory.Exists(path1) || File.Exists(path1)) ?
                Path.GetFullPath(path1) : path1;
            path2 = (Directory.Exists(path2) || File.Exists(path2)) ?
                Path.GetFullPath(path2) : path2;
            return (path1 == path2);
        }
        public void SetInitialState(OutputSettings outputSettings)
        {
            this._outputSettings = outputSettings;
            bool vt = this._visualTracking;
            this._visualTracking = false;
            this.ux_outputPathLabelButton.ThemeInitialize("config-files", false);
            this.ux_outputPathLabelButton.Tag = this.ux_outputPathTextBox;
            if (Cafe2d.Settings.DragAndDrop == TriState.Enabled)
            {
                this.InitializeTextBoxDragDrop(this.ux_outputPathTextBox);
            }
            this.ux_outputPathTextBox.Text = (Directory.Exists(this._outputSettings.OutputPath)) ?
                Path.GetFullPath(this._outputSettings.OutputPath) : string.Empty;
            this.ux_generateReportsCheckBox.Checked = this._outputSettings.GenerateReports;
            this.ux_generateIndustryReportCheckBox.Checked = this._outputSettings.GenerateIndustryReport;
            this.ux_generateManufacturersReportCheckBox.Checked = this._outputSettings.GenerateManufacturersReport;
            this.ux_generateVehiclesReportCheckBox.Checked = this._outputSettings.GenerateVehiclesReport;
            this.ux_generateScenarioSummaryReportCheckBox.Checked = this._outputSettings.GenerateScenarioSummaryReport;
            this.ux_generateEffectsReportCheckBox.Checked = this._outputSettings.GenerateEffectsReport;
            this.ux_generateEnvironmentalAssessmentReportCheckBox.Checked = this._outputSettings.GenerateEnvironmentalAssessmentReport;
            this.ux_generateOptimizedIndustryReportExtendedCheckBox.Checked = this._outputSettings.GenerateOptimizedIndustryReportExtended;
            this._visualTracking = vt;
            this.SaveTextChanges();
            this._checkChanges.Clear();
        }
        public override void SaveChanges()
        {
            if (this.SettingsChanged)
            {
                this._outputSettings.OutputPath = Path.GetFullPath(this.ux_outputPathTextBox.Text);
                this._outputSettings.GenerateReports = this.ux_generateReportsCheckBox.Checked;
                this._outputSettings.GenerateIndustryReport = this.ux_generateIndustryReportCheckBox.Checked;
                this._outputSettings.GenerateManufacturersReport = this.ux_generateManufacturersReportCheckBox.Checked;
                this._outputSettings.GenerateVehiclesReport = this.ux_generateVehiclesReportCheckBox.Checked;
                this._outputSettings.GenerateScenarioSummaryReport = this.ux_generateScenarioSummaryReportCheckBox.Checked;
                this._outputSettings.GenerateEffectsReport = this.ux_generateEffectsReportCheckBox.Checked;
                this._outputSettings.GenerateEnvironmentalAssessmentReport = this.ux_generateEnvironmentalAssessmentReportCheckBox.Checked;
                this._outputSettings.GenerateOptimizedIndustryReportExtended = this.ux_generateOptimizedIndustryReportExtendedCheckBox.Checked;
                if (this._visualTracking)
                {   
                    Color color = Control.DefaultForeColor;
                    this.ux_outputPathTextBox.ForeColor = color;
                    this.ux_generateReportsCheckBox.ForeColor = color;
                    this.ux_generateComplianceReportsCheckBox.ForeColor = color;
                    this.ux_generateIndustryReportCheckBox.ForeColor = color;
                    this.ux_generateManufacturersReportCheckBox.ForeColor = color;
                    this.ux_generateVehiclesReportCheckBox.ForeColor = color;
                    this.ux_generateScenarioSummaryReportCheckBox.ForeColor = color;
                    this.ux_generateEmissionsReportsCheckBox.ForeColor = color;
                    this.ux_generateIndustryReportCheckBox.ForeColor = color;
                    this.ux_generateEffectsReportCheckBox.ForeColor = color;
                    this.ux_generateEnvironmentalAssessmentReportCheckBox.ForeColor = color;
                    this.ux_generateOtherReportsCheckBox.ForeColor = color;
                    this.ux_generateOptimizedIndustryReportExtendedCheckBox.ForeColor = color;
                }
                this.SaveTextChanges();
                this._checkChanges.Clear();
            }
        }
        #endregion
        #region 
        [Browsable(false)]
        public override bool SettingsChanged
        {
            get
            {
                bool pathsExist = Directory.Exists(this.ux_outputPathTextBox.Text);
                bool textChanged = !this.ComparePaths((string)this._textChanges[0], this.ux_outputPathTextBox.Text);
                return (pathsExist && (textChanged || base.SettingsChanged));
            }
        }
        [Browsable(false)]
        public OutputSettings OutputSettings
        {
            get
            {
                return this._outputSettings;
            }
        }
        [Browsable(true)]
        [Category("Behavior")]
        [DefaultValue(false)]
        [Description("Specifies whether the reporting options are visible.")]
        public bool DisableReportingOptions
        {
            get
            {
                return this._disableReportingOptions;
            }
            set
            {
                this._disableReportingOptions = value;
                this.ux_generateReportsCheckBox.Visible = !value;
                this.ux_generateReportsCheckBox.Checked = !value;
                this.ux_reportingGroupBox.Visible = !value;
            }
        }
        #endregion
        #region 
        #region 
        private System.Windows.Forms.Label ux_outputPathLabel;
        private System.Windows.Forms.TextBox ux_outputPathTextBox;
        private Volpe.Cafe.Ui.LabelButton ux_outputPathLabelButton;
        private System.Windows.Forms.GroupBox ux_reportingGroupBox;
        private System.Windows.Forms.CheckBox ux_generateReportsCheckBox;
        private System.Windows.Forms.CheckBox ux_generateOptimizedIndustryReportExtendedCheckBox;
        private System.Windows.Forms.CheckBox ux_generateEnvironmentalAssessmentReportCheckBox;
        private System.Windows.Forms.CheckBox ux_generateEffectsReportCheckBox;
        private System.Windows.Forms.CheckBox ux_generateScenarioSummaryReportCheckBox;
        private System.Windows.Forms.CheckBox ux_generateVehiclesReportCheckBox;
        private System.Windows.Forms.CheckBox ux_generateManufacturersReportCheckBox;
        private System.Windows.Forms.CheckBox ux_generateIndustryReportCheckBox;
        private System.Windows.Forms.CheckBox ux_generateOtherReportsCheckBox;
        private System.Windows.Forms.CheckBox ux_generateEmissionsReportsCheckBox;
        private System.Windows.Forms.CheckBox ux_generateComplianceReportsCheckBox;
        #endregion
        private OutputSettings _outputSettings;
        private object[] _textChanges;
        private bool _disableReportingOptions;
        #endregion
    }
}

