using System;
namespace Volpe.Cafe.Ui
{
    public struct ThemeDescription
    {
        public void Reset()
        {
            this.Name = "";
            this.Description = "";
            this.SessionNew = this.SessionOpen = this.SessionSave =
                this.ConfigFiles = this.ConfigSettings =
                this.ModelStart = this.ModelCancel =
                this.Back = this.Forward =
                this.Ok = this.Cancel = null;
            this.x22 = this.x32 = this.x48 = "";
            this.BaseSmall = this.BaseLarge = this.AltSmall = this.AltLarge = "";
        }
        public bool Verify(out string results)
        {
            bool verified = true;
            results = "";
            if (this.Name.Trim() == "")
            {
                results += "Theme name not specified.\r\n";
                verified = false;
            }
            bool scaling = !(this.x22 == "" && this.x32 == "");
            bool rollover = !(this.BaseSmall == "" && this.BaseLarge == "" &&
                this.AltSmall == "" && this.AltLarge == "");
            if (!scaling && !rollover)
            {
                results += "Path info is missing or invalid.\r\n";
                verified = false;
            }
            if (this.SessionNew == null || this.SessionNew.Length < 1)
            {
                results += "Missing \"session-new\" image.\r\n";
                verified = false;
            }
            if (this.SessionOpen == null || this.SessionOpen.Length < 1)
            {
                results += "Missing \"session-open\" image.\r\n";
                verified = false;
            }
            if (this.SessionSave == null || this.SessionSave.Length < 1)
            {
                results += "Missing \"session-save\" image.\r\n";
                verified = false;
            }
            if (this.ConfigFiles == null || this.ConfigFiles.Length < 1)
            {
                results += "Missing \"config-files\" image.\r\n";
                verified = false;
            }
            if (this.ConfigSettings == null || this.ConfigSettings.Length < 1)
            {
                results += "Missing \"config-settings\" image.\r\n";
                verified = false;
            }
            if (this.ModelStart == null || this.ModelStart.Length < 1)
            {
                results += "Missing \"model-start\" image.\r\n";
                verified = false;
            }
            if (this.ModelCancel == null || this.ModelCancel.Length < 1)
            {
                results += "Missing \"model-cancel\" image.\r\n";
                verified = false;
            }
            if (this.Back == null || this.Back.Length < 1)
            {
                results += "Missing \"back\" image.\r\n";
                verified = false;
            }
            if (this.Forward == null || this.Forward.Length < 1)
            {
                results += "Missing \"forward\" image.\r\n";
                verified = false;
            }
            if (this.Ok == null || this.Ok.Length < 1)
            {
                results += "Missing \"ok\" image.\r\n";
                verified = false;
            }
            if (this.Cancel == null || this.Cancel.Length < 1)
            {
                results += "Missing \"cancel\" image.\r\n";
                verified = false;
            }
            return verified;
        }
        public string Name;
        public string Description;
        public string[] SessionNew,
                        SessionOpen,
                        SessionSave,
                        ConfigFiles,
                        ConfigSettings,
                        ModelStart,
                        ModelCancel,
                        Back,
                        Forward,
                        Ok,
                        Cancel;
        public string x22, x32, x48;
        public string BaseSmall, BaseLarge, AltSmall, AltLarge;
    }
}

