using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using Volpe.Cafe;
using Volpe.Cafe.Ui.Panels;
namespace Volpe.Cafe.Ui.Wizards
{
    internal class NSW_SelectInputFiles : Panel
    {
        #region 
        public NSW_SelectInputFiles()
        {
            this.InitializeComponent();
        }
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (this.components != null)
                {
                    this.components.Dispose();
                }
            }
            base.Dispose(disposing);
        }
        #endregion
        #region 
        private void InitializeComponent()
        {
            this.ux_bodyLabel = new System.Windows.Forms.Label();
            this.ux_inputPanel = new Volpe.Cafe.Ui.Panels.InputPanel();
            this.ux_statusTextBox = new System.Windows.Forms.RichTextBox();
            this.SuspendLayout();
            this.ux_bodyLabel.Location = new System.Drawing.Point(8, 8);
            this.ux_bodyLabel.Name = "ux_bodyLabel";
            this.ux_bodyLabel.Size = new System.Drawing.Size(408, 32);
            this.ux_bodyLabel.TabIndex = 0;
            this.ux_bodyLabel.Text = "This screen allows you to select and load the Excel data files, which contain veh" +
                "icle manufacturer data, as well as core modeling configuration files.";
            this.ux_inputPanel.ReloadFromDisk = true;
            this.ux_inputPanel.Location = new System.Drawing.Point(8, 40);
            this.ux_inputPanel.Name = "ux_inputPanel";
            this.ux_inputPanel.Size = new System.Drawing.Size(400, 216);
            this.ux_inputPanel.TabIndex = 1;
            this.ux_statusTextBox.BackColor = System.Drawing.SystemColors.Control;
            this.ux_statusTextBox.BorderStyle = System.Windows.Forms.BorderStyle.None;
            this.ux_statusTextBox.ForeColor = System.Drawing.Color.Black;
            this.ux_statusTextBox.Location = new System.Drawing.Point(16, 248);
            this.ux_statusTextBox.Name = "ux_statusTextBox";
            this.ux_statusTextBox.ReadOnly = true;
            this.ux_statusTextBox.ScrollBars = System.Windows.Forms.RichTextBoxScrollBars.Vertical;
            this.ux_statusTextBox.Size = new System.Drawing.Size(360, 64);
            this.ux_statusTextBox.TabIndex = 2;
            this.ux_statusTextBox.TabStop = false;
            this.ux_statusTextBox.Text = "Ready.";
            this.Controls.AddRange(
                new Control[] {
                                  this.ux_bodyLabel,
                                  this.ux_statusTextBox,
                                  this.ux_inputPanel
                              });
            this.Name = "NSW_SelectInputFiles";
            this.Size = new System.Drawing.Size(416, 335);
            this.ResumeLayout(false);
        }
        private void Messages_MessagesChanged(object sender, EventArgs e)
        {
            this.Messages_MessagesChanged_InvokeHelper();
        }
        private void Messages_MessagesChanged_InvokeHelper()
        {
            if (this.ux_statusTextBox.InvokeRequired)
            {
                this.ux_statusTextBox.Invoke(new EmptyEventHandler(this.Messages_MessagesChanged_InvokeHelper));
            }
            else
            {
                this.ux_statusTextBox.Rtf = this.ux_inputPanel.Messages.ToString();
                this.ux_statusTextBox.Enabled = this.ux_statusTextBox.Text != "";
            }
        }
        public void SetInitialState(ModelingSettings modelingSettings, string inputPassword)
        {
            this.ux_inputPanel.SetInitialState(modelingSettings.InputSettings, inputPassword);
            this.ux_inputPanel.Messages.MessagesChanged += new EventHandler(Messages_MessagesChanged);
        }
        public void UpdatePassword(string inputPassword)
        {
            this.ux_inputPanel.UpdatePassword(inputPassword);
        }
        #endregion
        #region 
        public InputPanel InputPanel
        {
            get
            {
                return this.ux_inputPanel;
            }
        }
        #endregion
        #region 
        #region 
        private System.Windows.Forms.Label ux_bodyLabel;
        private Volpe.Cafe.Ui.Panels.InputPanel ux_inputPanel;
        private System.Windows.Forms.RichTextBox ux_statusTextBox;
        protected System.ComponentModel.IContainer components = null;
        #endregion
        #endregion
    }
}

