using System;
using System.Collections;
using Volpe.Cafe.Data;
namespace Volpe.Cafe.Collections
{
    [Serializable]
    public sealed class EngineCollection : CollectionBase, ICloneable
    {
        #region 
        public EngineCollection() : base()
        {
        }
        public EngineCollection(int capacity) : base()
        {
            this.InnerList.Capacity = capacity;
        }
        #endregion
        #region 
        public int Add(Engine value)
        {
            return this.InnerList.Add(value);
        }
        public void AddRange(ICollection values)
        {
            this.InnerList.AddRange(values);
        }
        public void Insert(int index, Engine value)
        {
            this.InnerList.Insert(index, value);
        }
        public void InsertRange(int index, ICollection values)
        {
            this.InnerList.InsertRange(index, values);
        }
        public void Remove(Engine value)
        {
            this.InnerList.Remove(value);
        }
        public new void RemoveAt(int index)
        {
            base.RemoveAt(index);
        }
        public new void Clear()
        {
            base.Clear();
        }
        public bool Contains(Engine value)
        {
            return this.InnerList.Contains(value);
        }
        public int IndexOf(Engine value)
        {
            return this.InnerList.IndexOf(value);
        }
        public int IndexOf(Engine value, int startIndex)
        {
            return this.InnerList.IndexOf(value, startIndex);
        }
        public int IndexOf(Engine value, int startIndex, int count)
        {
            return this.InnerList.IndexOf(value, startIndex, count);
        }
        public int IndexOf(int engineCode)
        {
            for (int i = 0; i < this.Count; i++)
            {
                if (this[i].Description.Code == engineCode) { return i; }
            }
            return -1;
        }
        public void CopyTo(Engine[] array)
        {
            this.CopyTo(array, 0);
        }
        public void CopyTo(Engine[] array, int index)
        {
            this.InnerList.CopyTo(array, index);
        }
        public Engine[] ToArray()
        {
            Engine[] array = new Engine[this.Count];
            this.CopyTo(array, 0);
            return array;
        }
        public new IEnumerator GetEnumerator()
        {
            return base.GetEnumerator();
        }
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        public EngineCollection Clone()
        {
            EngineCollection newCollection = new EngineCollection(this.Count);
            for (int i = 0; i < this.Count; i++)
            {
                newCollection.Add((Engine)(this[i].Clone()));
            }
            return newCollection;
        }
        #endregion
        #endregion
        #region 
        public Engine this[int index]
        {
            get { return (Engine)(this.InnerList[index]); }
            set { this.InnerList[index] = value; }
        }
        public new int Count { get { return base.Count; } }
        public int Capacity
        {
            get { return this.InnerList.Capacity; }
            set { this.InnerList.Capacity = value; }
        }
        public bool IsReadOnly { get { return this.InnerList.IsReadOnly; } }
        public bool IsFixedSize { get { return this.InnerList.IsFixedSize; } }
        public bool IsSynchronized { get { return this.InnerList.IsSynchronized; } }
        public object SyncRoot { get { return this.InnerList.SyncRoot; } }
        #endregion
    }
}

