using System;
using System.Collections;
using Volpe.Cafe;
namespace Volpe.Cafe.Collections
{
    [Serializable]
    public sealed class ScenarioCollection : CollectionBase, ICloneable
    {
        #region 
        public ScenarioCollection() : base()
        {
        }
        public ScenarioCollection(int capacity) : base()
        {
            this.InnerList.Capacity = capacity;
        }
        #endregion
        #region 
        public int Add(Scenario value)
        {
            return this.InnerList.Add(value);
        }
        public void AddRange(ICollection values)
        {
            this.InnerList.AddRange(values);
        }
        public void Insert(int index, Scenario value)
        {
            this.InnerList.Insert(index, value);
        }
        public void InsertRange(int index, ICollection values)
        {
            this.InnerList.InsertRange(index, values);
        }
        public void Remove(Scenario value)
        {
            this.InnerList.Remove(value);
        }
        public new void RemoveAt(int index)
        {
            base.RemoveAt(index);
        }
        public new void Clear()
        {
            base.Clear();
        }
        public bool Contains(Scenario value)
        {
            return this.InnerList.Contains(value);
        }
        public int IndexOf(Scenario value)
        {
            return this.InnerList.IndexOf(value);
        }
        public int IndexOf(Scenario value, int startIndex)
        {
            return this.InnerList.IndexOf(value, startIndex);
        }
        public int IndexOf(Scenario value, int startIndex, int count)
        {
            return this.InnerList.IndexOf(value, startIndex, count);
        }
        public void CopyTo(Scenario[] array)
        {
            this.CopyTo(array, 0);
        }
        public void CopyTo(Scenario[] array, int index)
        {
            this.InnerList.CopyTo(array, index);
        }
        public Scenario[] ToArray()
        {
            Scenario[] array = new Scenario[this.Count];
            this.CopyTo(array, 0);
            return array;
        }
        public new IEnumerator GetEnumerator()
        {
            return base.GetEnumerator();
        }
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        public ScenarioCollection Clone()
        {
            ScenarioCollection newCollection = new ScenarioCollection(this.Count);
            for (int i = 0; i < this.Count; i++)
            {
                newCollection.Add((Scenario)(this[i].Clone()));
            }
            return newCollection;
        }
        #endregion
        #endregion
        #region 
        public Scenario this[int index]
        {
            get { return (Scenario)(this.InnerList[index]); }
            set { this.InnerList[index] = value; }
        }
        public new int Count { get { return base.Count; } }
        public int Capacity
        {
            get { return this.InnerList.Capacity; }
            set { this.InnerList.Capacity = value; }
        }
        public bool IsReadOnly { get { return this.InnerList.IsReadOnly; } }
        public bool IsFixedSize { get { return this.InnerList.IsFixedSize; } }
        public bool IsSynchronized { get { return this.InnerList.IsSynchronized; } }
        public object SyncRoot { get { return this.InnerList.SyncRoot; } }
        #endregion
    }
}

