using System;
using System.Collections;
using Volpe.Cafe.Data;
namespace Volpe.Cafe.Collections
{
    [Serializable]
    public sealed class VehicleCollection : CollectionBase, ICloneable
    {
        #region 
        public VehicleCollection() : base()
        {
        }
        public VehicleCollection(int capacity) : base()
        {
            this.InnerList.Capacity = capacity;
        }
        public VehicleCollection(ICollection values) : this(values.Count)
        {
            this.AddRange(values);
        }
        #endregion
        #region 
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        public VehicleCollection Clone()
        {
            VehicleCollection newCollection = new VehicleCollection(this.Count);
            for (int i = 0; i < this.Count; i++)
            {
                newCollection.Add((Vehicle)(this[i].Clone()));
            }
            return newCollection;
        }
        #endregion
        public int Add(Vehicle value)
        {
            return this.InnerList.Add(value);
        }
        public void AddRange(ICollection values)
        {
            this.InnerList.AddRange(values);
        }
        public void Insert(int index, Vehicle value)
        {
            this.InnerList.Insert(index, value);
        }
        public void InsertRange(int index, ICollection values)
        {
            this.InnerList.InsertRange(index, values);
        }
        public void Remove(Vehicle value)
        {
            this.InnerList.Remove(value);
        }
        public void RemoveRange(VehicleCollection values)
        {
            this.RemoveRange(values.ToArray());
        }
        public void RemoveRange(Vehicle[] values)
        {
            if (values != null)
            {
                for (int i = 0; i < values.Length ; i++)
                {
                    this.Remove(values[i]);
                }
            }
        }
        public new void RemoveAt(int index)
        {
            base.RemoveAt(index);
        }
        public new void Clear()
        {
            base.Clear();
        }
        public bool Contains(Vehicle value)
        {
            return this.InnerList.Contains(value);
        }
        public int IndexOf(Vehicle value)
        {
            return this.InnerList.IndexOf(value);
        }
        public int IndexOf(Vehicle value, int startIndex)
        {
            return this.InnerList.IndexOf(value, startIndex);
        }
        public int IndexOf(Vehicle value, int startIndex, int count)
        {
            return this.InnerList.IndexOf(value, startIndex, count);
        }
        public int IndexOf(int vehicleCode)
        {
            for (int i = 0; i < this.Count; i++)
            {
                if (this[i].Description.Code == vehicleCode) { return i; }
            }
            return -1;
        }
        public void CopyTo(Vehicle[] array)
        {
            this.CopyTo(array, 0);
        }
        public void CopyTo(Vehicle[] array, int index)
        {
            this.InnerList.CopyTo(array, index);
        }
        public Vehicle[] ToArray()
        {
            Vehicle[] array = new Vehicle[this.Count];
            this.CopyTo(array, 0);
            return array;
        }
        public new IEnumerator GetEnumerator()
        {
            return base.GetEnumerator();
        }
        public VehicleCollection GetModelYearVehicles(ModelYear year)
        {
            VehicleCollection vc = new VehicleCollection(this.Count);
            for (int i = 0; i < this.InnerList.Count; i++)
            {
                if (this[i].IsValid(year))
                {
                    vc.Add(this[i]);
                }
            }
            return vc;
        }
        public VehicleCollection GetRegClassVehicles(RegulatoryClass regClass)
        {
            int vehCount = this.InnerList.Count;
            VehicleCollection vc = new VehicleCollection(vehCount);
            for (int i = 0; i < vehCount; i++)
            {
                if (this[i].RegClass == regClass)
                {
                    vc.Add(this[i]);
                }
            }
            return vc;
        }
        public Vehicle FindByCode(int vehCode)
        {
            ArrayList list = this.InnerList;
            for (int i = 0, count = list.Count; i < count; i++)
            {
                if (((Vehicle)list[i]).Description.Code == vehCode) { return (Vehicle)list[i]; }
            }
            return null;
        }
        #endregion
        #region 
        public Vehicle this[int index]
        {
            get { return (Vehicle)(this.InnerList[index]); }
            set { this.InnerList[index] = value; }
        }
        public bool HasAutosOrLts
        {
            get
            {
                for (int i = 0, vehCount = this.InnerList.Count; i < vehCount; i++)
                {
                    if (this[i].RegClass != RegulatoryClass.Unregulated)
                    {
                        return true;
                    }
                }
                return false;
            }
        }
        public bool HasAutos
        {
            get
            {
                for (int i = 0, vehCount = this.InnerList.Count; i < vehCount; i++)
                {
                    if (this[i].RegClass == RegulatoryClass.DomesticAuto || this[i].RegClass == RegulatoryClass.ImportedAuto)
                    {
                        return true;
                    }
                }
                return false;
            }
        }
        public bool HasLts
        {
            get
            {
                for (int i = 0, vehCount = this.InnerList.Count; i < vehCount; i++)
                {
                    if (this[i].RegClass == RegulatoryClass.LightTruck)
                    {
                        return true;
                    }
                }
                return false;
            }
        }
        public bool HasMultRegClass
        {
            get
            {
                byte mixed = 0;
                for (int i = 0, vehCount = this.InnerList.Count; i < vehCount; i++)
                {
                    RegulatoryClass regClass = this[i].RegClass;
                    if      (regClass == RegulatoryClass.DomesticAuto) { mixed |= 1; }
                    else if (regClass == RegulatoryClass.ImportedAuto) { mixed |= 2; }
                    else if (regClass == RegulatoryClass.LightTruck  ) { mixed |= 4; }
                    if (mixed > 4 || mixed == 3) { return true; }
                }
                return false;
            }
        }
        public VehicleCollection PassengerAutomobiles
        {
            get
            {
                int vehCount = this.InnerList.Count;
                VehicleCollection vc = new VehicleCollection(vehCount);
                for (int i = 0; i < vehCount; i++)
                {
                    if (this[i].RegClass == RegulatoryClass.DomesticAuto ||
                        this[i].RegClass == RegulatoryClass.ImportedAuto)
                    {
                        vc.Add(this[i]);
                    }
                }
                return vc;
            }
        }
        public VehicleCollection LightTrucks { get { return this.GetRegClassVehicles(RegulatoryClass.LightTruck); } }
        public int PassengerAutomobileCount
        {
            get
            {
                int count = 0;
                for (int i = 0, vehCount = this.InnerList.Count; i < vehCount; i++)
                {
                    if (this[i].RegClass == RegulatoryClass.DomesticAuto || this[i].RegClass == RegulatoryClass.ImportedAuto)
                    {
                        count++;
                    }
                }
                return count;
            }
        }
        public int PassengerAutomobileOutlierCount
        {
            get
            {
                int count = 0;
                for (int i = 0, vehCount = this.InnerList.Count; i < vehCount; i++)
                {
                    if (this[i].Description.Outlier &&
                        (this[i].RegClass == RegulatoryClass.DomesticAuto || this[i].RegClass == RegulatoryClass.ImportedAuto))
                    {
                        count++;
                    }
                }
                return count;
            }
        }
        public int PassengerAutomobileNonOutlierCount
        {
            get
            {
                int count = 0;
                for (int i = 0, vehCount = this.InnerList.Count; i < vehCount; i++)
                {
                    if (!this[i].Description.Outlier &&
                        (this[i].RegClass == RegulatoryClass.DomesticAuto || this[i].RegClass == RegulatoryClass.ImportedAuto))
                    {
                        count++;
                    }
                }
                return count;
            }
        }
        public int LightTruckCount
        {
            get
            {
                int count = 0;
                for (int i = 0, vehCount = this.InnerList.Count; i < vehCount; i++)
                {
                    if (this[i].RegClass == RegulatoryClass.LightTruck)
                    {
                        count++;
                    }
                }
                return count;
            }
        }
        public int LightTruckOutlierCount
        {
            get
            {
                int count = 0;
                for (int i = 0, vehCount = this.InnerList.Count; i < vehCount; i++)
                {
                    if (this[i].Description.Outlier && this[i].RegClass == RegulatoryClass.LightTruck)
                    {
                        count++;
                    }
                }
                return count;
            }
        }
        public int LightTruckNonOutlierCount
        {
            get
            {
                int count = 0;
                for (int i = 0, vehCount = this.InnerList.Count; i < vehCount; i++)
                {
                    if (!this[i].Description.Outlier && this[i].RegClass == RegulatoryClass.LightTruck)
                    {
                        count++;
                    }
                }
                return count;
            }
        }
        public new int Count { get { return base.Count; } }
        public int Capacity
        {
            get { return this.InnerList.Capacity; }
            set { this.InnerList.Capacity = value; }
        }
        public bool IsReadOnly { get { return this.InnerList.IsReadOnly; } }
        public bool IsFixedSize { get { return this.InnerList.IsFixedSize; } }
        public bool IsSynchronized { get { return this.InnerList.IsSynchronized; } }
        public object SyncRoot { get { return this.InnerList.SyncRoot; } }
        #endregion
    }
}

