using System;
using Volpe.Cafe.Data;
namespace Volpe.Cafe
{
    [Serializable]
    public class KMYType : ICloneable
    {
        #region 
        private KMYType()
        {
        }
        KMYType(ModelYear modelYear, Parameters parameters, Estimates priceEstimates, Manufacturer manufacturer)
        {
            this._modelYear = modelYear;
            this._gasoline  = 0;
            this._diesel    = 0;
            Parameters.EconomicDataValues   econValues    = parameters.EconomicValues;
            Parameters.VehicleSurvivability survivability = parameters.Survivability;
            Parameters.MilesDriven          milesDriven   = parameters.VehicleMilesDriven;
            double[] autoMiles   = milesDriven.GetAutomobileMilesDriven(priceEstimates);
            double[] pickupMiles = milesDriven.GetPickupMilesDriven    (priceEstimates);
            double[] vanMiles    = milesDriven.GetVanMilesDriven       (priceEstimates);
            double[] suvMiles    = milesDriven.GetSuvMilesDriven       (priceEstimates);
            double discRate = manufacturer.Description.DiscountRate;
            int    payback  = (int)Math.Floor(econValues.PaybackPeriod);
            double fract    = econValues.PaybackPeriod - payback;    
            double[] gasPrices      = parameters.ForecastData.GasolineFuelPrice;
            double[] dieselPrices   = parameters.ForecastData.DieselFuelPrice;
            double[] e85Prices      = parameters.ForecastData.E85FuelPrice;
            double[] cngPrices      = parameters.ForecastData.CNGFuelPrice;
            double[] hydrogenPrices = parameters.ForecastData.HydrogenFuelPrice;
            double[] spare1Prices   = parameters.ForecastData.Spare1FuelPrice;      
            double[] spare2Prices   = parameters.ForecastData.Spare2FuelPrice;      
            double[] e85Shares      = parameters.ForecastData.E85Share;
            double gasPrice = 0, dieselPrice = 0, e85Price = 0, cngPrice = 0, hydrogenPrice = 0,
                spare1Price = 0, spare2Price = 0;
            for (int i = 0; i < payback; i++)
            {   
                double surv = (survivability.Ldgv[i] + survivability.Lddv[i] +
                    survivability.Ldgt1[i] + survivability.Lddt1[i] +
                    survivability.Ldgt2[i] + survivability.Lddt2[i] +
                    survivability.Hdgv2b[i] + survivability.Hddv2b[i]) * 0.125;
                double miles = (autoMiles[i] + pickupMiles[i] + vanMiles[i] + suvMiles[i]) * 0.25;
                int myIdx = Math.Min(gasPrices.Length, modelYear.Index + i);
                double multiplier = surv * miles / Math.Pow(1 + discRate, i);
                gasPrice = gasPrices[myIdx] * multiplier;
                dieselPrice = dieselPrices[myIdx] * multiplier;
                e85Price = ((e85Shares[myIdx] * e85Prices[myIdx]) + ((1 - e85Shares[myIdx]) * gasPrices[myIdx])) *
                    multiplier;
                cngPrice = cngPrices[myIdx] * multiplier;
                hydrogenPrice = hydrogenPrices[myIdx] * multiplier;
                spare1Price = spare1Prices[myIdx] * multiplier;
                spare2Price = spare2Prices[myIdx] * multiplier;
                this._gasoline += gasPrice;
                this._diesel   += dieselPrice;
                this._e85      += e85Price;
                this._cng      += cngPrice;
                this._hydrogen += hydrogenPrice;
                this._spare1   += spare1Price;
                this._spare2   += spare2Price;
            }
            this._gasoline += (fract * gasPrice     );
            this._diesel   += (fract * dieselPrice  );
            this._e85      += (fract * e85Price     );
            this._cng      += (fract * cngPrice     );
            this._hydrogen += (fract * hydrogenPrice);
            this._spare1   += (fract * spare1Price  );
            this._spare2   += (fract * spare2Price  );
        }
        #endregion
        #region 
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        public KMYType Clone()
        {
            KMYType kmy = new KMYType();
            kmy._modelYear = new ModelYear(this._modelYear.Year);
            kmy._gasoline  = this._gasoline;
            kmy._diesel    = this._diesel;
            kmy._e85       = this._e85;
            kmy._cng       = this._cng;
            kmy._hydrogen  = this._hydrogen;
            kmy._spare1    = this._spare1;
            kmy._spare2    = this._spare2;
            return kmy;
        }
        #endregion
        public override string ToString()
        {
            return "{ModelYear=" + this._modelYear.ToString() +
                ", Gasoline="    + this._gasoline.ToString()  +
                ", Diesel="      + this._diesel.ToString()    +
                ", E85="         + this._e85.ToString()       +
                ", CNG="         + this._cng.ToString()       +
                ", Hydrogen="    + this._hydrogen.ToString()  +
                ", Spare1="      + this._spare1.ToString()    +
                ", Spare2="      + this._spare2.ToString()    + "}";
        }
        public static KMYType[] GetKmyValues(Parameters parameters, Estimates priceEstimates, Manufacturer manufacturer)
        {
            int numYears = manufacturer.Description.WillingToPayFines.Length;
            KMYType[] kmy = new KMYType[numYears];
            for (int i = 0; i < numYears; i++)
            {
                kmy[i] = new KMYType(new ModelYear(ModelYear.FromIndex(i)), parameters, priceEstimates, manufacturer);
            }
            return kmy;
        }
        #endregion
        #region 
        public ModelYear ModelYear { get { return this._modelYear; } }
        public double Gasoline { get { return this._gasoline; } }
        public double Diesel   { get { return this._diesel;   } }
        public double E85      { get { return this._e85;      } }
        public double CNG      { get { return this._cng;      } }
        public double Hydrogen { get { return this._hydrogen; } }
        public double Spare1   { get { return this._spare1;   } }
        public double Spare2   { get { return this._spare2;   } }
        #endregion
        #region 
        private ModelYear _modelYear;
        private double _gasoline;
        private double _diesel;
        private double _e85;
        private double _cng;
        private double _hydrogen;
        private double _spare1;
        private double _spare2;
        #endregion
    }
}

