using System;
using System.Diagnostics;
namespace Volpe.Interaction
{
    [Serializable]
    public class ProcessInfo
    {
        #region 
        public ProcessInfo(int pid)
        {
            Process process = Process.GetProcessById(pid);
            this._pid  = process.Id;
            this._name = process.ProcessName;
            this._processorCount = int.Parse(Environment.GetEnvironmentVariable("NUMBER_OF_PROCESSORS"));
        }
        #endregion
        #region 
        public void Poll(int timeInterval)
        {
            Process process = Process.GetProcessById(this._pid);
            this._threadCount = process.Threads.Count;
            this._cpuTime = process.TotalProcessorTime;
            this._cpuUsage = (this._cpuTime.TotalMilliseconds - this._prevCpuTime.TotalMilliseconds) /
                (timeInterval * this._processorCount);
            if (this._cpuUsage > this._peakCpuUsage) { this._peakCpuUsage = this._cpuUsage; }
            this._memorySize = process.WorkingSet;
            if (this._memorySize > this._peakMemorySize) { this._peakMemorySize = this._memorySize; }
            this._virtualMemorySize = process.PrivateMemorySize;
            if (this._virtualMemorySize > this._peakVirtualMemorySize) { this._peakVirtualMemorySize = this._virtualMemorySize; }
            this._prevCpuTime = this._cpuTime;
        }
        #endregion
        #region 
        public int    ProcessID      { get { return this._pid; } }
        public string ProcessName    { get { return this._name; } }
        public int    ProcessorCount { get { return this._processorCount; } }
        public int    ThreadCount    { get { return this._threadCount; } }
        public TimeSpan CpuTime      { get { return this._cpuTime; } }
        public double   CpuUsage     { get { return this._cpuUsage; } }
        public double   PeakCpuUsage { get { return this._peakCpuUsage; } }
        public long MemorySize            { get { return this._memorySize; } }
        public long PeakMemorySize        { get { return this._peakMemorySize; } }
        public long VirtualMemorySize     { get { return this._virtualMemorySize; } }
        public long PeakVirtualMemorySize { get { return this._peakVirtualMemorySize; } }
        #endregion
        #region 
        private int    _pid;
        private string _name;
        private int    _processorCount;
        private int    _threadCount;
        private TimeSpan _prevCpuTime;
        private TimeSpan _cpuTime;
        private double   _cpuUsage;
        private double   _peakCpuUsage;
        private long _memorySize;
        private long _peakMemorySize;
        private long _virtualMemorySize;
        private long _peakVirtualMemorySize;
        #endregion
    }
}

