using System;
using System.IO;
using System.Text;
using System.Windows.Forms;
namespace Volpe.Ui
{
    public class TextBoxWriter : TextWriter
    {
        #region 
        private delegate void WriteTextBoxDelegate(string value);
        #endregion
        #region 
        public TextBoxWriter(TextBoxBase textBox, bool autoScroll)
        {
            if (textBox == null)
            {
                throw new ArgumentNullException("textBox", "The specified text-box cannot be null.");
            }
            this._textBox    = textBox;
            this._autoScroll = autoScroll;
        }
        #endregion
        #region 
        public override void Write(string value)
        {
            this.WriteTextBox(value);
        }
        public override void WriteLine(string value)
        {
            this.Write(value + this.NewLine);
        }
        private void WriteTextBox(string value)
        {
            if (!this._textBox.Disposing && !this._textBox.IsDisposed)
            {
                if (this._textBox.InvokeRequired)
                {
                    this._textBox.Invoke(new WriteTextBoxDelegate(this.WriteTextBox), new object[] {value});
                }
                else
                {
                    this._textBox.AppendText(value);
                    if (this._autoScroll) { this._textBox.ScrollToCaret(); }
                }
            }
        }
        #endregion
        #region 
        public override Encoding Encoding { get { return Encoding.Default; } }
        public TextBoxBase TextBox { get { return this._textBox; } }
        public bool AutoScroll
        {
            get { return this._autoScroll; }
            set { this._autoScroll = value; }
        }
        #endregion
        #region 
        private TextBoxBase _textBox;
        private bool        _autoScroll;
        #endregion
    }
}

