using System;
using Volpe.Cafe;
using Volpe.Cafe.Collections;
using Volpe.Cafe.Data;
namespace Volpe.Cafe.Model
{
    public class MarketSimulation
    {
        #region 
        public static void AllocateCosts(Industry modelingData, ModelYear modelYear, Parameters parameters)
        {
            ManufacturerCollection mfrs = modelingData.Manufacturers;
            int myIdx = modelYear.Index;
            for (int i = 0, mfrCount = mfrs.Count; i < mfrCount; i++)
            {
                ManufacturerModelingData mmd = mfrs[i].ModelingData;
                VehicleCollection vehs = mfrs[i].ModelYearVehicles;
                int vehCount = vehs.Count;
                double mfrSales = 0, mfrSalesRevenue = 0, mfrTechCost = 0;
                double mfrFines = mmd.Fines.Total;
                int mfrStrategy = mfrs[i].Description.CostAllocationStrategy;
                for (int j = 0; j < vehCount; j++)
                {
                    VehicleDescription vehDescr = vehs[j].Description;
                    mfrSales += vehDescr.Sales[myIdx];
                    mfrSalesRevenue += vehDescr.Sales[myIdx] * vehDescr.Msrp[myIdx];
                    mfrTechCost += vehs[j].ModelingData.TechCost;
                }
                if (mfrStrategy == 3)
                {   
                    for (int j = 0; j < vehCount; j++)
                    {
                        vehs[j].ModelingData.RegCost = (mfrTechCost + mfrFines) / mfrSales *
                            vehs[j].Description.Sales[myIdx];
                    }
                } 
                else if (mfrStrategy == 1 || (mfrTechCost == 0 && mfrFines > 0))
                {   
                    double pctIncrease = (mfrTechCost + mfrFines) / mfrSalesRevenue;
                    for (int j = 0; j < vehCount; j++)
                    {
                        vehs[j].ModelingData.RegCost = (pctIncrease * vehs[j].Description.Msrp[myIdx]) *
                            vehs[j].Description.Sales[myIdx];
                    }
                } 
                else
                {   
                    for (int j = 0; j < vehCount; j++)
                    {
                        VehicleModelingData vmd = vehs[j].ModelingData;
                        vmd.RegCost = vmd.TechCost;
                    }
                    if (mfrFines > 0)
                    {
                        double[] vehPseudoFines = new double[vehCount];
                        double mfrPseudoFines = 0;
                        for (int j = 0; j < vehCount; j++)
                        {
                            vehPseudoFines[j] = MarketSimulation.GetPseudoFine(mfrs[i], vehs[j], modelYear, parameters);
                            mfrPseudoFines += vehPseudoFines[j];
                        }
                        for (int j = 0; j < vehCount; j++)
                        {
                            vehs[j].ModelingData.RegCost += mfrFines * (vehPseudoFines[j] / mfrPseudoFines);
                        }
                    } 
                } 
                mmd.RegCost.Clear();
                for (int j = 0; j < vehCount; j++)
                {
                    RegulatoryClass vehRc = vehs[j].RegClass;
                    mmd.RegCost[vehRc] += vehs[j].ModelingData.RegCost;
                }
            } 
        }
        protected static double GetPseudoFine(Manufacturer manufacturer, Vehicle vehicle, ModelYear modelYear,
            Parameters parameters)
        {
            double vehSales = vehicle.Description.Sales[modelYear.Index];
            double vehFe = vehicle.Description.FuelEconomy;
            double standard = manufacturer.ModelingData.Standard[vehicle.RegClass];
            return Math.Max(0, parameters.EconomicValues.Kf * vehSales * (standard - vehFe));
        }
        #endregion
    }
}

