using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using Volpe.Cafe.Ui.Panels;
namespace Volpe.Cafe.Ui
{
    public class ManageOutput : System.Windows.Forms.Form
    {
        #region 
        public ManageOutput(OutputSettings outputSettings)
        {
            this.InitializeComponent();
            this._outputSettings = outputSettings;
            this._settingsChanged = false;
        }
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }
        #endregion
        #region 
        #region 
        private void InitializeComponent()
        {
            this.ux_introLabel = new System.Windows.Forms.Label();
            this.ux_statusTextBox = new System.Windows.Forms.RichTextBox();
            this.ux_closeLabelButton = new Volpe.Cafe.Ui.LabelButton();
            this.ux_saveLabelButton = new Volpe.Cafe.Ui.LabelButton();
            this.ux_outputPanel = new Volpe.Cafe.Ui.Panels.OutputPanel();
            this.SuspendLayout();
            this.ux_introLabel.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
                | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_introLabel.Location = new System.Drawing.Point(8, 8);
            this.ux_introLabel.Name = "ux_introLabel";
            this.ux_introLabel.Size = new System.Drawing.Size(360, 48);
            this.ux_introLabel.TabIndex = 0;
            this.ux_introLabel.Text = "The Manage Output window allows you to select the locations for output and log fi" +
                "les, and to customize which reports will be generated by the modeling system.";
            this.ux_statusTextBox.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
                | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_statusTextBox.BackColor = System.Drawing.SystemColors.Control;
            this.ux_statusTextBox.BorderStyle = System.Windows.Forms.BorderStyle.None;
            this.ux_statusTextBox.ForeColor = System.Drawing.Color.Black;
            this.ux_statusTextBox.Location = new System.Drawing.Point(8, 288);
            this.ux_statusTextBox.Name = "ux_statusTextBox";
            this.ux_statusTextBox.ReadOnly = true;
            this.ux_statusTextBox.ScrollBars = System.Windows.Forms.RichTextBoxScrollBars.Vertical;
            this.ux_statusTextBox.Size = new System.Drawing.Size(272, 64);
            this.ux_statusTextBox.TabIndex = 2;
            this.ux_statusTextBox.TabStop = false;
            this.ux_statusTextBox.Text = "Ready.";
            this.ux_closeLabelButton.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_closeLabelButton.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_closeLabelButton.Location = new System.Drawing.Point(328, 312);
            this.ux_closeLabelButton.Name = "ux_closeLabelButton";
            this.ux_closeLabelButton.Size = new System.Drawing.Size(32, 32);
            this.ux_closeLabelButton.TabIndex = 4;
            this.ux_closeLabelButton.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.ux_closeLabelButton.Click += new System.EventHandler(this.CloseLabelButton_Click);
            this.ux_saveLabelButton.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_saveLabelButton.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_saveLabelButton.Location = new System.Drawing.Point(288, 312);
            this.ux_saveLabelButton.Name = "ux_saveLabelButton";
            this.ux_saveLabelButton.Size = new System.Drawing.Size(32, 32);
            this.ux_saveLabelButton.TabIndex = 3;
            this.ux_saveLabelButton.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.ux_saveLabelButton.Click += new System.EventHandler(this.SaveLabelButton_Click);
            this.ux_outputPanel.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
                | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_outputPanel.AutoScroll = true;
            this.ux_outputPanel.Location = new System.Drawing.Point(0, 56);
            this.ux_outputPanel.Name = "ux_outputPanel";
            this.ux_outputPanel.Size = new System.Drawing.Size(376, 232);
            this.ux_outputPanel.TabIndex = 5;
            this.ux_outputPanel.VisualTrackingColor = System.Drawing.Color.Blue;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 14);
            this.ClientSize = new System.Drawing.Size(378, 359);
            this.Controls.Add(this.ux_outputPanel);
            this.Controls.Add(this.ux_statusTextBox);
            this.Controls.Add(this.ux_closeLabelButton);
            this.Controls.Add(this.ux_saveLabelButton);
            this.Controls.Add(this.ux_introLabel);
            this.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
            this.HelpButton = true;
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.Name = "ManageOutput";
            this.ShowInTaskbar = false;
            this.Text = "Manage Output";
            this.Load += new System.EventHandler(this.ManageOutput_Load);
            this.ResumeLayout(false);
        }
        #endregion
        #region 
        private void ManageOutput_Idle(object sender, EventArgs e)
        {
            this.ux_saveLabelButton.Enabled = this.ux_outputPanel.SettingsChanged;
        }
        private void ManageOutput_Load(object sender, System.EventArgs e)
        {
            this.Font = Cafe2d.DefaultFont;
            this.ux_saveLabelButton.ThemeInitialize("ok", true);
            this.ux_closeLabelButton.ThemeInitialize("cancel", true);
            this.ux_outputPanel.Messages.MessagesChanged += new EventHandler(this.Messages_MessagesChanged);
            this.ux_outputPanel.SetInitialState(this._outputSettings);
            Application.Idle += new EventHandler(this.ManageOutput_Idle);
            this.Closing += new CancelEventHandler(this.ManageOutput_Closing);
        }
        private void ManageOutput_Closing(object sender, CancelEventArgs e)
        {
            Application.Idle -= new EventHandler(this.ManageOutput_Idle);
        }
        private void Messages_MessagesChanged(object sender, EventArgs e)
        {
            this.ux_statusTextBox.Rtf = this.ux_outputPanel.Messages.ToString();
            this.ux_statusTextBox.Enabled = this.ux_statusTextBox.Text != "";
        }
        private void SaveLabelButton_Click(object sender, System.EventArgs e)
        {
            if (this.ux_outputPanel.SettingsChanged)
            {
                this._settingsChanged = true;
                this.ux_outputPanel.SaveChanges();
            }
        }
        private void CloseLabelButton_Click(object sender, System.EventArgs e)
        {
            this.DialogResult = DialogResult.OK;
        }
        #endregion
        #endregion
        #region 
        public OutputPanel OutputPanel
        {
            get
            {
                return this.ux_outputPanel;
            }
        }
        public bool SettingsChanged
        {
            get
            {
                return this._settingsChanged;
            }
        }
        #endregion
        #region 
        #region 
        private System.Windows.Forms.Label ux_introLabel;
        private System.Windows.Forms.RichTextBox ux_statusTextBox;
        private Volpe.Cafe.Ui.LabelButton ux_closeLabelButton;
        private Volpe.Cafe.Ui.LabelButton ux_saveLabelButton;
        private Volpe.Cafe.Ui.Panels.OutputPanel ux_outputPanel;
        private System.ComponentModel.Container components = null;
        #endregion
        private OutputSettings _outputSettings;
        private bool _settingsChanged;
        #endregion
    }
}

