using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using Volpe.Cafe;
namespace Volpe.Cafe.Ui.Panels
{
    public class OpModesPanel : Volpe.Cafe.Ui.Panels.CafeUserControl
    {
        #region 
        public OpModesPanel()
        {
            this.InitializeComponent();
            this.PostInitialize();
        }
        protected override void Dispose(bool disposing)
        {
            base.Dispose(disposing);
        }
        #endregion
        #region 
        #region 
        void InitializeComponent()
        {
            this.ux_noFines = new System.Windows.Forms.CheckBox();
            this.ux_ignoreYearAvailable = new System.Windows.Forms.CheckBox();
            this.ux_ignorePhaseIn = new System.Windows.Forms.CheckBox();
            this.ux_ignoreRefreshRedesign = new System.Windows.Forms.CheckBox();
            this.ux_multiYearModeling = new System.Windows.Forms.CheckBox();
            this.ux_multiYearStartYearLabel = new System.Windows.Forms.Label();
            this.ux_multiYearStartYear = new System.Windows.Forms.TextBox();
            this.ux_technologyFuelEstimatesGroupBox = new System.Windows.Forms.GroupBox();
            this.ux_techFuelEstimatesHighRadioButton = new System.Windows.Forms.RadioButton();
            this.ux_techFuelEstimatesAverageRadioButton = new System.Windows.Forms.RadioButton();
            this.ux_techFuelEstimatesLowRadioButton = new System.Windows.Forms.RadioButton();
            this.ux_technologyCostEstimatesGroupBox = new System.Windows.Forms.GroupBox();
            this.ux_techCostEstimatesHighRadioButton = new System.Windows.Forms.RadioButton();
            this.ux_techCostEstimatesAverageRadioButton = new System.Windows.Forms.RadioButton();
            this.ux_techCostEstimatesLowRadioButton = new System.Windows.Forms.RadioButton();
            this.ux_technologyFuelEstimatesGroupBox.SuspendLayout();
            this.ux_technologyCostEstimatesGroupBox.SuspendLayout();
            this.SuspendLayout();
            this.ux_noFines.CheckAlign = System.Drawing.ContentAlignment.TopLeft;
            this.ux_noFines.Location = new System.Drawing.Point(8, 96);
            this.ux_noFines.Name = "ux_noFines";
            this.ux_noFines.Size = new System.Drawing.Size(216, 16);
            this.ux_noFines.TabIndex = 1;
            this.ux_noFines.Text = "Force \"No Fines\" on All Manufacturers";
            this.ux_ignoreYearAvailable.CheckAlign = System.Drawing.ContentAlignment.TopLeft;
            this.ux_ignoreYearAvailable.Location = new System.Drawing.Point(8, 152);
            this.ux_ignoreYearAvailable.Name = "ux_ignoreYearAvailable";
            this.ux_ignoreYearAvailable.Size = new System.Drawing.Size(208, 16);
            this.ux_ignoreYearAvailable.TabIndex = 10;
            this.ux_ignoreYearAvailable.Text = "Ignore Technology \"Year Available\"";
            this.ux_ignorePhaseIn.CheckAlign = System.Drawing.ContentAlignment.TopLeft;
            this.ux_ignorePhaseIn.Location = new System.Drawing.Point(8, 168);
            this.ux_ignorePhaseIn.Name = "ux_ignorePhaseIn";
            this.ux_ignorePhaseIn.Size = new System.Drawing.Size(200, 16);
            this.ux_ignorePhaseIn.TabIndex = 11;
            this.ux_ignorePhaseIn.Text = "Ignore Technology Phase-In Caps";
            this.ux_ignoreRefreshRedesign.CheckAlign = System.Drawing.ContentAlignment.TopLeft;
            this.ux_ignoreRefreshRedesign.Location = new System.Drawing.Point(8, 184);
            this.ux_ignoreRefreshRedesign.Name = "ux_ignoreRefreshRedesign";
            this.ux_ignoreRefreshRedesign.Size = new System.Drawing.Size(248, 16);
            this.ux_ignoreRefreshRedesign.TabIndex = 12;
            this.ux_ignoreRefreshRedesign.Text = "Ignore Vehicle Refresh/Redesign Schedules";
            this.ux_multiYearModeling.CheckAlign = System.Drawing.ContentAlignment.TopLeft;
            this.ux_multiYearModeling.Location = new System.Drawing.Point(8, 112);
            this.ux_multiYearModeling.Name = "ux_multiYearModeling";
            this.ux_multiYearModeling.Size = new System.Drawing.Size(152, 16);
            this.ux_multiYearModeling.TabIndex = 2;
            this.ux_multiYearModeling.Text = "Use Multi-Year Modeling";
            this.ux_multiYearStartYearLabel.Enabled = false;
            this.ux_multiYearStartYearLabel.Location = new System.Drawing.Point(24, 128);
            this.ux_multiYearStartYearLabel.Name = "ux_multiYearStartYearLabel";
            this.ux_multiYearStartYearLabel.Size = new System.Drawing.Size(64, 16);
            this.ux_multiYearStartYearLabel.TabIndex = 3;
            this.ux_multiYearStartYearLabel.Text = "Starting At:";
            this.ux_multiYearStartYearLabel.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.ux_multiYearStartYear.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_multiYearStartYear.Enabled = false;
            this.ux_multiYearStartYear.Location = new System.Drawing.Point(88, 128);
            this.ux_multiYearStartYear.MaxLength = 4;
            this.ux_multiYearStartYear.Multiline = true;
            this.ux_multiYearStartYear.Name = "ux_multiYearStartYear";
            this.ux_multiYearStartYear.Size = new System.Drawing.Size(56, 18);
            this.ux_multiYearStartYear.TabIndex = 4;
            this.ux_multiYearStartYear.Text = "";
            this.ux_multiYearStartYear.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this.ux_technologyFuelEstimatesGroupBox.Controls.Add(this.ux_techFuelEstimatesHighRadioButton);
            this.ux_technologyFuelEstimatesGroupBox.Controls.Add(this.ux_techFuelEstimatesAverageRadioButton);
            this.ux_technologyFuelEstimatesGroupBox.Controls.Add(this.ux_techFuelEstimatesLowRadioButton);
            this.ux_technologyFuelEstimatesGroupBox.Location = new System.Drawing.Point(8, 8);
            this.ux_technologyFuelEstimatesGroupBox.Name = "ux_technologyFuelEstimatesGroupBox";
            this.ux_technologyFuelEstimatesGroupBox.Size = new System.Drawing.Size(176, 40);
            this.ux_technologyFuelEstimatesGroupBox.TabIndex = 0;
            this.ux_technologyFuelEstimatesGroupBox.TabStop = false;
            this.ux_technologyFuelEstimatesGroupBox.Text = "Fuel Estimates";
            this.ux_techFuelEstimatesHighRadioButton.Location = new System.Drawing.Point(120, 16);
            this.ux_techFuelEstimatesHighRadioButton.Name = "ux_techFuelEstimatesHighRadioButton";
            this.ux_techFuelEstimatesHighRadioButton.Size = new System.Drawing.Size(48, 16);
            this.ux_techFuelEstimatesHighRadioButton.TabIndex = 2;
            this.ux_techFuelEstimatesHighRadioButton.Text = "High";
            this.ux_techFuelEstimatesAverageRadioButton.Location = new System.Drawing.Point(56, 16);
            this.ux_techFuelEstimatesAverageRadioButton.Name = "ux_techFuelEstimatesAverageRadioButton";
            this.ux_techFuelEstimatesAverageRadioButton.Size = new System.Drawing.Size(64, 16);
            this.ux_techFuelEstimatesAverageRadioButton.TabIndex = 1;
            this.ux_techFuelEstimatesAverageRadioButton.Text = "Average";
            this.ux_techFuelEstimatesLowRadioButton.Location = new System.Drawing.Point(8, 16);
            this.ux_techFuelEstimatesLowRadioButton.Name = "ux_techFuelEstimatesLowRadioButton";
            this.ux_techFuelEstimatesLowRadioButton.Size = new System.Drawing.Size(48, 16);
            this.ux_techFuelEstimatesLowRadioButton.TabIndex = 0;
            this.ux_techFuelEstimatesLowRadioButton.Text = "Low";
            this.ux_technologyCostEstimatesGroupBox.Controls.Add(this.ux_techCostEstimatesHighRadioButton);
            this.ux_technologyCostEstimatesGroupBox.Controls.Add(this.ux_techCostEstimatesAverageRadioButton);
            this.ux_technologyCostEstimatesGroupBox.Controls.Add(this.ux_techCostEstimatesLowRadioButton);
            this.ux_technologyCostEstimatesGroupBox.Location = new System.Drawing.Point(8, 48);
            this.ux_technologyCostEstimatesGroupBox.Name = "ux_technologyCostEstimatesGroupBox";
            this.ux_technologyCostEstimatesGroupBox.Size = new System.Drawing.Size(176, 40);
            this.ux_technologyCostEstimatesGroupBox.TabIndex = 1;
            this.ux_technologyCostEstimatesGroupBox.TabStop = false;
            this.ux_technologyCostEstimatesGroupBox.Text = "Cost Estimates";
            this.ux_techCostEstimatesHighRadioButton.Location = new System.Drawing.Point(120, 16);
            this.ux_techCostEstimatesHighRadioButton.Name = "ux_techCostEstimatesHighRadioButton";
            this.ux_techCostEstimatesHighRadioButton.Size = new System.Drawing.Size(48, 16);
            this.ux_techCostEstimatesHighRadioButton.TabIndex = 2;
            this.ux_techCostEstimatesHighRadioButton.Text = "High";
            this.ux_techCostEstimatesAverageRadioButton.Location = new System.Drawing.Point(56, 16);
            this.ux_techCostEstimatesAverageRadioButton.Name = "ux_techCostEstimatesAverageRadioButton";
            this.ux_techCostEstimatesAverageRadioButton.Size = new System.Drawing.Size(64, 16);
            this.ux_techCostEstimatesAverageRadioButton.TabIndex = 1;
            this.ux_techCostEstimatesAverageRadioButton.Text = "Average";
            this.ux_techCostEstimatesLowRadioButton.Location = new System.Drawing.Point(8, 16);
            this.ux_techCostEstimatesLowRadioButton.Name = "ux_techCostEstimatesLowRadioButton";
            this.ux_techCostEstimatesLowRadioButton.Size = new System.Drawing.Size(48, 16);
            this.ux_techCostEstimatesLowRadioButton.TabIndex = 0;
            this.ux_techCostEstimatesLowRadioButton.Text = "Low";
            this.AutoScroll = true;
            this.Controls.Add(this.ux_ignoreRefreshRedesign);
            this.Controls.Add(this.ux_ignorePhaseIn);
            this.Controls.Add(this.ux_ignoreYearAvailable);
            this.Controls.Add(this.ux_noFines);
            this.Controls.Add(this.ux_technologyCostEstimatesGroupBox);
            this.Controls.Add(this.ux_technologyFuelEstimatesGroupBox);
            this.Controls.Add(this.ux_multiYearStartYear);
            this.Controls.Add(this.ux_multiYearStartYearLabel);
            this.Controls.Add(this.ux_multiYearModeling);
            this.Name = "OpModesPanel";
            this.Size = new System.Drawing.Size(352, 208);
            this.ux_technologyFuelEstimatesGroupBox.ResumeLayout(false);
            this.ux_technologyCostEstimatesGroupBox.ResumeLayout(false);
            this.ResumeLayout(false);
        }
        #endregion
        void PostInitialize()
        {
            this.AutoInitializeCheckChangesDetector(this.Controls);
            this.ux_multiYearModeling.CheckedChanged += new EventHandler(this.MultiYearModeling_CheckedChanged);
        }
        void MultiYearModeling_CheckedChanged(object sender, EventArgs e)
        {
            bool enabled = this.ux_multiYearModeling.Checked;
            this.ux_multiYearStartYearLabel.Enabled = enabled;
            this.ux_multiYearStartYear     .Enabled = enabled;
        }
        public void SetInitialState(OperatingModes operatingModes, int minYear, int maxYear)
        {
            this._operatingModes = operatingModes;
            this.ux_noFines.Checked                           = operatingModes.NoFines;
            this.ux_multiYearModeling.Checked                 = operatingModes.MultiYearModeling;
            this.ux_multiYearStartYear.Text                   = (operatingModes.MultiYearStartYear >= minYear) ? operatingModes.MultiYearStartYear.ToString("0") : minYear.ToString("0");
            this.TechnologyFuelEstimates                      = operatingModes.TechnologyFuelEstimates;
            this.TechnologyCostEstimates                      = operatingModes.TechnologyCostEstimates;
            this.ux_ignoreYearAvailable.Checked               = operatingModes.IgnoreYearAvailable;
            this.ux_ignorePhaseIn.Checked                     = operatingModes.IgnorePhaseIn;
            this.ux_ignoreRefreshRedesign.Checked             = operatingModes.IgnoreRefreshRedesign;
            this.RegisterNumericTextControl(this.ux_multiYearStartYear, minYear, minYear, maxYear,
                "The multi-year starting year should be between {MIN} and {MAX}.", true, "0");
            base.SaveChanges();
        }
        public override void SaveChanges()
        {
            if (this.SettingsChanged)
            {   
                this._operatingModes.NoFines                           = this.ux_noFines.Checked;
                this._operatingModes.MultiYearModeling                 = this.ux_multiYearModeling.Checked;
                this._operatingModes.MultiYearStartYear                = Global.GetInt32(this.ux_multiYearStartYear.Text);
                this._operatingModes.TechnologyFuelEstimates           = this.TechnologyFuelEstimates;
                this._operatingModes.TechnologyCostEstimates           = this.TechnologyCostEstimates;
                this._operatingModes.IgnoreYearAvailable               = this.ux_ignoreYearAvailable.Checked;
                this._operatingModes.IgnorePhaseIn                     = this.ux_ignorePhaseIn.Checked;
                this._operatingModes.IgnoreRefreshRedesign             = this.ux_ignoreRefreshRedesign.Checked;
                base.SaveChanges();
            }
        }
        #endregion
        #region 
        [Browsable(false)]
        public OperatingModes OperatingModes { get { return this._operatingModes; } }
        [Browsable(false)]
        Estimates TechnologyFuelEstimates
        {
            get
            {
                return (this.ux_techFuelEstimatesLowRadioButton.Checked) ? Estimates.Low :
                    (this.ux_techFuelEstimatesHighRadioButton.Checked) ? Estimates.High : Estimates.Average;
            }
            set
            {
                if      (value == Estimates.Low)  { this.ux_techFuelEstimatesLowRadioButton    .Checked = true; }
                else if (value == Estimates.High) { this.ux_techFuelEstimatesHighRadioButton   .Checked = true; }
                else                              { this.ux_techFuelEstimatesAverageRadioButton.Checked = true; }
            }
        }
        [Browsable(false)]
        Estimates TechnologyCostEstimates
        {
            get
            {
                return (this.ux_techCostEstimatesLowRadioButton.Checked) ? Estimates.Low :
                    (this.ux_techCostEstimatesHighRadioButton.Checked) ? Estimates.High : Estimates.Average;
            }
            set
            {
                if      (value == Estimates.Low)  { this.ux_techCostEstimatesLowRadioButton    .Checked = true; }
                else if (value == Estimates.High) { this.ux_techCostEstimatesHighRadioButton   .Checked = true; }
                else                              { this.ux_techCostEstimatesAverageRadioButton.Checked = true; }
            }
        }
        #endregion
        #region 
        #region 
        System.Windows.Forms.CheckBox ux_noFines;
        System.Windows.Forms.CheckBox ux_multiYearModeling;
        System.Windows.Forms.Label ux_multiYearStartYearLabel;
        System.Windows.Forms.TextBox ux_multiYearStartYear;
        System.Windows.Forms.CheckBox ux_ignoreYearAvailable;
        System.Windows.Forms.CheckBox ux_ignorePhaseIn;
        System.Windows.Forms.CheckBox ux_ignoreRefreshRedesign;
        System.Windows.Forms.GroupBox ux_technologyFuelEstimatesGroupBox;
        System.Windows.Forms.RadioButton ux_techFuelEstimatesLowRadioButton;
        System.Windows.Forms.RadioButton ux_techFuelEstimatesAverageRadioButton;
        System.Windows.Forms.RadioButton ux_techFuelEstimatesHighRadioButton;
        System.Windows.Forms.GroupBox ux_technologyCostEstimatesGroupBox;
        System.Windows.Forms.RadioButton ux_techCostEstimatesHighRadioButton;
        System.Windows.Forms.RadioButton ux_techCostEstimatesAverageRadioButton;
        System.Windows.Forms.RadioButton ux_techCostEstimatesLowRadioButton;
        #endregion
        OperatingModes _operatingModes;
        #endregion
    }
}

