using System;
using System.IO;
using System.Management;
using Volpe.Utils;
namespace Volpe.Cafe.Ui.Settings
{
    public sealed class UiSettings
    {
        #region 
        public UiSettings()
        {
            this._inputSettings = new UiInputSettings();
            this.SetDefaults();
        }
        #endregion
        #region 
        public void SetDefaults()
        {
            this._dragAndDrop = TriState.Enabled;
            this._compressor = new ZipUtilities(ZipFormat.Zip, ZipLevel.Default);
            this._inputSettings.SearchPrimaryDataPath = TriState.Enabled;
            this._inputSettings.VerifySelectedFiles   = TriState.Enabled;
            this._inputSettings.DragAndDrop           = TriState.NotConfigured;
            this._inputSettings.RecurseDirectories    = TriState.NotConfigured;
            this._inputSettings.BackgroundLoadFiles   = TriState.NotConfigured;
        }
        #endregion
        #region 
        public UiInputSettings InputSettings { get { return this._inputSettings; } }
        public TriState DragAndDrop
        {
            get { return this._dragAndDrop; }
            set { if ((int)value >= 0 && (int)value < 3) { this._dragAndDrop = value; } }
        }
        public ZipUtilities Compressor { get { return this._compressor; } }
        public ZipLevel ZipLevel1 { get { return this._compressor.Level; } set { this._compressor.Level = value; } }
        #endregion
        #region 
        UiInputSettings _inputSettings;
        TriState _dragAndDrop;
        ZipUtilities _compressor;
        #endregion
    }
}

