using System;
using System.Collections;
using System.IO;
using System.Text;
using System.Windows.Forms;
namespace Volpe.Cafe.Ui
{
    public sealed class Themes
    {
        #region 
        public event EventHandler ThemeIndexChanged;
        public event EventHandler ThemeAlternativeChanged;
        #endregion
        #region 
        public Themes()
        {
            this._themes = new ArrayList();
        }
        public Themes(string path) : this()
        {
            this.ParseThemes(path);
        }
        #endregion
        #region 
        public void ParseThemes(string path)
        {
            string[] files = Directory.GetFiles(path, "*.cmth");
            for (int i = 0; i < files.Length; i++)
            {
                this._themes.AddRange(this.ParseTheme(files[i]));
            }
        }
        private ArrayList ParseTheme(string filePath)
        {
            ArrayList themes = new ArrayList();
            string path = Path.GetDirectoryName(filePath);
            StreamReader sr = new StreamReader(filePath);
            string line = sr.ReadLine().Trim();
            int numThemes = 0;
            ThemeDescription descr = new ThemeDescription();
            string verifyRes;
            while (line != null)
            {
                if (line != "" && !line.StartsWith("#"))
                {
                    if (line.ToLower().StartsWith("theme-name"))
                    {
                        if (numThemes > 0)
                        {
                            if (descr.Verify(out verifyRes))
                            {
                                Theme theme = new Theme(descr);
                                themes.Add(theme);
                            }
                            else
                            {
                                throw new Exception("Error loading theme file: \r\n\r\n" + verifyRes);
                            }
                        }
                        numThemes++;
                        descr = new ThemeDescription();
                        descr.Reset();
                        descr.Name = line.Substring(line.IndexOf(' ')).Trim();
                    } 
                    else if (line.ToLower().StartsWith("description"))
                    {
                        descr.Description = line.Substring(line.IndexOf(' ')).Trim();
                    }
                    else if (line.ToLower().StartsWith("session-new"))
                    {
                        descr.SessionNew = line.Substring(line.IndexOf(' ')).Trim().Split(',');
                    }
                    else if (line.ToLower().StartsWith("session-open"))
                    {
                        descr.SessionOpen = line.Substring(line.IndexOf(' ')).Trim().Split(',');
                    }
                    else if (line.ToLower().StartsWith("session-save"))
                    {
                        descr.SessionSave = line.Substring(line.IndexOf(' ')).Trim().Split(',');
                    }
                    else if (line.ToLower().StartsWith("config-files"))
                    {
                        descr.ConfigFiles = line.Substring(line.IndexOf(' ')).Trim().Split(',');
                    }
                    else if (line.ToLower().StartsWith("config-settings"))
                    {
                        descr.ConfigSettings = line.Substring(line.IndexOf(' ')).Trim().Split(',');
                    }
                    else if (line.ToLower().StartsWith("model-start"))
                    {
                        descr.ModelStart = line.Substring(line.IndexOf(' ')).Trim().Split(',');
                    }
                    else if (line.ToLower().StartsWith("model-cancel"))
                    {
                        descr.ModelCancel = line.Substring(line.IndexOf(' ')).Trim().Split(',');
                    }
                    else if (line.ToLower().StartsWith("back"))
                    {
                        descr.Back = line.Substring(line.IndexOf(' ')).Trim().Split(',');
                    }
                    else if (line.ToLower().StartsWith("forward"))
                    {
                        descr.Forward = line.Substring(line.IndexOf(' ')).Trim().Split(',');
                    }
                    else if (line.ToLower().StartsWith("ok"))
                    {
                        descr.Ok = line.Substring(line.IndexOf(' ')).Trim().Split(',');
                    }
                    else if (line.ToLower().StartsWith("cancel"))
                    {
                        descr.Cancel = line.Substring(line.IndexOf(' ')).Trim().Split(',');
                    }
                    else if (line.ToLower().StartsWith("x22"))
                    {
                        descr.x22 = path + "\\" + line.Substring(line.IndexOf(' ')).Trim();
                    }
                    else if (line.ToLower().StartsWith("x32"))
                    {
                        descr.x32 = path + "\\" + line.Substring(line.IndexOf(' ')).Trim();
                    }
                    else if (line.ToLower().StartsWith("base-small"))
                    {
                        descr.BaseSmall = path + "\\" + line.Substring(line.IndexOf(' ')).Trim();
                    }
                    else if (line.ToLower().StartsWith("base-large"))
                    {
                        descr.BaseLarge = path + "\\" + line.Substring(line.IndexOf(' ')).Trim();
                    }
                    else if (line.ToLower().StartsWith("alt-small"))
                    {
                        descr.AltSmall = path + "\\" + line.Substring(line.IndexOf(' ')).Trim();
                    }
                    else if (line.ToLower().StartsWith("alt-large"))
                    {
                        descr.AltLarge = path + "\\" + line.Substring(line.IndexOf(' ')).Trim();
                    }
                }
                line = sr.ReadLine();
                if (line != null)
                {
                    line = line.Trim();
                }
            }
            if (descr.Verify(out verifyRes))
            {
                Theme theme = new Theme(descr);
                themes.Add(theme);
            }
            else
            {
                throw new Exception("Error loading theme file: \r\n\r\n" + verifyRes);
            }
            return themes;
        }
        #endregion
        #region 
        public Theme this[int index]
        {
            get
            {
                return (Theme)this._themes[index];
            }
        }
        public Theme[] List
        {
            get
            {
                Theme[] themes = new Theme[this._themes.Count];
                for (int i = 0; i < this._themes.Count; i++)
                {
                    themes[i] = (Theme)this._themes[i];
                }
                return themes;
            }
        }
        public Theme SelectedTheme
        {
            get
            {
                return (Theme)this._themes[this._selectedThemeIndex];
            }
        }
        public int SelectedThemeIndex
        {
            get
            {
                return this._selectedThemeIndex;
            }
            set
            {
                if (this._themes.Count > value)
                {
                    this._selectedThemeIndex = value;
                    if (this.ThemeIndexChanged != null)
                    {
                        this.ThemeIndexChanged(this, EventArgs.Empty);
                    }
                }
                else
                {
                    throw new ArgumentOutOfRangeException("SelectedThemeIndex");
                }
            }
        }
        public int ThemeAlternative
        {
            get
            {
                return this._selectedThemeAlternative;
            }
            set
            {
                if (((Theme)this._themes[this._selectedThemeIndex]).Alternatives > value)
                {
                    this._selectedThemeAlternative = value;
                    if (this.ThemeAlternativeChanged != null)
                    {
                        this.ThemeAlternativeChanged(this, EventArgs.Empty);
                    }
                }
                else
                {
                    throw new ArgumentOutOfRangeException("ThemeAlternative");
                }
            }
        }
        #endregion
        #region 
        private ArrayList _themes;
        private int _selectedThemeIndex;
        private int _selectedThemeAlternative;
        #endregion
    }
}

