using System;
using System.Drawing;
using System.Windows.Forms;
using System.Runtime.InteropServices;
namespace Volpe.Cafe.Ui.Wizards
{
    internal class Global
    {
        public static Size GetTextSize(Font font, string text, int desiredWidth)
        {
            Label l = new Label();
            l.Font = font;
            l.Text = text;
            Global.AutoSizeLabel(l, desiredWidth);
            return l.Size;
        }
        internal static void AutoSizeLabel(Label label, int width)
        {
            label.AutoSize = true;
            int lines = (int)Math.Ceiling((double)label.Width / (double)width) + 1;
            int height = lines * label.Font.Height;
            label.AutoSize = false;
            label.Size = new Size(width, height);
        }
        internal static TreeNode[] GetTreeNodeFlatList(TreeNode node)
        {
            int count = 1 + Global.GetTreeNodeTotalCount(node);
            TreeNode[] nodes = new TreeNode[count];
            nodes[0] = node;
            int index = 1;
            for (int i = 0; i < node.Nodes.Count; i++)
            {
                TreeNode[] children = Global.GetTreeNodeFlatList(node.Nodes[i]);
                for (int j = 0; j < children.Length; j++)
                {
                    nodes[index++] = children[j];
                }
            }
            return nodes;
        }
        internal static int GetTreeNodeTotalCount(TreeNode node)
        {
            int count = node.Nodes.Count;
            for (int i = 0; i < node.Nodes.Count; i++)
            {
                count += Global.GetTreeNodeTotalCount(node.Nodes[i]);
            }
            return count;
        }
        [DllImport("gdi32", CharSet=CharSet.Auto)]
        internal static extern int GetTextExtentPoint32(int hdc, string lpString, int cbString, out Size lpSize);
    }
}

