using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
namespace Volpe.Cafe.Ui.Wizards
{
    internal class NSW_SelectReports : Panel
    {
        #region 
        public NSW_SelectReports()
        {
            this.InitializeComponent();
        }
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (this.components != null)
                {
                    this.components.Dispose();
                }
            }
            base.Dispose(disposing);
        }
        #endregion
        #region 
        private void InitializeComponent()
        {
            this.ux_bodyLabel = new System.Windows.Forms.Label();
            this.ux_industryCheckBox = new System.Windows.Forms.CheckBox();
            this.ux_manufacturersCheckBox = new System.Windows.Forms.CheckBox();
            this.ux_vehiclesCheckBox = new System.Windows.Forms.CheckBox();
            this.ux_scenarioSummaryCheckBox = new System.Windows.Forms.CheckBox();
            this.SuspendLayout();
            this.ux_bodyLabel.Location = new System.Drawing.Point(8, 8);
            this.ux_bodyLabel.Name = "ux_bodyLabel";
            this.ux_bodyLabel.Size = new System.Drawing.Size(408, 56);
            this.ux_bodyLabel.TabIndex = 0;
            this.ux_bodyLabel.Text = @"This screen allows you to configure which reports you want the modeling system to generate.  Additional reports, which are not listed here, may be available based on the selected compliance model and extensions.  Please select the report types you would like generate below.";
            this.ux_industryCheckBox.Location = new System.Drawing.Point(16, 72);
            this.ux_industryCheckBox.Name = "ux_industryCheckBox";
            this.ux_industryCheckBox.Size = new System.Drawing.Size(104, 16);
            this.ux_industryCheckBox.TabIndex = 1;
            this.ux_industryCheckBox.Text = "Industry report";
            this.ux_manufacturersCheckBox.Location = new System.Drawing.Point(16, 88);
            this.ux_manufacturersCheckBox.Name = "ux_manufacturersCheckBox";
            this.ux_manufacturersCheckBox.Size = new System.Drawing.Size(128, 16);
            this.ux_manufacturersCheckBox.TabIndex = 2;
            this.ux_manufacturersCheckBox.Text = "Manufacturers report";
            this.ux_vehiclesCheckBox.Location = new System.Drawing.Point(16, 104);
            this.ux_vehiclesCheckBox.Name = "ux_vehiclesCheckBox";
            this.ux_vehiclesCheckBox.Size = new System.Drawing.Size(104, 16);
            this.ux_vehiclesCheckBox.TabIndex = 3;
            this.ux_vehiclesCheckBox.Text = "Vehicles report";
            this.ux_scenarioSummaryCheckBox.Location = new System.Drawing.Point(16, 120);
            this.ux_scenarioSummaryCheckBox.Name = "ux_scenarioSummaryCheckBox";
            this.ux_scenarioSummaryCheckBox.Size = new System.Drawing.Size(152, 16);
            this.ux_scenarioSummaryCheckBox.TabIndex = 4;
            this.ux_scenarioSummaryCheckBox.Text = "Scenario Summary report";
            this.Controls.AddRange(
                new Control[] {
                                  this.ux_bodyLabel,
                                  this.ux_industryCheckBox,
                                  this.ux_manufacturersCheckBox,
                                  this.ux_vehiclesCheckBox,
                                  this.ux_scenarioSummaryCheckBox
                              });
            this.Name = "NSW_SelectReports";
            this.Size = new System.Drawing.Size(416, 335);
            this.ResumeLayout(false);
        }
        public void SetInitialState(ModelingSettings modelingSettings)
        {
            this.ux_industryCheckBox.Checked =
                modelingSettings.OutputSettings.GenerateIndustryReport;
            this.ux_manufacturersCheckBox.Checked =
                modelingSettings.OutputSettings.GenerateManufacturersReport;
            this.ux_vehiclesCheckBox.Checked =
                modelingSettings.OutputSettings.GenerateVehiclesReport;
            this.ux_scenarioSummaryCheckBox.Checked =
                modelingSettings.OutputSettings.GenerateScenarioSummaryReport;
        }
        #endregion
        #region 
        public bool IndustryReport
        {
            get
            {
                return this.ux_industryCheckBox.Checked;
            }
        }
        public bool ManufacturersReport
        {
            get
            {
                return this.ux_manufacturersCheckBox.Checked;
            }
        }
        public bool VehiclesReport
        {
            get
            {
                return this.ux_vehiclesCheckBox.Checked;
            }
        }
        public bool ScenarioSummaryReport
        {
            get
            {
                return this.ux_scenarioSummaryCheckBox.Checked;
            }
        }
        #endregion
        #region 
        #region 
        private System.Windows.Forms.Label ux_bodyLabel;
        private System.Windows.Forms.CheckBox ux_industryCheckBox;
        private System.Windows.Forms.CheckBox ux_manufacturersCheckBox;
        private System.Windows.Forms.CheckBox ux_vehiclesCheckBox;
        private System.Windows.Forms.CheckBox ux_scenarioSummaryCheckBox;
        protected System.ComponentModel.IContainer components = null;
        #endregion
        #endregion
    }
}

