using System;
using System.Collections;
using Volpe.Cafe.Data;
using Volpe.Cafe.Model;
namespace Volpe.Cafe.Collections
{
    [Serializable]
    public sealed class ComplianceCollection : CollectionBase
    {
        #region 
        public ComplianceCollection() : base()
        {
        }
        public ComplianceCollection(int capacity) : base()
        {
            this.InnerList.Capacity = capacity;
        }
        #endregion
        #region 
        public int Add(ICompliance value)
        {
            return this.InnerList.Add(value);
        }
        public void AddRange(ICollection values)
        {
            this.InnerList.AddRange(values);
        }
        public void Insert(int index, ICompliance value)
        {
            this.InnerList.Insert(index, value);
        }
        public void InsertRange(int index, ICollection values)
        {
            this.InnerList.InsertRange(index, values);
        }
        public void Remove(ICompliance value)
        {
            this.InnerList.Remove(value);
        }
        public new void RemoveAt(int index)
        {
            base.RemoveAt(index);
        }
        public new void Clear()
        {
            base.Clear();
        }
        public bool Contains(ICompliance value)
        {
            return this.InnerList.Contains(value);
        }
        public int IndexOf(ICompliance value)
        {
            return this.InnerList.IndexOf(value);
        }
        public int IndexOf(ICompliance value, int startIndex)
        {
            return this.InnerList.IndexOf(value, startIndex);
        }
        public int IndexOf(ICompliance value, int startIndex, int count)
        {
            return this.InnerList.IndexOf(value, startIndex, count);
        }
        public void CopyTo(ICompliance[] array)
        {
            this.CopyTo(array, 0);
        }
        public void CopyTo(ICompliance[] array, int index)
        {
            this.InnerList.CopyTo(array, index);
        }
        public ICompliance[] ToArray()
        {
            ICompliance[] array = new ICompliance[this.Count];
            this.CopyTo(array, 0);
            return array;
        }
        public new IEnumerator GetEnumerator()
        {
            return base.GetEnumerator();
        }
        #endregion
        #region 
        public ICompliance this[int index]
        {
            get { return (ICompliance)(this.InnerList[index]); }
            set { this.InnerList[index] = value; }
        }
        public new int Count { get { return base.Count; } }
        public int Capacity
        {
            get { return this.InnerList.Capacity; }
            set { this.InnerList.Capacity = value; }
        }
        public bool IsReadOnly { get { return this.InnerList.IsReadOnly; } }
        public bool IsFixedSize { get { return this.InnerList.IsFixedSize; } }
        public bool IsSynchronized { get { return this.InnerList.IsSynchronized; } }
        public object SyncRoot { get { return this.InnerList.SyncRoot; } }
        #endregion
    }
}

