using System;
using Volpe.Cafe;
using Volpe.Cafe.Collections;
namespace Volpe.Cafe.Data
{
    [Serializable]
    public class Engine : Component, ICloneable
    {
        #region 
        private Engine()
            : base()
        {
        }
        public Engine(EngineDescription description)
            : base()
        {
            this._description = description;
            this._modelingData = new ComponentModelingData();
        }
        #endregion
        #region 
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        public Engine Clone()
        {
            Engine eng = new Engine();
            eng._description = (EngineDescription)this._description.Clone();
            this.CopyTo(eng);
            return eng;
        }
        #endregion
        internal void Validate()
        {
            this._valid = true;        
            System.Collections.Specialized.StringCollection err = new System.Collections.Specialized.StringCollection();
            if (!this._initialized)
            {
                this._valid = false;
                err.Add("The Engine has not been initialized.");
            }
            else if ((this._description.Code < 1)      ||
                (this._description.Fuel.Equals(""))    ||
                (this._description.Cycle == '\0')      ||
                (this._description.Aspiration == '\0') ||
                (this._description.Cylinders < 1)      ||
                (this._description.ValvesPerCylinder < 1))
            {
                this._valid = false;
                if (this._description.Code < 1)              { err.Add("The Engine Code, " + this._description.Code + ", is not valid."); }
                if (this._description.Fuel == "")            { err.Add("The Engine's Fuel type is missing."); }
                if (this._description.Cycle == '\0')         { err.Add("The Engine's Cycle is missing."); }
                if (this._description.Aspiration == '\0')    { err.Add("The Engine's Aspiration is missing."); }
                if (this._description.Cylinders < 1)         { err.Add("The Engine's number of Cylinders, " + this._description.Cylinders + ", is not valid."); }
                if (this._description.ValvesPerCylinder < 1) { err.Add("The Engine's number of Valves/Cylinder, " + this._description.ValvesPerCylinder + ", is not valid."); }
            }
            if (!this._valid)
            {
                this._invalidReasons = new string[err.Count];
                err.CopyTo(this._invalidReasons, 0);
            }
        }
        internal void SetParent(int parentCode)
        {
            if (parentCode != -1)
            {
                Engine[] engs = this._manufacturer.Engines.ToArray();
                for (int i = 0; i < engs.Length; i++)
                {
                    if (parentCode == engs[i]._description.Code)
                    {
                        this._parent = engs[i];
                        break;
                    }
                }
            }
        }
        internal void SetParent(Engine value)
        {
            this._parent = value;
        }
        public Engine Split(VehicleCollection vehicles, int newCode)
        {
            Engine eng = (Engine)this.Clone();
            newCode = Math.Max(newCode, eng._manufacturer.GetNextEngineCode());;
            eng._description.Code = newCode;
            eng._manufacturer.LastEngCode = newCode;
            for (int i = 0, vehCount = vehicles.Count; i < vehCount; i++)
            {
                vehicles[i].SetEngine(eng);
            }
            this.SplitTo(vehicles, eng);
            return eng;
        }
        #endregion
        #region 
        public EngineDescription Description
        {
            get { return this._description; }
        }
        public Engine Parent
        {
            get { return (Engine)this._parent; }
        }
        #endregion
        #region 
        private EngineDescription _description;
        #endregion
    }
}

